/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory;

import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.Container;
import net.minecraft.core.player.inventory.IInventory;

public class InventoryCrafting
implements IInventory {
    private ItemStack[] stackList;
    private int field_21104_b;
    private Container eventHandler;

    public InventoryCrafting(Container container, int i, int j) {
        int k = i * j;
        this.stackList = new ItemStack[k];
        this.eventHandler = container;
        this.field_21104_b = i;
    }

    @Override
    public int getSizeInventory() {
        return this.stackList.length;
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        if (i >= this.getSizeInventory()) {
            return null;
        }
        return this.stackList[i];
    }

    public ItemStack getItemStackAt(int i, int j) {
        if (i < 0 || i >= this.field_21104_b) {
            return null;
        }
        int k = i + j * this.field_21104_b;
        return this.getStackInSlot(k);
    }

    public void setSlotContentsAt(int i, int j, ItemStack itemStack) {
        if (i < 0 || i >= this.field_21104_b) {
            return;
        }
        int k = i + j * this.field_21104_b;
        this.setInventorySlotContents(k, itemStack);
    }

    @Override
    public String getInvName() {
        return "Crafting";
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        if (this.stackList[i] != null) {
            if (this.stackList[i].stackSize <= j) {
                ItemStack itemstack = this.stackList[i];
                this.stackList[i] = null;
                this.eventHandler.onCraftMatrixChanged(this);
                return itemstack;
            }
            ItemStack itemstack1 = this.stackList[i].splitStack(j);
            if (this.stackList[i].stackSize <= 0) {
                this.stackList[i] = null;
            }
            this.eventHandler.onCraftMatrixChanged(this);
            return itemstack1;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.stackList[i] = itemstack;
        this.eventHandler.onCraftMatrixChanged(this);
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public void onInventoryChanged() {
        this.eventHandler.onCraftMatrixChanged(this);
    }

    @Override
    public boolean canInteractWith(EntityPlayer entityplayer) {
        return true;
    }
}

