/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory.slot;

import net.minecraft.core.achievement.AchievementList;
import net.minecraft.core.block.Block;
import net.minecraft.core.crafting.CraftingManager;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.IInventory;
import net.minecraft.core.player.inventory.InventoryCrafting;
import net.minecraft.core.player.inventory.slot.Slot;

public class SlotCrafting
extends Slot {
    private final IInventory craftMatrix;
    private EntityPlayer thePlayer;

    public SlotCrafting(EntityPlayer entityplayer, IInventory iinventory, IInventory iinventory1, int i, int j, int k) {
        super(iinventory1, i, j, k);
        this.thePlayer = entityplayer;
        this.craftMatrix = iinventory;
    }

    @Override
    public boolean canPutStackInSlot(ItemStack itemstack) {
        return false;
    }

    @Override
    public void onPickupFromSlot(ItemStack itemstack) {
        itemstack.onCrafting(this.thePlayer.world, this.thePlayer);
        if (itemstack.itemID == Block.workbench.id) {
            this.thePlayer.addStat(AchievementList.BUILD_WORKBENCH, 1);
        } else if (itemstack.itemID == Item.toolPickaxeWood.id) {
            this.thePlayer.addStat(AchievementList.BUILD_PICKAXE, 1);
        } else if (itemstack.itemID == Block.furnaceStoneIdle.id) {
            this.thePlayer.addStat(AchievementList.BUILD_FURNACE, 1);
        } else if (itemstack.itemID == Item.toolHoeWood.id) {
            this.thePlayer.addStat(AchievementList.BUILD_HOE, 1);
        } else if (itemstack.itemID == Item.foodBread.id) {
            this.thePlayer.addStat(AchievementList.MAKE_BREAD, 1);
        } else if (itemstack.itemID == Item.foodCake.id) {
            this.thePlayer.addStat(AchievementList.BAKE_CAKE, 1);
        } else if (itemstack.itemID == Item.toolPickaxeStone.id) {
            this.thePlayer.addStat(AchievementList.BUILD_BETTER_PICKAXE, 1);
        } else if (itemstack.itemID == Item.toolSwordWood.id) {
            this.thePlayer.addStat(AchievementList.BUILD_SWORD, 1);
        } else if (itemstack.itemID == Item.handcannonUnloaded.id) {
            this.thePlayer.addStat(AchievementList.CRAFT_HANDCANNON, 1);
        } else if (itemstack.itemID == Item.armorBootsChainmail.id || itemstack.itemID == Item.armorHelmetChainmail.id || itemstack.itemID == Item.armorChestplateChainmail.id || itemstack.itemID == Item.armorLeggingsChainmail.id) {
            this.thePlayer.addStat(AchievementList.REPAIR_ARMOR, 1);
        }
        CraftingManager.getInstance().onCraftResult((InventoryCrafting)this.craftMatrix);
    }

    @Override
    public boolean enableDragAndPickup() {
        return false;
    }

    @Override
    public boolean allowItemInteraction() {
        return false;
    }
}

