/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util.helper;

import java.io.PrintStream;
import java.time.LocalTime;

public class LogPrintStream
extends PrintStream {
    public static boolean stackTrace = false;
    public static boolean time = true;
    public static boolean thread = true;
    private PrintStream old;

    public static void setup() {
        System.setOut(new LogPrintStream(System.out));
        System.setErr(new LogPrintStream(System.err));
    }

    public LogPrintStream(PrintStream printStream) {
        super(printStream);
        this.old = printStream;
    }

    @Override
    public void println(boolean x) {
        this.formatPrintLine(Boolean.valueOf(x).toString());
    }

    @Override
    public void println(int x) {
        this.formatPrintLine(Integer.valueOf(x).toString());
    }

    @Override
    public void println(long x) {
        this.formatPrintLine(Long.valueOf(x).toString());
    }

    @Override
    public void println(float x) {
        this.formatPrintLine(Float.valueOf(x).toString());
    }

    @Override
    public void println(double x) {
        this.formatPrintLine(Double.valueOf(x).toString());
    }

    @Override
    public void println(char x) {
        this.formatPrintLine(Character.valueOf(x).toString());
    }

    @Override
    public void println(String a) {
        this.formatPrintLine(a);
    }

    @Override
    public void println(Object x) {
        if (x != null) {
            this.formatPrintLine(x.toString());
        } else {
            this.formatPrintLine(null);
        }
    }

    @Override
    public void println(char[] x) {
        this.formatPrintLine(new String(x));
    }

    public void formatPrintLine(String s) {
        this.formatPrint(s + "\n", 1);
    }

    private void formatPrint(String string, int stackTraceOffset) {
        string = LogPrintStream.removeColorCodes(string);
        if (stackTrace) {
            string = Thread.currentThread().getStackTrace()[3 + stackTraceOffset] + " " + string;
        }
        if (thread) {
            string = "[" + Thread.currentThread().getName() + "] " + string;
        }
        if (time) {
            LocalTime localTime = LocalTime.now();
            StringBuilder timeString = new StringBuilder();
            if (localTime.getHour() < 10) {
                timeString.append("0");
            }
            timeString.append(localTime.getHour());
            timeString.append(":");
            if (localTime.getMinute() < 10) {
                timeString.append("0");
            }
            timeString.append(localTime.getMinute());
            timeString.append(":");
            if (localTime.getSecond() < 10) {
                timeString.append("0");
            }
            timeString.append(localTime.getSecond());
            string = "[" + timeString.toString() + "] " + string;
        }
        this.old.print(string);
    }

    public static String removeColorCodes(String string) {
        StringBuilder builder = new StringBuilder();
        boolean a = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u00a7') {
                a = true;
                continue;
            }
            if (a) {
                a = false;
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }
}

