/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util.helper;

public class MathHelper {
    private static final float[] SIN_TABLE = new float[65536];
    public static final float PI = (float)Math.PI;

    public static float sin(float f) {
        return SIN_TABLE[(int)(f * 10430.38f) & 0xFFFF];
    }

    public static float cos(float f) {
        return SIN_TABLE[(int)(f * 10430.38f + 16384.0f) & 0xFFFF];
    }

    public static float sqrt_float(float f) {
        return (float)Math.sqrt(f);
    }

    public static float sqrt_double(double d) {
        return (float)Math.sqrt(d);
    }

    public static int floor_float(float f) {
        int i = (int)f;
        return f >= (float)i ? i : i - 1;
    }

    public static int floor_double(double d) {
        int i = (int)d;
        return d >= (double)i ? i : i - 1;
    }

    public static float abs(float f) {
        return f < 0.0f ? -f : f;
    }

    public static double abs_max(double d, double d1) {
        if (d < 0.0) {
            d = -d;
        }
        if (d1 < 0.0) {
            d1 = -d1;
        }
        return Math.max(d, d1);
    }

    public static int bucketInt(int value, int bucket) {
        if (value < 0) {
            return -((-value - 1) / bucket) - 1;
        }
        return value / bucket;
    }

    public static double clamp(double value, double min, double max) {
        if (value > max) {
            return max;
        }
        return Math.max(value, min);
    }

    public static float clamp(float value, float min, float max) {
        if (value > max) {
            return max;
        }
        return Math.max(value, min);
    }

    public static int clamp(int value, int min, int max) {
        if (value > max) {
            return max;
        }
        return Math.max(value, min);
    }

    public static float lerp(float a, float b, float amount) {
        return a + (b - a) * amount;
    }

    public static boolean stringNullOrLengthZero(String s) {
        return s == null || s.length() == 0;
    }

    static {
        for (int i = 0; i < 65536; ++i) {
            MathHelper.SIN_TABLE[i] = (float)Math.sin((double)i * Math.PI * 2.0 / 65536.0);
        }
    }
}

