/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.chunk.Chunk;

public class ChunkCache
implements WorldSource {
    private int chunkX;
    private int chunkZ;
    private Chunk[][] chunkArray;
    private World worldObj;

    public ChunkCache(World world, int i, int j, int k, int l, int i1, int j1) {
        this.worldObj = world;
        this.chunkX = i >> 4;
        this.chunkZ = k >> 4;
        int k1 = l >> 4;
        int l1 = j1 >> 4;
        this.chunkArray = new Chunk[k1 - this.chunkX + 1][l1 - this.chunkZ + 1];
        for (int i2 = this.chunkX; i2 <= k1; ++i2) {
            for (int j2 = this.chunkZ; j2 <= l1; ++j2) {
                this.chunkArray[i2 - this.chunkX][j2 - this.chunkZ] = world.getChunkFromChunkCoords(i2, j2);
            }
        }
    }

    @Override
    public int getBlockId(int x, int y, int z) {
        if (y < 0) {
            return 0;
        }
        if (y >= this.worldObj.getHeightBlocks()) {
            return 0;
        }
        int l = (x >> 4) - this.chunkX;
        int i1 = (z >> 4) - this.chunkZ;
        if (l < 0 || l >= this.chunkArray.length || i1 < 0 || i1 >= this.chunkArray[l].length) {
            return 0;
        }
        Chunk chunk = this.chunkArray[l][i1];
        if (chunk == null) {
            return 0;
        }
        return chunk.getBlockID(x & 0xF, y, z & 0xF);
    }

    @Override
    public Block getBlock(int x, int y, int z) {
        return Block.getBlock(this.getBlockId(x, y, z));
    }

    @Override
    public TileEntity getBlockTileEntity(int x, int y, int z) {
        int l = (x >> 4) - this.chunkX;
        int i1 = (z >> 4) - this.chunkZ;
        return this.chunkArray[l][i1].getChunkBlockTileEntity(x & 0xF, y, z & 0xF);
    }

    public boolean getBlockLitInteriorSurface(int i, int j, int k) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return true;
        }
        if (j < 0) {
            return true;
        }
        if (j >= this.worldObj.getHeightBlocks()) {
            return true;
        }
        return Block.getIsLitInteriorSurface(this.worldObj, i, j, k);
    }

    @Override
    public float getBrightness(int x, int y, int z, int blockLightValue) {
        int i1 = this.getLightValue(x, y, z);
        if (i1 < blockLightValue) {
            i1 = blockLightValue;
        }
        return this.worldObj.worldType.getBrightnessRamp()[i1];
    }

    @Override
    public float getLightBrightness(int x, int y, int z) {
        return this.worldObj.worldType.getBrightnessRamp()[this.getLightValue(x, y, z)];
    }

    public int getLightValue(int i, int j, int k) {
        return this.getLightValueExt(i, j, k, true);
    }

    public int getLightValueExt(int i, int j, int k, boolean flag) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return 15;
        }
        if (flag && this.getBlockLitInteriorSurface(i, j, k)) {
            int k1 = this.getLightValueExt(i, j + 1, k, false);
            int i2 = this.getLightValueExt(i + 1, j, k, false);
            int j2 = this.getLightValueExt(i - 1, j, k, false);
            int k2 = this.getLightValueExt(i, j, k + 1, false);
            int l2 = this.getLightValueExt(i, j, k - 1, false);
            if (i2 > k1) {
                k1 = i2;
            }
            if (j2 > k1) {
                k1 = j2;
            }
            if (k2 > k1) {
                k1 = k2;
            }
            if (l2 > k1) {
                k1 = l2;
            }
            return k1;
        }
        if (j < 0) {
            return 0;
        }
        if (j >= this.worldObj.getHeightBlocks()) {
            int i1 = 15 - this.worldObj.skyDarken;
            if (i1 < 0) {
                i1 = 0;
            }
            return i1;
        }
        int j1 = (i >> 4) - this.chunkX;
        int l1 = (k >> 4) - this.chunkZ;
        return this.chunkArray[j1][l1].getBlockLightValue(i & 0xF, j, k & 0xF, this.worldObj.skyDarken);
    }

    @Override
    public int getBlockMetadata(int x, int y, int z) {
        if (y < 0) {
            return 0;
        }
        if (y >= this.worldObj.getHeightBlocks()) {
            return 0;
        }
        int chunkX = (x >> 4) - this.chunkX;
        int chunkZ = (z >> 4) - this.chunkZ;
        return this.chunkArray[chunkX][chunkZ].getBlockMetadata(x & 0xF, y, z & 0xF);
    }

    @Override
    public Material getBlockMaterial(int x, int y, int z) {
        int l = this.getBlockId(x, y, z);
        if (l == 0) {
            return Material.air;
        }
        return Block.blocksList[l].blockMaterial;
    }

    @Override
    public BiomeProvider getBiomeProvider() {
        return this.worldObj.getBiomeProvider();
    }

    @Override
    public boolean isBlockOpaqueCube(int x, int y, int z) {
        Block block = Block.blocksList[this.getBlockId(x, y, z)];
        if (block == null) {
            return false;
        }
        return block.isOpaqueCube();
    }

    @Override
    public boolean isBlockNormalCube(int x, int y, int z) {
        Block block = Block.blocksList[this.getBlockId(x, y, z)];
        if (block == null) {
            return false;
        }
        return block.blockMaterial.blocksMotion() && block.renderAsNormalBlock();
    }
}

