/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.ListTag;
import com.mojang.nbt.NbtIo;
import com.mojang.nbt.Tag;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.chunk.reader.ChunkReader;
import net.minecraft.core.world.chunk.reader.ChunkReaderLegacy;
import net.minecraft.core.world.chunk.reader.ChunkReaderVersion1;
import net.minecraft.core.world.chunk.writer.ChunkWriter;
import net.minecraft.core.world.data.ChunkNibbleArray;
import net.minecraft.core.world.data.ChunkUnsignedByteArray;
import net.minecraft.core.world.save.LevelData;

public class ChunkLoaderLegacy
implements IChunkLoader {
    private File worldDir;
    private boolean createIfNecessary;

    public ChunkLoaderLegacy(File worldDir, boolean createIfNecessary) {
        this.worldDir = worldDir;
        this.createIfNecessary = createIfNecessary;
    }

    private File chunkFileForXZ(int x, int z) {
        String fileName = "c." + Integer.toString(x, 36) + "." + Integer.toString(z, 36) + ".dat";
        String xDirName = Integer.toString(x & 0x3F, 36);
        String zDirName = Integer.toString(z & 0x3F, 36);
        File dir = new File(this.worldDir, xDirName);
        if (!dir.exists()) {
            if (this.createIfNecessary) {
                dir.mkdir();
            } else {
                return null;
            }
        }
        if (!(dir = new File(dir, zDirName)).exists()) {
            if (this.createIfNecessary) {
                dir.mkdir();
            } else {
                return null;
            }
        }
        if (!(dir = new File(dir, fileName)).exists() && !this.createIfNecessary) {
            return null;
        }
        return dir;
    }

    @Override
    public Chunk loadChunk(World world, int x, int z) throws IOException {
        File file = this.chunkFileForXZ(x, z);
        if (file != null && file.exists()) {
            try {
                FileInputStream fileStream = new FileInputStream(file);
                CompoundTag tag = NbtIo.readCompressed(fileStream);
                if (!tag.containsKey("Level")) {
                    System.out.println("Chunk file at " + x + "," + z + " is missing level data, skipping");
                    return null;
                }
                if (!tag.getCompound("Level").containsKey("Blocks")) {
                    System.out.println("Chunk file at " + x + "," + z + " is missing block data, skipping");
                    return null;
                }
                Chunk chunk = ChunkLoaderLegacy.loadChunkIntoWorldFromCompound(world, tag.getCompound("Level"));
                if (!chunk.isAtLocation(x, z)) {
                    System.out.println("Chunk file at " + x + "," + z + " is in the wrong location; relocating. (Expected " + x + ", " + z + ", got " + chunk.xPosition + ", " + chunk.zPosition + ")");
                    tag.putInt("xPos", x);
                    tag.putInt("zPos", z);
                    chunk = ChunkLoaderLegacy.loadChunkIntoWorldFromCompound(world, tag.getCompound("Level"));
                }
                chunk.fixMissingBlocks();
                return chunk;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void saveChunk(World world, Chunk chunk) throws IOException {
        world.checkSessionLock();
        File chunkFile = this.chunkFileForXZ(chunk.xPosition, chunk.zPosition);
        if (chunkFile.exists()) {
            LevelData levelData = world.getLevelData();
            levelData.setSizeOnDisk(levelData.getSizeOnDisk() - chunkFile.length());
        }
        try {
            File tmpChunkFile = new File(this.worldDir, "tmp_chunk.dat");
            FileOutputStream fileStream = new FileOutputStream(tmpChunkFile);
            CompoundTag levelTag = new CompoundTag();
            CompoundTag chunkDataTag = new CompoundTag();
            levelTag.put("Level", chunkDataTag);
            ChunkLoaderLegacy.storeChunkInCompound(chunk, world, chunkDataTag);
            NbtIo.writeCompressed(levelTag, fileStream);
            fileStream.close();
            if (chunkFile.exists()) {
                chunkFile.delete();
            }
            tmpChunkFile.renameTo(chunkFile);
            LevelData levelData = world.getLevelData();
            levelData.setSizeOnDisk(levelData.getSizeOnDisk() + chunkFile.length());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void storeChunkInCompound(Chunk chunk, World world, CompoundTag tag) {
        world.checkSessionLock();
        ChunkWriter writer = new ChunkWriter(world, tag);
        tag.putInt("Version", 1);
        writer.putXPos(chunk.xPosition);
        writer.putZPos(chunk.zPosition);
        writer.putLastUpdate(world.getWorldTime());
        writer.putBlocks(chunk.blocks);
        writer.putData(chunk.data);
        writer.putSkyLight(chunk.skylightMap);
        writer.putBlockLight(chunk.blocklightMap);
        writer.putHeightMap(chunk.heightMap);
        writer.putAverageBlockHeight(chunk.averageBlockHeight);
        writer.putTerrainPopulated(chunk.isTerrainPopulated);
        writer.putTemperatureMap(chunk.temperature);
        writer.putHumidityMap(chunk.humidity);
        writer.putBiomeMap(chunk.biome);
        chunk.hasEntities = false;
        ListTag entityListTag = new ListTag();
        for (int i = 0; i < chunk.entities.length; ++i) {
            for (Entity entity : chunk.entities[i]) {
                chunk.hasEntities = true;
                CompoundTag entityTag = new CompoundTag();
                if (!entity.save(entityTag)) continue;
                entityListTag.addTag(entityTag);
            }
        }
        tag.put("Entities", entityListTag);
        ListTag tileEntityListTag = new ListTag();
        for (TileEntity tileEntity : chunk.tileEntityMap.values()) {
            CompoundTag tileEntityTag = new CompoundTag();
            tileEntity.writeToNBT(tileEntityTag);
            tileEntityListTag.addTag(tileEntityTag);
        }
        tag.put("TileEntities", tileEntityListTag);
    }

    public static Chunk loadChunkIntoWorldFromCompound(World world, CompoundTag tag) {
        ListTag tileEntityListTag;
        ListTag entityListTag;
        int version = tag.getIntegerOrDefault("Version", -1);
        ChunkReader reader = ChunkLoaderLegacy.getChunkReaderByVersion(world, tag, version);
        int x = reader.getX();
        int z = reader.getZ();
        Chunk chunk = new Chunk(world, x, z);
        chunk.blocks = reader.getBlocks();
        chunk.data = reader.getData();
        chunk.skylightMap = reader.getSkyLight();
        chunk.blocklightMap = reader.getBlockLight();
        chunk.heightMap = reader.getHeightMap();
        chunk.averageBlockHeight = reader.getAverageBlockHeight();
        chunk.isTerrainPopulated = reader.getIsTerrainPopulated();
        chunk.temperature = reader.getTemperatureMap();
        chunk.humidity = reader.getHumidityMap();
        chunk.biome = reader.getBiomeMap();
        if (!chunk.data.isValid()) {
            chunk.data = new ChunkUnsignedByteArray(16, world.getHeightBlocks(), 16);
        }
        if (chunk.heightMap == null || !chunk.skylightMap.isValid() || chunk.skylightMap.data.length != 256 * world.getHeightBlocks() / 2) {
            chunk.heightMap = new short[256];
            chunk.skylightMap = new ChunkNibbleArray(16, world.getHeightBlocks(), 16);
            chunk.generateMaps();
        }
        if (!chunk.blocklightMap.isValid() || chunk.blocklightMap.data.length != 256 * world.getHeightBlocks() / 2) {
            chunk.blocklightMap = new ChunkNibbleArray(16, world.getHeightBlocks(), 16);
        }
        if (chunk.temperature == null || chunk.temperature.length == 0) {
            chunk.temperature = new double[256];
            Arrays.fill(chunk.temperature, Double.NEGATIVE_INFINITY);
        }
        if (chunk.humidity == null || chunk.humidity.length == 0) {
            chunk.humidity = new double[256];
            Arrays.fill(chunk.humidity, Double.NEGATIVE_INFINITY);
        }
        if (chunk.biome == null || chunk.biome.length != 256 * (world.getHeightBlocks() >> 3)) {
            chunk.biome = new byte[256 * (world.getHeightBlocks() >> 3)];
            Arrays.fill(chunk.biome, (byte)-1);
        }
        if ((entityListTag = tag.getList("Entities")) != null) {
            for (Tag<?> entityTagBase : entityListTag) {
                if (!(entityTagBase instanceof CompoundTag)) continue;
                CompoundTag entityTag = (CompoundTag)entityTagBase;
                Entity entity = EntityDispatcher.createEntityFromNBT(entityTag, world);
                chunk.hasEntities = true;
                if (entity == null) continue;
                chunk.addEntity(entity);
            }
        }
        if ((tileEntityListTag = tag.getList("TileEntities")) != null) {
            for (Tag<?> tileEntityTagBase : tileEntityListTag) {
                CompoundTag tileEntityTag;
                TileEntity tileEntity;
                if (!(tileEntityTagBase instanceof CompoundTag) || (tileEntity = TileEntity.createAndLoadEntity(tileEntityTag = (CompoundTag)tileEntityTagBase)) == null) continue;
                chunk.addTileEntity(tileEntity);
            }
        }
        return chunk;
    }

    private static ChunkReader getChunkReaderByVersion(World world, CompoundTag tag, int version) {
        switch (version) {
            case 1: {
                return new ChunkReaderVersion1(world, tag);
            }
        }
        return new ChunkReaderLegacy(world, tag);
    }
}

