/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk.perlin;

import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.MapGenBase;
import net.minecraft.core.world.generate.chunk.ChunkDecorator;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.generate.chunk.perlin.SurfaceGenerator;
import net.minecraft.core.world.generate.chunk.perlin.TerrainGenerator;

public class ChunkGeneratorPerlin
extends ChunkGenerator {
    private final TerrainGenerator terrainGenerator;
    private final SurfaceGenerator surfaceGenerator;
    private final MapGenBase cavesGenerator;

    protected ChunkGeneratorPerlin(World world, ChunkDecorator decorator, TerrainGenerator terrainGenerator, SurfaceGenerator surfaceGenerator, MapGenBase cavesGenerator) {
        super(world, decorator);
        this.terrainGenerator = terrainGenerator;
        this.surfaceGenerator = surfaceGenerator;
        this.cavesGenerator = cavesGenerator;
    }

    @Override
    protected short[] doBlockGeneration(Chunk chunk) {
        double[] densityMap = this.terrainGenerator.getDensityGenerator().generateDensityMap(chunk);
        short[] blocks = this.terrainGenerator.generateTerrain(chunk, densityMap);
        this.surfaceGenerator.generateSurface(chunk, blocks);
        this.cavesGenerator.generate(this.world, chunk.xPosition, chunk.zPosition, blocks);
        return blocks;
    }
}

