/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk.perlin.nether;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockSand;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.ChunkDecorator;
import net.minecraft.core.world.generate.feature.WorldFeatureFire;
import net.minecraft.core.world.generate.feature.WorldFeatureGlowstoneA;
import net.minecraft.core.world.generate.feature.WorldFeatureGlowstoneB;
import net.minecraft.core.world.generate.feature.WorldFeatureLake;
import net.minecraft.core.world.generate.feature.WorldFeatureNetherLava;
import net.minecraft.core.world.generate.feature.WorldFeatureOre;

public class ChunkDecoratorNether
implements ChunkDecorator {
    private final World world;

    public ChunkDecoratorNether(World world) {
        this.world = world;
    }

    @Override
    public void decorate(Chunk chunk) {
        int zf;
        int yf;
        int xf;
        int i;
        int zf2;
        int yf2;
        int xf2;
        int i2;
        int chunkX = chunk.xPosition;
        int chunkZ = chunk.zPosition;
        int minY = this.world.getWorldType().getMinY();
        int maxY = this.world.getWorldType().getMaxY();
        int rangeY = maxY + 1 - minY;
        Random rand = new Random((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        BlockSand.fallInstantly = true;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        for (i2 = 0; i2 < 8; ++i2) {
            xf2 = x + rand.nextInt(16) + 8;
            yf2 = minY + rand.nextInt(rangeY - 8) + 4;
            zf2 = z + rand.nextInt(16) + 8;
            new WorldFeatureNetherLava(Block.fluidLavaFlowing.id).generate(this.world, rand, xf2, yf2, zf2);
        }
        for (i2 = 0; i2 < 10; ++i2) {
            xf2 = x + rand.nextInt(16);
            yf2 = minY + rand.nextInt(rangeY - 8) + 4;
            zf2 = z + rand.nextInt(16);
            new WorldFeatureOre(Block.oreNethercoalNetherrack.id, 12, false).generate(this.world, rand, xf2, yf2, zf2);
        }
        int max = rand.nextInt(rand.nextInt(10) + 1);
        for (i = 0; i < max; ++i) {
            xf = x + rand.nextInt(16) + 8;
            yf = minY + rand.nextInt(rangeY - 8) + 4;
            zf = z + rand.nextInt(16) + 8;
            new WorldFeatureFire().generate(this.world, rand, xf, yf, zf);
        }
        max = rand.nextInt(rand.nextInt(10) + 1);
        for (i = 0; i < max; ++i) {
            xf = x + rand.nextInt(16) + 8;
            yf = minY + rand.nextInt(rangeY - 8) + 4;
            zf = z + rand.nextInt(16) + 8;
            new WorldFeatureGlowstoneA().generate(this.world, rand, xf, yf, zf);
        }
        for (i = 0; i < 10; ++i) {
            xf = x + rand.nextInt(16) + 8;
            yf = minY + rand.nextInt(rangeY - 8) + 4;
            zf = z + rand.nextInt(16) + 8;
            new WorldFeatureGlowstoneB().generate(this.world, rand, xf, yf, zf);
        }
        if (rand.nextInt(8) == 0) {
            xf2 = x + rand.nextInt(16) + 8;
            yf2 = minY + rand.nextInt(rangeY - 16) + 8;
            zf2 = z + rand.nextInt(16) + 8;
            new WorldFeatureLake(Block.fluidLavaStill.id).generate(this.world, rand, xf2, yf2, zf2);
        }
        BlockSand.fallInstantly = false;
    }
}

