/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature.tree;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;

public class WorldFeatureTree
extends WorldFeature {
    protected int leavesID;
    protected int logID;
    protected int heightMod;

    public WorldFeatureTree(int leavesID, int logID, int heightMod) {
        this.leavesID = leavesID;
        this.logID = logID;
        this.heightMod = heightMod;
    }

    @Override
    public boolean generate(World world, Random random, int x, int y, int z) {
        int l = random.nextInt(3) + this.heightMod;
        boolean flag = true;
        if (y < 1 || y + l + 1 > world.getHeightBlocks()) {
            return false;
        }
        for (int i1 = y; i1 <= y + 1 + l; ++i1) {
            int byte0 = 1;
            if (i1 == y) {
                byte0 = 0;
            }
            if (i1 >= y + 1 + l - 2) {
                byte0 = 2;
            }
            for (int i2 = x - byte0; i2 <= x + byte0 && flag; ++i2) {
                for (int l2 = z - byte0; l2 <= z + byte0 && flag; ++l2) {
                    if (i1 >= 0 && i1 < world.getHeightBlocks()) {
                        int j3 = world.getBlockId(i2, i1, l2);
                        if (j3 == 0 || j3 == this.leavesID) continue;
                        flag = false;
                        continue;
                    }
                    flag = false;
                }
            }
        }
        if (!flag) {
            return false;
        }
        int j1 = world.getBlockId(x, y - 1, z);
        if (!Block.hasTag(j1, BlockTags.GROWS_TREES) || y >= world.getHeightBlocks() - l - 1) {
            return false;
        }
        world.setBlockWithNotify(x, y - 1, z, Block.dirt.id);
        for (int k1 = y - 3 + l; k1 <= y + l; ++k1) {
            int j2 = k1 - (y + l);
            int i3 = 1 - j2 / 2;
            for (int k3 = x - i3; k3 <= x + i3; ++k3) {
                int l3 = k3 - x;
                for (int i4 = z - i3; i4 <= z + i3; ++i4) {
                    int j4 = i4 - z;
                    if (Math.abs(l3) == i3 && Math.abs(j4) == i3 && (random.nextInt(2) == 0 || j2 == 0) || Block.opaqueCubeLookup[world.getBlockId(k3, k1, i4)]) continue;
                    world.setBlockWithNotify(k3, k1, i4, this.leavesID);
                }
            }
        }
        for (int l1 = 0; l1 < l; ++l1) {
            int k2 = world.getBlockId(x, y + l1, z);
            if (k2 != 0 && k2 != this.leavesID) continue;
            world.setBlockWithNotify(x, y + l1, z, this.logID);
        }
        return true;
    }
}

