/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.noise;

import java.util.Random;

public class SimplexNoise {
    private static final int[][] GRAD = new int[][]{{1, 1, 0}, {-1, 1, 0}, {1, -1, 0}, {-1, -1, 0}, {1, 0, 1}, {-1, 0, 1}, {1, 0, -1}, {-1, 0, -1}, {0, 1, 1}, {0, -1, 1}, {0, 1, -1}, {0, -1, -1}};
    private static final double F2 = 0.5 * (Math.sqrt(3.0) - 1.0);
    private static final double G2 = (3.0 - Math.sqrt(3.0)) / 6.0;
    private final int[] p = new int[512];
    public final double xo;
    public final double yo;
    public final double zo;

    public SimplexNoise(Random random) {
        int i;
        this.xo = random.nextDouble() * 256.0;
        this.yo = random.nextDouble() * 256.0;
        this.zo = random.nextDouble() * 256.0;
        for (i = 0; i < 256; ++i) {
            this.p[i] = i;
        }
        for (i = 0; i < 256; ++i) {
            int k = random.nextInt(256 - i) + i;
            int l = this.p[i];
            this.p[i] = this.p[k];
            this.p[k] = l;
            this.p[i + 256] = this.p[i];
        }
    }

    private static int wrap(double d) {
        return d <= 0.0 ? (int)d - 1 : (int)d;
    }

    private static double dot(int[] vec, double x, double y) {
        return (double)vec[0] * x + (double)vec[1] * y;
    }

    public void add(double[] out, double xSize, double d1, int i, int j, double d2, double d3, double d4) {
        int k = 0;
        for (int l = 0; l < i; ++l) {
            double d5 = (xSize + (double)l) * d2 + this.xo;
            for (int i1 = 0; i1 < j; ++i1) {
                double d9;
                double d8;
                double d7;
                int i2;
                int l1;
                double d13;
                double d15;
                int k1;
                double d11;
                double d6 = (d1 + (double)i1) * d3 + this.yo;
                double d10 = (d5 + d6) * F2;
                int j1 = SimplexNoise.wrap(d5 + d10);
                double d12 = (double)j1 - (d11 = (double)(j1 + (k1 = SimplexNoise.wrap(d6 + d10))) * G2);
                double d14 = d5 - d12;
                if (d14 > (d15 = d6 - (d13 = (double)k1 - d11))) {
                    l1 = 1;
                    i2 = 0;
                } else {
                    l1 = 0;
                    i2 = 1;
                }
                double d16 = d14 - (double)l1 + G2;
                double d17 = d15 - (double)i2 + G2;
                double d18 = d14 - 1.0 + 2.0 * G2;
                double d19 = d15 - 1.0 + 2.0 * G2;
                int j2 = j1 & 0xFF;
                int k2 = k1 & 0xFF;
                int l2 = this.p[j2 + this.p[k2]] % 12;
                int i3 = this.p[j2 + l1 + this.p[k2 + i2]] % 12;
                int j3 = this.p[j2 + 1 + this.p[k2 + 1]] % 12;
                double d20 = 0.5 - d14 * d14 - d15 * d15;
                if (d20 < 0.0) {
                    d7 = 0.0;
                } else {
                    d20 *= d20;
                    d7 = d20 * d20 * SimplexNoise.dot(GRAD[l2], d14, d15);
                }
                double d21 = 0.5 - d16 * d16 - d17 * d17;
                if (d21 < 0.0) {
                    d8 = 0.0;
                } else {
                    d21 *= d21;
                    d8 = d21 * d21 * SimplexNoise.dot(GRAD[i3], d16, d17);
                }
                double d22 = 0.5 - d18 * d18 - d19 * d19;
                if (d22 < 0.0) {
                    d9 = 0.0;
                } else {
                    d22 *= d22;
                    d9 = d22 * d22 * SimplexNoise.dot(GRAD[j3], d18, d19);
                }
                int n = k++;
                out[n] = out[n] + 70.0 * (d7 + d8 + d9) * d4;
            }
        }
    }
}

