/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.save;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.NbtIo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.save.DimensionData;
import net.minecraft.core.world.save.ISaveFormat;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.save.LevelStorage;
import net.minecraft.core.world.save.SaveFile;
import net.minecraft.core.world.save.SaveHandlerClientSP;

public abstract class SaveFormatBase
implements ISaveFormat {
    protected final File savesDir;

    public SaveFormatBase(File savesDir) {
        if (!savesDir.exists()) {
            savesDir.mkdirs();
        }
        this.savesDir = savesDir;
    }

    @Override
    public LevelData getLevelData(String worldDirName) {
        CompoundTag tag = this.getLevelDataRaw(worldDirName);
        if (tag == null) {
            return null;
        }
        return new LevelData(tag);
    }

    @Override
    public CompoundTag getLevelDataRaw(String worldDirName) {
        File worldDir = new File(this.savesDir, worldDirName);
        if (!worldDir.exists()) {
            return null;
        }
        File worldLevelDat = new File(worldDir, "level.dat");
        if (worldLevelDat.exists()) {
            try {
                CompoundTag nbtRoot = NbtIo.readCompressed(Files.newInputStream(worldLevelDat.toPath(), new OpenOption[0]));
                CompoundTag nbtRootData = nbtRoot.getCompound("Data");
                return nbtRootData;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if ((worldLevelDat = new File(worldDir, "level.dat_old")).exists()) {
            try {
                CompoundTag oldNbtRoot = NbtIo.readCompressed(Files.newInputStream(worldLevelDat.toPath(), new OpenOption[0]));
                CompoundTag oldNbtRootData = oldNbtRoot.getCompound("Data");
                return oldNbtRootData;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public DimensionData getDimensionData(String worldDirName, int dimensionId) {
        CompoundTag tag = this.getDimensionDataRaw(worldDirName, dimensionId);
        if (tag == null) {
            return null;
        }
        return new DimensionData(tag);
    }

    @Override
    public CompoundTag getDimensionDataRaw(String worldDirName, int dimensionId) {
        File worldDir = new File(this.savesDir, worldDirName);
        if (!worldDir.exists()) {
            return null;
        }
        File dimensionsDir = new File(worldDir, "dimensions");
        File dimensionDir = new File(dimensionsDir, "" + dimensionId);
        File dimensionDat = new File(dimensionDir, "dimension.dat");
        if (dimensionDat.exists()) {
            try {
                CompoundTag nbtRoot = NbtIo.readCompressed(Files.newInputStream(dimensionDat.toPath(), new OpenOption[0]));
                CompoundTag nbtRootData = nbtRoot.getCompound("Data");
                return nbtRootData;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if ((dimensionDat = new File(dimensionDir, "dimension.dat_old")).exists()) {
            try {
                CompoundTag oldNbtRoot = NbtIo.readCompressed(Files.newInputStream(dimensionDat.toPath(), new OpenOption[0]));
                CompoundTag oldNbtRootData = oldNbtRoot.getCompound("Data");
                return oldNbtRootData;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public List<SaveFile> getSaveFileList() {
        ArrayList<SaveFile> saveFileList = new ArrayList<SaveFile>();
        File[] saveDirFiles = this.savesDir.listFiles();
        if (saveDirFiles != null) {
            for (File file : saveDirFiles) {
                String worldDirName;
                LevelData levelData;
                if (!file.isDirectory() || (levelData = this.getLevelData(worldDirName = file.getName())) == null) continue;
                boolean needsConversion = levelData.getSaveVersion() != this.getSaveVersion();
                String worldName = levelData.getWorldName();
                if (worldName == null || MathHelper.stringNullOrLengthZero(worldName)) {
                    worldName = worldDirName;
                }
                DimensionData[] dimensionData = new DimensionData[Dimension.getDimensionList().size()];
                for (Dimension dimension : Dimension.getDimensionList().values()) {
                    dimensionData[dimension.id] = this.getDimensionData(worldDirName, dimension.id);
                }
                saveFileList.add(new SaveFile(worldDirName, worldName, levelData, dimensionData, levelData.getLastTimePlayed(), levelData.getSizeOnDisk(), needsConversion));
            }
        }
        return saveFileList;
    }

    @Override
    public void renameWorld(String worldDirName, String newName) {
        File worldDir = new File(this.savesDir, worldDirName);
        if (!worldDir.exists()) {
            return;
        }
        File worldLevelDat = new File(worldDir, "level.dat");
        if (worldLevelDat.exists()) {
            try {
                CompoundTag nbtRoot = NbtIo.readCompressed(new FileInputStream(worldLevelDat));
                CompoundTag nbtRootData = nbtRoot.getCompound("Data");
                nbtRootData.putString("LevelName", newName);
                NbtIo.writeCompressed(nbtRoot, new FileOutputStream(worldLevelDat));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void deleteSave(String worldDirName) {
        File[] worldDirFiles;
        File worldDir = new File(this.savesDir, worldDirName);
        if (worldDir.exists() && (worldDirFiles = worldDir.listFiles()) != null) {
            SaveFormatBase.deleteFilesRecursively(worldDirFiles);
            worldDir.delete();
        }
    }

    @Override
    public LevelStorage getSaveHandler(String worldDirName, boolean isMultiplayer) {
        return new SaveHandlerClientSP(this, this.savesDir, worldDirName, isMultiplayer);
    }

    protected static void deleteFilesRecursively(File[] dirFiles) {
        for (File file : dirFiles) {
            File[] subDirFiles;
            if (file.isDirectory() && (subDirFiles = file.listFiles()) != null) {
                SaveFormatBase.deleteFilesRecursively(subDirFiles);
            }
            file.delete();
        }
    }
}

