/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.save;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.NbtIo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.chunk.ChunkLoaderRegion;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.save.IPlayerFileData;
import net.minecraft.core.world.save.ISaveFormat;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.save.SaveHandlerBase;
import org.apache.log4j.Logger;

public class SaveHandlerServer
extends SaveHandlerBase
implements IPlayerFileData {
    private static final Logger logger = Logger.getLogger("Minecraft");

    public SaveHandlerServer(ISaveFormat saveFormat, File savesDir, String worldDirName, boolean isMultiplayer) {
        super(saveFormat, savesDir, worldDirName, isMultiplayer);
    }

    @Override
    public IChunkLoader getChunkLoader(Dimension dimension) {
        File dimDir = this.saveFormat.getDimensionRootDir(this.worldDirName, dimension);
        dimDir.mkdirs();
        return new ChunkLoaderRegion(dimDir);
    }

    @Override
    public void saveLevelDataAndPlayerData(LevelData levelData, List<EntityPlayer> playerList) {
        levelData.setSaveVersion(this.saveFormat.getSaveVersion());
        super.saveLevelDataAndPlayerData(levelData, playerList);
    }

    @Override
    public void writePlayerData(EntityPlayer entityplayer) {
        try {
            CompoundTag nbttagcompound = new CompoundTag();
            entityplayer.saveWithoutId(nbttagcompound);
            File file = new File(this.playersDirectory, "_tmp_.dat");
            File file1 = new File(this.playersDirectory, entityplayer.username + ".dat");
            NbtIo.writeCompressed(nbttagcompound, new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file.renameTo(file1);
        }
        catch (Exception exception) {
            logger.warn("Failed to save player data for " + entityplayer.username);
        }
    }

    @Override
    public void readPlayerData(EntityPlayer entityplayer) {
        CompoundTag nbttagcompound = this.getPlayerData(entityplayer.username);
        if (nbttagcompound != null) {
            entityplayer.load(nbttagcompound);
        }
    }

    @Override
    public IPlayerFileData getPlayerFileData() {
        return this;
    }

    private CompoundTag getPlayerData(String s) {
        try {
            File file = new File(this.playersDirectory, s + ".dat");
            if (file.exists()) {
                return NbtIo.readCompressed(new FileInputStream(file));
            }
        }
        catch (Exception exception) {
            logger.warn("Failed to load player data for " + s);
        }
        return null;
    }
}

