/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.save.conversion;

import com.mojang.nbt.CompoundTag;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.core.data.legacy.LegacyWorldTypes;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.IProgressUpdate;
import net.minecraft.core.world.save.DimensionData;
import net.minecraft.core.world.save.ISaveFormat;
import net.minecraft.core.world.save.SaveFormats;
import net.minecraft.core.world.save.conversion.SaveConverterMCRegionBase;

public class SaveConverter19133To19134
extends SaveConverterMCRegionBase {
    @Override
    public int fromVersion() {
        return 19133;
    }

    @Override
    public int toVersion() {
        return 19134;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void convertSave(CompoundTag levelData, File savesDir, String worldDirName, IProgressUpdate progress) {
        this.savesDir = savesDir;
        this.worldDirName = worldDirName;
        ISaveFormat fromFormat = SaveFormats.createSaveFormat(this.fromVersion(), savesDir);
        ISaveFormat toFormat = SaveFormats.createSaveFormat(this.toVersion(), savesDir);
        if (fromFormat != null && toFormat != null) {
            for (Dimension dim : Dimension.getDimensionList().values()) {
                DimensionData dimensionData;
                byte[] worldTypes;
                Iterator fromDimDir = fromFormat.getDimensionRootDir(worldDirName, dim);
                File file = toFormat.getDimensionRootDir(worldDirName, dim);
                if (((File)((Object)fromDimDir)).exists()) {
                    this.copyDirectoryRecursively(new File((File)((Object)fromDimDir), "region"), new File(file, "region"));
                    if (((File)((Object)fromDimDir)).getName().startsWith("DIM-")) {
                        this.deleteDirectoryRecursively((File)((Object)fromDimDir));
                        ((File)((Object)fromDimDir)).delete();
                    } else {
                        this.deleteDirectoryRecursively(new File((File)((Object)fromDimDir), "region"));
                        new File((File)((Object)fromDimDir), "region").delete();
                    }
                }
                if ((worldTypes = levelData.getByteArrayOrDefault("WorldTypes", null)) != null) {
                    byte worldType = worldTypes[dim.id];
                    dimensionData = new DimensionData(LegacyWorldTypes.getWorldTypeById(worldType));
                } else {
                    dimensionData = new DimensionData(dim.defaultWorldType);
                }
                toFormat.getSaveHandler(worldDirName, false).saveDimensionData(dim.id, dimensionData);
            }
        } else {
            return;
        }
        ArrayList<File> dimensionDirs = new ArrayList<File>();
        HashMap<File, ArrayList<File>> dimensionRegionFiles = new HashMap<File, ArrayList<File>>();
        System.out.println("Scanning folders...");
        for (Dimension dimension : Dimension.getDimensionList().values()) {
            dimensionDirs.add(toFormat.getDimensionRootDir(worldDirName, dimension));
        }
        for (File file : dimensionDirs) {
            dimensionRegionFiles.put(file, this.getRegionFiles(file));
        }
        int totalConversions = 0;
        for (File dimensionDir : dimensionDirs) {
            totalConversions += ((ArrayList)dimensionRegionFiles.get(dimensionDir)).size();
        }
        System.out.println("Total conversion count is " + totalConversions);
        progress.setLoadingProgress(0);
        boolean bl = false;
        int dimId = 0;
        for (File dimensionDir : dimensionDirs) {
            void var10_18;
            var10_18 += this.convertDimensionRegions(Dimension.getDimensionList().get(dimId), (ArrayList)dimensionRegionFiles.get(dimensionDir), (int)var10_18, totalConversions, progress);
            ++dimId;
        }
    }

    @Override
    int convertDimensionRegions(Dimension dimension, ArrayList<File> regionFiles, int conversionsPerformed, int totalConversions, IProgressUpdate progress) {
        return 0;
    }

    void copyDirectoryRecursively(File sourceDir, File destDir) {
        destDir.mkdirs();
        File[] dirFiles = sourceDir.listFiles();
        if (dirFiles != null) {
            for (File file : dirFiles) {
                if (file.isDirectory()) {
                    this.copyDirectoryRecursively(file, new File(destDir, file.getName()));
                    continue;
                }
                try {
                    Files.copy(file.toPath(), new File(destDir, file.getName()).toPath(), new CopyOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    void deleteDirectoryRecursively(File sourceDir) {
        File[] dirFiles = sourceDir.listFiles();
        if (dirFiles != null) {
            for (File file : dirFiles) {
                if (file.isDirectory()) {
                    this.deleteDirectoryRecursively(file);
                }
                file.delete();
            }
        }
    }
}

