/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.save.conversion;

import com.mojang.nbt.CompoundTag;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.zip.GZIPInputStream;
import net.minecraft.core.data.legacy.LegacyWorldTypes;
import net.minecraft.core.world.IProgressUpdate;
import net.minecraft.core.world.save.ISaveConverter;
import net.minecraft.core.world.save.legacy.ChunkFile;
import net.minecraft.core.world.save.legacy.ChunkFilePattern;
import net.minecraft.core.world.save.legacy.ChunkFolderPattern;
import net.minecraft.core.world.save.mcregion.RegionFile;
import net.minecraft.core.world.save.mcregion.RegionFileCache;
import net.minecraft.core.world.type.WorldTypes;

public class SaveConverterLegacyTo19132
implements ISaveConverter {
    @Override
    public int fromVersion() {
        return 0;
    }

    @Override
    public int toVersion() {
        return 19132;
    }

    @Override
    public void convertSave(CompoundTag tag, File savesDir, String saveDirName, IProgressUpdate progress) {
        File dim0dir = new File(savesDir, saveDirName);
        File dim1dir = new File(dim0dir, "DIM-1");
        progress.setLoadingProgress(0);
        System.out.println("Scanning folders...");
        ArrayList<ChunkFile> dim0ChunkFiles = new ArrayList<ChunkFile>();
        ArrayList<File> dim0ChunkDirs = new ArrayList<File>();
        ArrayList<ChunkFile> dim1ChunkFiles = new ArrayList<ChunkFile>();
        ArrayList<File> dim1ChunkDirs = new ArrayList<File>();
        this.getOldFormatFolders(dim0dir, dim0ChunkFiles, dim0ChunkDirs);
        if (dim1dir.exists()) {
            this.getOldFormatFolders(dim1dir, dim1ChunkFiles, dim1ChunkDirs);
        }
        int totalConversions = dim0ChunkFiles.size() + dim1ChunkFiles.size() + dim0ChunkDirs.size() + dim1ChunkDirs.size();
        System.out.println("Total conversion count is " + totalConversions);
        this.convertDimensionChunks(dim0dir, dim0ChunkFiles, 0, totalConversions, progress);
        this.convertDimensionChunks(dim1dir, dim1ChunkFiles, dim0ChunkFiles.size(), totalConversions, progress);
        this.deleteOldWorldData(dim0ChunkDirs, dim0ChunkFiles.size() + dim1ChunkFiles.size(), totalConversions, progress);
        if (dim1dir.exists()) {
            this.deleteOldWorldData(dim1ChunkDirs, dim0ChunkFiles.size() + dim1ChunkFiles.size() + dim0ChunkDirs.size(), totalConversions, progress);
        }
        tag.putByteArray("WorldTypes", new byte[]{(byte)LegacyWorldTypes.getWorldTypeId(WorldTypes.OVERWORLD_RETRO), (byte)LegacyWorldTypes.getWorldTypeId(WorldTypes.NETHER_DEFAULT), (byte)LegacyWorldTypes.getWorldTypeId(WorldTypes.PARADISE_DEFAULT)});
    }

    private void getOldFormatFolders(File file, ArrayList<ChunkFile> chunkFileList, ArrayList<File> chunkDirList) {
        ChunkFolderPattern chunkfolderpattern = new ChunkFolderPattern();
        ChunkFilePattern chunkfilepattern = new ChunkFilePattern();
        File[] chunkDir1Files = file.listFiles(chunkfolderpattern);
        if (chunkDir1Files != null) {
            for (File chunkDir1File : chunkDir1Files) {
                chunkDirList.add(chunkDir1File);
                File[] chunkDir2Files = chunkDir1File.listFiles(chunkfolderpattern);
                if (chunkDir2Files == null) continue;
                for (File chunkDir2File : chunkDir2Files) {
                    File[] chunkFiles = chunkDir2File.listFiles(chunkfilepattern);
                    if (chunkFiles == null) continue;
                    for (File chunkFile : chunkFiles) {
                        chunkFileList.add(new ChunkFile(chunkFile));
                    }
                }
            }
        }
    }

    private void convertDimensionChunks(File file, ArrayList<ChunkFile> chunkFileList, int conversionsPerformed, int totalConversions, IProgressUpdate progress) {
        Collections.sort(chunkFileList);
        byte[] fileBuffer = new byte[4096];
        for (ChunkFile chunkfile : chunkFileList) {
            int l;
            int k = chunkfile.getX();
            RegionFile regionfile = RegionFileCache.loadRegionFileFromCoords(file, k, l = chunkfile.getZ());
            if (!regionfile.chunkExists(k & 0x1F, l & 0x1F)) {
                try {
                    DataInputStream datainputstream = new DataInputStream(new GZIPInputStream(new FileInputStream(chunkfile.getChunkFile())));
                    DataOutputStream dataoutputstream = regionfile.getChunkDataOutputStream(k & 0x1F, l & 0x1F);
                    int j1 = 0;
                    while ((j1 = datainputstream.read(fileBuffer)) != -1) {
                        dataoutputstream.write(fileBuffer, 0, j1);
                    }
                    dataoutputstream.close();
                    datainputstream.close();
                }
                catch (IOException ioexception) {
                    ioexception.printStackTrace();
                }
            }
            int numConversions = (int)Math.round(100.0 * (double)(++conversionsPerformed) / (double)totalConversions);
            progress.setLoadingProgress(numConversions);
        }
        RegionFileCache.flushCache();
    }

    private void deleteOldWorldData(ArrayList arraylist, int i, int j, IProgressUpdate iprogressupdate) {
        for (File file : arraylist) {
            File[] afile = file.listFiles();
            SaveConverterLegacyTo19132.deleteFilesRecursively(afile);
            file.delete();
            int k = (int)Math.round(100.0 * (double)(++i) / (double)j);
            iprogressupdate.setLoadingProgress(k);
        }
    }

    protected static void deleteFilesRecursively(File[] dirFiles) {
        for (File file : dirFiles) {
            File[] subDirFiles;
            if (file.isDirectory() && (subDirFiles = file.listFiles()) != null) {
                SaveConverterLegacyTo19132.deleteFilesRecursively(subDirFiles);
            }
            file.delete();
        }
    }
}

