/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.type;

import net.minecraft.core.Global;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.config.season.SeasonConfig;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.wind.WindManager;

public abstract class WorldType {
    private final String languageKey;
    private final Weather defaultWeather;
    private final WindManager windManager;
    private final boolean hasCeiling;
    private final float[] brightnessRamp;
    private final SeasonConfig defaultSeasonConfig;

    public WorldType(String languageKey, Weather defaultWeather, WindManager windManager, boolean hasCeiling, float[] brightnessRamp, SeasonConfig defaultSeasonConfig) {
        this.languageKey = languageKey;
        this.defaultWeather = defaultWeather;
        this.windManager = windManager;
        this.hasCeiling = hasCeiling;
        this.brightnessRamp = brightnessRamp;
        this.defaultSeasonConfig = defaultSeasonConfig;
    }

    public void onWorldCreation(World world) {
    }

    public String getLanguageKey() {
        return this.languageKey;
    }

    public Weather getDefaultWeather() {
        return this.defaultWeather;
    }

    public WindManager getWindManager() {
        return this.windManager;
    }

    public boolean hasCeiling() {
        return this.hasCeiling;
    }

    public float[] getBrightnessRamp() {
        return this.brightnessRamp;
    }

    public SeasonConfig getDefaultSeasonConfig() {
        return this.defaultSeasonConfig;
    }

    public abstract int getMinY();

    public abstract int getMaxY();

    public final int getYRange() {
        return this.getMaxY() - this.getMinY();
    }

    public final double getYPercentage(int y) {
        int range = this.getYRange();
        return (double)(y -= this.getMinY()) / (double)range;
    }

    public abstract int getOceanY();

    public abstract int getOceanBlock();

    public abstract int getFillerBlock();

    public abstract BiomeProvider createBiomeProvider(World var1);

    public abstract ChunkGenerator createChunkGenerator(World var1);

    public abstract boolean isValidSpawn(World var1, int var2, int var3, int var4);

    public void getInitialSpawnLocation(World world) {
        int x = 0;
        int y = 0;
        int z = 0;
        block0: while (true) {
            x += world.rand.nextInt(64) - world.rand.nextInt(64);
            z += world.rand.nextInt(64) - world.rand.nextInt(64);
            y = this.getMaxY();
            while (true) {
                if (y < this.getMinY()) continue block0;
                if (world.getBlockId(x, y + 1, z) == 0 && this.isValidSpawn(world, x, y, z)) break block0;
                --y;
            }
            break;
        }
        world.getLevelData().setSpawn(x, y, z);
    }

    public void getRespawnLocation(World world) {
        LevelData levelData = world.getLevelData();
        if (levelData.getSpawnY() <= 0) {
            levelData.setSpawnY(this.getOceanY());
        }
        int x = levelData.getSpawnX();
        int z = levelData.getSpawnZ();
        while (world.getTopBlock(x, z) == 0) {
            x += world.rand.nextInt(8) - world.rand.nextInt(8);
            z += world.rand.nextInt(8) - world.rand.nextInt(8);
        }
        levelData.setSpawnX(x);
        levelData.setSpawnZ(z);
    }

    public abstract int getDayNightCycleLengthTicks();

    public float getTimeOfDay(World world, long tick, float partialTick) {
        Season otherSeason;
        float tickWithinCycle = (float)((int)(tick % (long)this.getDayNightCycleLengthTicks())) + partialTick;
        float currDayLength = 0.5f;
        float otherDayLength = 0.5f;
        Season currSeason = world.seasonManager.getCurrentSeason();
        Season season = otherSeason = world.seasonManager.getSeasonProgress() <= 0.5f ? world.seasonManager.getPreviousSeason() : world.seasonManager.getNextSeason();
        if (currSeason != null) {
            currDayLength = currSeason.dayLength;
            otherDayLength = otherSeason.dayLength;
        }
        float blendFactor = Math.abs(world.seasonManager.getSeasonProgress() - 0.5f);
        float dayLength = currDayLength + (otherDayLength - currDayLength) * blendFactor;
        float nightLength = 1.0f - dayLength;
        int dayLengthTicks = (int)((float)Global.DAY_LENGTH_TICKS * dayLength);
        int nightLengthTicks = (int)((float)Global.DAY_LENGTH_TICKS * nightLength);
        boolean isDay = tickWithinCycle < (float)dayLengthTicks;
        float partProgress = isDay ? tickWithinCycle / (float)dayLengthTicks : (tickWithinCycle - (float)dayLengthTicks) / (float)nightLengthTicks;
        float dayProgress = isDay ? partProgress / 2.0f : 0.5f + partProgress / 2.0f;
        if (dayProgress < 0.0f) {
            dayProgress += 1.0f;
        }
        if (dayProgress > 1.0f) {
            dayProgress -= 1.0f;
        }
        return dayProgress;
    }

    public abstract float getCelestialAngle(World var1, long var2, float var4);

    public abstract float[] getSunriseColor(float var1, float var2);

    public abstract int getSkyDarken(World var1, long var2, float var4);

    public abstract Vec3d getFogColor(float var1, float var2);

    public abstract boolean mayRespawn();

    public abstract float getCloudHeight();

    public abstract boolean hasGround();

    public boolean hasAurora() {
        return false;
    }
}

