/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiElement;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.core.util.helper.Listener;
import org.lwjgl.opengl.GL11;

public class GuiButton
extends Gui
implements GuiElement {
    public int width;
    public int height;
    public int xPosition;
    public int yPosition;
    public String displayString;
    public int id;
    public boolean enabled = true;
    public boolean visible = true;
    public Listener<GuiButton> listener;

    public GuiButton(int id, int xPosition, int yPosition, String text) {
        this(id, xPosition, yPosition, 200, 20, text);
    }

    public GuiButton(int id, int xPosition, int yPosition, int width, int height, String text) {
        this.id = id;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.displayString = text;
    }

    protected int getButtonState(boolean hovered) {
        int byte0 = 1;
        if (!this.enabled) {
            byte0 = 0;
        } else if (hovered) {
            byte0 = 2;
        }
        return byte0;
    }

    public void drawButton(Minecraft minecraft, int i, int j) {
        if (!this.visible) {
            return;
        }
        FontRenderer fontrenderer = minecraft.fontRenderer;
        GL11.glBindTexture((int)3553, (int)minecraft.renderEngine.getTexture("/gui/gui.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean flag = i >= this.xPosition && j >= this.yPosition && i < this.xPosition + this.width && j < this.yPosition + this.height;
        int k = this.getButtonState(flag);
        this.drawTexturedModalRect(this.xPosition, this.yPosition, 0, 46 + k * 20, this.width / 2, this.height);
        this.drawTexturedModalRect(this.xPosition + this.width / 2, this.yPosition, 200 - this.width / 2, 46 + k * 20, this.width / 2, this.height);
        this.mouseDragged(minecraft, i, j);
        if (!this.enabled) {
            this.drawStringCentered(fontrenderer, this.displayString, this.xPosition + this.width / 2, this.yPosition + (this.height - 8) / 2, -6250336);
        } else if (flag) {
            this.drawStringCentered(fontrenderer, this.displayString, this.xPosition + this.width / 2, this.yPosition + (this.height - 8) / 2, 0xFFFFA0);
        } else {
            this.drawStringCentered(fontrenderer, this.displayString, this.xPosition + this.width / 2, this.yPosition + (this.height - 8) / 2, 0xE0E0E0);
        }
    }

    public boolean isHovered(int mouseX, int mouseY) {
        return mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
    }

    protected void mouseDragged(Minecraft minecraft, int i, int j) {
    }

    public void mouseReleased(int i, int j) {
    }

    public boolean mousePressed(Minecraft minecraft, int i, int j) {
        return this.enabled && i >= this.xPosition && j >= this.yPosition && i < this.xPosition + this.width && j < this.yPosition + this.height;
    }

    public GuiButton setListener(Listener<GuiButton> listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public void setX(int x) {
        this.xPosition = x;
    }

    @Override
    public void setY(int y) {
        this.yPosition = y;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getX() {
        return this.xPosition;
    }

    @Override
    public int getY() {
        return this.yPosition;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

