/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiContainer;
import net.minecraft.client.gui.GuiSurface;
import net.minecraft.client.gui.GuiTexturedButton;
import net.minecraft.client.gui.drawing.DrawableEditor;
import net.minecraft.client.gui.drawing.IDrawableSurface;
import net.minecraft.client.render.FlagRenderer;
import net.minecraft.client.render.RenderEngine;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.packet.Packet141UpdateFlag;
import net.minecraft.core.player.inventory.ContainerFlag;
import net.minecraft.core.util.helper.Colors;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class GuiEditFlag
extends GuiContainer
implements IDrawableSurface<Byte> {
    private final TileEntityFlag tileEntity;
    private final int CANVAS_SCALE = 4;
    private final int CANVAS_WIDTH = 24;
    private final int CANVAS_HEIGHT = 16;
    private final RenderEngine renderEngineInstance;
    private int xLast = 0;
    private int yLast = 0;
    private int mouseButton;
    private boolean isDrawing = false;
    private int canvasX = 0;
    private int canvasY = 0;
    private int selectedColor = 0;
    private FlagRenderer flagRenderer;
    private DrawableEditor<Byte> flagSurfaceEditor;
    private DrawableEditor<Byte> drawOverlaySurfaceEditor;
    private GuiTexturedButton[] toolBtns;
    private int activeTool = 0;
    GuiSurface flagSurface;
    GuiSurface drawOverlaySurface;

    public GuiEditFlag(EntityPlayer player, TileEntityFlag flagTileEntity, RenderEngine renderEngine) {
        super(new ContainerFlag(player.inventory, flagTileEntity));
        this.renderEngineInstance = renderEngine;
        this.tileEntity = flagTileEntity;
        this.xSize = 176;
        this.ySize = 182;
        flagTileEntity.owner = player.username;
        this.flagRenderer = new FlagRenderer(renderEngine);
        this.flagSurface = new GuiSurface(24, 16, 4, flagTileEntity.flagColors);
        this.flagSurfaceEditor = new DrawableEditor<Byte>(this.flagSurface);
        this.drawOverlaySurface = new GuiSurface(24, 16, 4);
        this.drawOverlaySurfaceEditor = new DrawableEditor<Byte>(this.drawOverlaySurface);
    }

    @Override
    public void initGui() {
        super.initGui();
        this.controlList.clear();
        this.canvasX = this.width / 2 - 80;
        this.canvasY = this.height / 2 - 83;
        this.toolBtns = new GuiTexturedButton[6];
        for (int i = 0; i < 6; ++i) {
            this.toolBtns[i] = new GuiTexturedButton(i, "/gui/flag_editor.png", this.canvasX - 2 + 22 * i, this.canvasY + 68, 20 * i, 182, 20, 20);
            if (i == this.activeTool) {
                this.toolBtns[i].enabled = false;
            }
            this.controlList.add(this.toolBtns[i]);
        }
    }

    private void renderCanvas() {
        this.canvasX = this.width / 2 - 80;
        this.canvasY = this.height / 2 - 83;
        int[] colors = new int[5];
        for (int i = 1; i < 4; ++i) {
            ItemStack stack = this.tileEntity.getStackInSlot(35 + i);
            if (stack == null || stack.getItem() != Item.dye) continue;
            colors[i] = Colors.allFlagColors[TextFormatting.get((int)(15 - stack.getMetadata())).id].getARGB();
        }
        colors[4] = -1;
        this.flagSurface.colors = colors;
        this.drawOverlaySurface.colors = colors;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)769, (int)768);
        this.flagSurface.render(this.canvasX, this.canvasY);
        GL11.glDisable((int)3042);
        this.drawOverlaySurface.render(this.canvasX, this.canvasY);
    }

    @Override
    public void mouseClicked(int x, int y, int mouseButton) {
        super.mouseClicked(x, y, mouseButton);
        if (this.tileEntity.getStackInSlot(36 + this.selectedColor) == null) {
            return;
        }
        if (this.activeTool >= 0 && this.activeTool < 3) {
            if (!this.isDrawing) {
                int xInCanvas = (x - this.canvasX) / 4;
                int yInCanvas = (y - this.canvasY) / 4;
                if (xInCanvas >= 0 && xInCanvas < 24 && yInCanvas >= 0 && yInCanvas < 16) {
                    this.isDrawing = true;
                    this.xLast = xInCanvas;
                    this.yLast = yInCanvas;
                    this.mouseButton = mouseButton;
                    byte color = 0;
                    if (this.mouseButton == 0) {
                        color = (byte)(this.selectedColor + 1);
                    }
                    this.flagSurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, this.activeTool + 1);
                }
            }
        } else if (this.activeTool == 3) {
            if (!this.isDrawing) {
                int xInCanvas = (x - this.canvasX) / 4;
                int yInCanvas = (y - this.canvasY) / 4;
                if (xInCanvas >= 0 && xInCanvas < 24 && yInCanvas >= 0 && yInCanvas < 16) {
                    this.isDrawing = true;
                    this.mouseButton = mouseButton;
                    byte color = 0;
                    if (this.mouseButton == 0) {
                        color = (byte)(this.selectedColor + 1);
                    }
                    this.flagSurfaceEditor.floodFill(xInCanvas, yInCanvas, color);
                }
            }
        } else if (!(this.activeTool != 4 && this.activeTool != 5 || this.isDrawing)) {
            int xInCanvas = (x - this.canvasX) / 4;
            int yInCanvas = (y - this.canvasY) / 4;
            if (xInCanvas >= 0 && xInCanvas < 24 && yInCanvas >= 0 && yInCanvas < 16) {
                this.isDrawing = true;
                this.mouseButton = mouseButton;
                this.xLast = xInCanvas;
                this.yLast = yInCanvas;
            }
        }
    }

    @Override
    protected void buttonPressed(GuiButton guibutton) {
        super.buttonPressed(guibutton);
        if (guibutton.id >= 0 && guibutton.id < 6) {
            this.toolBtns[this.activeTool].enabled = true;
            this.activeTool = guibutton.id;
            guibutton.enabled = false;
        }
    }

    @Override
    public void mouseMovedOrUp(int x, int y, int mouseButton) {
        super.mouseMovedOrUp(x, y, mouseButton);
        if (this.activeTool >= 0 && this.activeTool < 3) {
            if (this.isDrawing && mouseButton != -1) {
                this.isDrawing = false;
                this.mouseButton = -1;
            } else if (this.isDrawing) {
                int xInCanvas = (x - this.canvasX) / 4;
                int yInCanvas = (y - this.canvasY) / 4;
                byte color = 0;
                if (this.mouseButton == 0) {
                    color = (byte)(this.selectedColor + 1);
                }
                if (MathHelper.abs(this.xLast - xInCanvas) <= 1.0f && MathHelper.abs(this.yLast - yInCanvas) <= 1.0f) {
                    this.flagSurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, this.activeTool + 1);
                } else {
                    this.flagSurfaceEditor.drawLine(this.xLast, this.yLast, xInCanvas, yInCanvas, color, this.activeTool + 1);
                }
                this.xLast = xInCanvas;
                this.yLast = yInCanvas;
            }
        } else if (this.activeTool == 3) {
            if (this.isDrawing && mouseButton != -1) {
                this.isDrawing = false;
                this.mouseButton = -1;
            }
        } else if (this.activeTool == 4) {
            if (this.isDrawing && mouseButton != -1) {
                this.isDrawing = false;
                int xInCanvas = (x - this.canvasX) / 4;
                int yInCanvas = (y - this.canvasY) / 4;
                byte color = 0;
                if (this.mouseButton == 0) {
                    color = (byte)(this.selectedColor + 1);
                }
                this.flagSurfaceEditor.drawRectangle(this.xLast, this.yLast, xInCanvas, yInCanvas, color);
                this.mouseButton = -1;
            }
        } else if (this.activeTool == 5 && this.isDrawing && mouseButton != -1) {
            this.isDrawing = false;
            int xInCanvas = (x - this.canvasX) / 4;
            int yInCanvas = (y - this.canvasY) / 4;
            byte color = 0;
            if (this.mouseButton == 0) {
                color = (byte)(this.selectedColor + 1);
            }
            this.flagSurfaceEditor.drawEllipse(this.xLast, this.yLast, xInCanvas, yInCanvas, color);
            this.mouseButton = -1;
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f) {
        int i = this.mc.renderEngine.getTexture("/gui/flag_editor.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(i);
        int j = (this.width - this.xSize) / 2;
        int k = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(j, k, 0, 0, this.xSize, this.ySize);
    }

    @Override
    public void drawScreen(int x, int y, float renderPartialTicks) {
        super.drawScreen(x, y, renderPartialTicks);
        this.drawOverlaySurface.clear();
        int xInCanvas = (x - this.canvasX) / 4;
        int yInCanvas = (y - this.canvasY) / 4;
        byte color = (byte)(this.selectedColor + 1);
        if (this.mouseButton == 1) {
            color = 4;
        }
        if (this.activeTool >= 0 && this.activeTool < 3) {
            this.drawOverlaySurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, this.activeTool + 1);
        } else if (this.activeTool == 3) {
            this.drawOverlaySurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, 1);
        } else if (this.activeTool == 4) {
            if (this.isDrawing) {
                this.drawOverlaySurfaceEditor.drawRectangle(this.xLast, this.yLast, xInCanvas, yInCanvas, color);
            } else {
                this.drawOverlaySurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, 1);
            }
        } else if (this.activeTool == 5) {
            if (this.isDrawing) {
                this.drawOverlaySurfaceEditor.drawEllipse(this.xLast, this.yLast, xInCanvas, yInCanvas, color);
            } else {
                this.drawOverlaySurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, 1);
            }
        }
        this.renderCanvas();
        if (this.selectedColor == 0) {
            this.drawString(this.fontRenderer, "1", (this.width - this.xSize) / 2 + 130, (this.height - this.ySize) / 2 + 14, -1);
        } else {
            this.drawStringNoShadow(this.fontRenderer, "1", (this.width - this.xSize) / 2 + 130, (this.height - this.ySize) / 2 + 14, -8421505);
        }
        if (this.selectedColor == 1) {
            this.drawString(this.fontRenderer, "2", (this.width - this.xSize) / 2 + 130, (this.height - this.ySize) / 2 + 36, -1);
        } else {
            this.drawStringNoShadow(this.fontRenderer, "2", (this.width - this.xSize) / 2 + 130, (this.height - this.ySize) / 2 + 36, -8421505);
        }
        if (this.selectedColor == 2) {
            this.drawString(this.fontRenderer, "3", (this.width - this.xSize) / 2 + 130, (this.height - this.ySize) / 2 + 58, -1);
        } else {
            this.drawStringNoShadow(this.fontRenderer, "3", (this.width - this.xSize) / 2 + 130, (this.height - this.ySize) / 2 + 58, -8421505);
        }
    }

    @Override
    public void keyTyped(char c, int i, int mouseX, int mouseY) {
        super.keyTyped(c, i, mouseX, mouseY);
        if (i == 1 || this.mc.gameSettings.keyInventory.isKey(i) || i == 14) {
            this.mc.thePlayer.closeScreen();
        }
        switch (c) {
            case '1': {
                this.selectedColor = 0;
                break;
            }
            case '2': {
                this.selectedColor = 1;
                break;
            }
            case '3': {
                this.selectedColor = 2;
            }
        }
    }

    @Override
    public int getWidth() {
        return 24;
    }

    @Override
    public int getHeight() {
        return 16;
    }

    @Override
    public Byte getPixelValue(int x, int y) {
        if (x < 0 || x >= 24) {
            return (byte)0;
        }
        if (y < 0 || y >= 16) {
            return (byte)0;
        }
        return this.tileEntity.flagColors[x + 24 * y];
    }

    @Override
    public boolean setPixelValue(int x, int y, Byte value) {
        if (x < 0 || x >= 24) {
            return false;
        }
        if (y < 0 || y >= 16) {
            return false;
        }
        this.tileEntity.flagColors[x + 24 * y] = value;
        return true;
    }

    @Override
    public void onGuiClosed() {
        if (this.mc.theWorld.isClientSide) {
            this.mc.getSendQueue().addToSendQueue(new Packet141UpdateFlag(this.tileEntity.xCoord, this.tileEntity.yCoord, this.tileEntity.zCoord, this.tileEntity.flagColors, this.tileEntity.items, this.tileEntity.owner));
        }
    }
}

