/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.Arrays;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiInventory;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.options.GuiOptionsButton;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.Lighting;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.player.inventory.ContainerPlayerCreative;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiInventoryCreative
extends GuiInventory
implements GuiTextField.ITextChangeListener {
    protected GuiButton lastPageButton;
    protected GuiButton nextPageButton;
    protected GuiOptionsButton clearSearchButton;
    protected GuiTextField searchField;
    protected ContainerPlayerCreative container;
    protected String pageString = "1/1";

    public GuiInventoryCreative(EntityPlayer entityplayer) {
        super(entityplayer);
        this.xSize = 288;
        this.container = (ContainerPlayerCreative)entityplayer.inventorySlots;
        this.armourValuesFloat = 186;
        this.armourButtonFloatX = 76;
        this.overlayButtonsLayout.setOffset(-(this.xSize / 2), -(this.ySize / 2) - 10);
    }

    @Override
    public void initGui() {
        super.initGui();
        this.lastPageButton = new GuiButton(500, 172, 140, 20, 20, "<");
        this.controlList.add(this.lastPageButton);
        this.nextPageButton = new GuiButton(501, 262, 140, 20, 20, ">");
        this.controlList.add(this.nextPageButton);
        this.clearSearchButton = new GuiOptionsButton(502, 266, 10, 12, 20, "X");
        this.controlList.add(this.clearSearchButton);
        this.searchField = new GuiTextField(this, this.fontRenderer, 173, 7, 96, 18, this.container.searchText, "Search...");
        this.searchField.drawBackground = false;
        this.searchField.setMaxStringLength(14);
        this.searchField.setTextChangeListener(this);
        this.updatePageSwitcher();
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void scroll(int direction) {
        if (direction == 0) {
            return;
        }
        int count = 1;
        if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) {
            count = 10;
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                count = 100;
            }
        }
        while (this.lastPageButton.enabled && direction > 0 && count > 0) {
            this.container.lastPage();
            this.updatePageSwitcher();
            --count;
        }
        while (this.nextPageButton.enabled && direction < 0 && count > 0) {
            this.container.nextPage();
            this.updatePageSwitcher();
            --count;
        }
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        this.searchField.updateCursorCounter();
    }

    @Override
    public void onGuiClosed() {
        super.onGuiClosed();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void updatePageSwitcher() {
        this.lastPageButton.enabled = this.container.page != 0;
        this.nextPageButton.enabled = this.container.page != this.container.maxPage;
        this.pageString = this.container.page + 1 + "/" + (this.container.maxPage + 1);
    }

    @Override
    protected void buttonPressed(GuiButton guibutton) {
        super.buttonPressed(guibutton);
        if (!guibutton.enabled) {
            return;
        }
        if (guibutton == this.lastPageButton) {
            this.scroll(1);
        } else if (guibutton == this.nextPageButton) {
            this.scroll(-1);
        } else if (guibutton == this.clearSearchButton) {
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                for (int i = 0; i < this.container.playerInv.getSizeInventory(); ++i) {
                    this.container.playerInv.setInventorySlotContents(i, null);
                }
                Arrays.fill(this.container.playerInv.armorInventory, null);
            } else {
                this.searchField.setText("");
                this.container.searchPage("");
                this.updatePageSwitcher();
            }
        }
        this.updatePageSwitcher();
    }

    @Override
    public void mouseClicked(int x, int y, int mouseButton) {
        super.mouseClicked(x, y, mouseButton);
        this.searchField.mouseClicked(x, y, mouseButton);
    }

    @Override
    public void keyTyped(char c, int i, int mouseX, int mouseY) {
        if (this.searchField.isFocused && c != '\u001b') {
            this.searchField.textboxKeyTyped(c, i);
            this.container.searchPage(this.searchField.getText());
            this.updatePageSwitcher();
        } else if (!this.searchField.isFocused && c == 't') {
            this.searchField.setFocused(true);
        } else {
            super.keyTyped(c, i, mouseX, mouseY);
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        this.drawStringCenteredNoShadow(this.fontRenderer, this.pageString, 228, 146, 0x404040);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f) {
        this.scroll(Mouse.getDWheel());
        int i = this.mc.renderEngine.getTexture("/gui/creative.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(i);
        int j = (this.width - this.xSize) / 2;
        int k = (this.height - this.ySize) / 2;
        this.lastPageButton.xPosition = j + 172;
        this.lastPageButton.yPosition = k + 140;
        this.nextPageButton.xPosition = j + 262;
        this.nextPageButton.yPosition = k + 140;
        this.clearSearchButton.xPosition = j + 270;
        this.clearSearchButton.yPosition = k + 6;
        this.searchField.xPosition = j + 173;
        this.searchField.yPosition = k + 7;
        this.drawTexturedModalRect(j, k, 0, 0, 169, this.ySize);
        this.drawTexturedModalRect(j + 169, k, 0, 166, 119, 90);
        this.drawTexturedModalRect(j + 169, k + 90, 119, 166, 119, 76);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(j + 51), (float)(k + 75), (float)50.0f);
        float f1 = 30.0f;
        GL11.glScalef((float)(-f1), (float)f1, (float)f1);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f2 = this.mc.thePlayer.renderYawOffset;
        float f3 = this.mc.thePlayer.yRot;
        float f4 = this.mc.thePlayer.xRot;
        float f5 = (float)(j + 51) - this.xSize_lo;
        float f6 = (float)(k + 75 - 50) - this.ySize_lo;
        GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        Lighting.turnOff();
        GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-((float)Math.atan(f6 / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        this.mc.thePlayer.renderYawOffset = (float)Math.atan(f5 / 40.0f) * 20.0f;
        this.mc.thePlayer.yRot = (float)Math.atan(f5 / 40.0f) * 40.0f;
        this.mc.thePlayer.xRot = -((float)Math.atan(f6 / 40.0f)) * 20.0f;
        this.mc.thePlayer.entityBrightness = 1.0f;
        GL11.glTranslatef((float)0.0f, (float)this.mc.thePlayer.heightOffset, (float)0.0f);
        EntityRenderDispatcher.instance.viewLerpYaw = 180.0f;
        EntityRenderDispatcher.instance.renderEntityWithPosYaw(this.mc.thePlayer, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        this.mc.thePlayer.entityBrightness = 0.0f;
        this.mc.thePlayer.renderYawOffset = f2;
        this.mc.thePlayer.yRot = f3;
        this.mc.thePlayer.xRot = f4;
        GL11.glPopMatrix();
        Lighting.turnOn();
        GL11.glDisable((int)32826);
        this.searchField.drawTextBox();
    }

    @Override
    public void textChanged(GuiTextField textField) {
        this.container.searchPage(textField.getText());
        this.updatePageSwitcher();
    }
}

