/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.Random;

public class GuiParticle {
    private static final Random rand = new Random();
    public double posX;
    public double posY;
    public double prevPosX;
    public double prevPosY;
    public double motionX;
    public double motionY;
    public double speed;
    public boolean isDead;
    public int age;
    public int maxAge;
    public double colorR;
    public double colorG;
    public double colorB;
    public double colorA;
    public double prevColorR;
    public double prevColorG;
    public double prevColorB;
    public double prevColorA;

    public GuiParticle(int x, int y) {
        this.prevPosX = this.posX = (double)x;
        this.prevPosY = this.posY = (double)y;
        this.colorA = 1.0;
        this.colorB = 1.0;
        this.colorG = 1.0;
        this.colorR = 1.0;
        this.prevColorA = 1.0;
        this.prevColorB = 1.0;
        this.prevColorG = 1.0;
        this.prevColorR = 1.0;
        this.speed = 0.9;
        this.maxAge = 10;
        this.motionX = 1.0 - rand.nextDouble() * 2.0;
        this.motionY = 1.0 - rand.nextDouble() * 2.0;
    }

    public void tick() {
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.motionX *= this.speed;
        this.motionY *= this.speed;
        if (++this.age > this.maxAge) {
            this.setIsDead();
        }
        this.colorA = 1.0 - (double)this.age / (double)this.maxAge;
        if (this.colorA > 1.0) {
            this.colorA = 1.0;
        }
        this.colorA *= this.colorA;
        this.colorA *= 0.5;
    }

    public void updateValues() {
        this.prevColorR = this.colorR;
        this.prevColorG = this.colorG;
        this.prevColorB = this.colorB;
        this.prevColorA = this.colorA;
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
    }

    public void setIsDead() {
        this.isDead = true;
    }
}

