/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiParticle;
import org.lwjgl.opengl.GL11;

public class GuiParticleManager
extends Gui {
    private final List<GuiParticle> particles = new ArrayList<GuiParticle>();
    private final Minecraft mc;

    public GuiParticleManager(Minecraft mc) {
        this.mc = mc;
    }

    public void addParticle(GuiParticle particle) {
        this.particles.add(particle);
    }

    public void tickParticles() {
        for (int i = 0; i < this.particles.size(); ++i) {
            GuiParticle particle = this.particles.get(i);
            particle.updateValues();
            particle.tick();
            if (!particle.isDead) continue;
            this.particles.remove(i--);
        }
    }

    public void render(float renderPartialTicks) {
        this.mc.renderEngine.bindTexture(this.mc.renderEngine.getTexture("/gui/particles.png"));
        for (GuiParticle particle : this.particles) {
            int x = (int)(particle.prevPosX + (particle.posX - particle.prevPosX) * (double)renderPartialTicks - 4.0);
            int y = (int)(particle.prevPosY + (particle.posY - particle.prevPosY) * (double)renderPartialTicks - 4.0);
            float a = (float)(particle.prevColorA + (particle.colorA - particle.prevColorA) * (double)renderPartialTicks);
            float r = (float)(particle.prevColorR + (particle.colorR - particle.prevColorR) * (double)renderPartialTicks);
            float g = (float)(particle.prevColorG + (particle.colorG - particle.prevColorG) * (double)renderPartialTicks);
            float b = (float)(particle.prevColorB + (particle.colorB - particle.prevColorB) * (double)renderPartialTicks);
            GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
            GL11.glEnable((int)3042);
            this.drawTexturedModalRect(x, y, 40, 0, 8, 8);
            GL11.glDisable((int)3042);
        }
    }
}

