/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.option.FloatOption;
import org.lwjgl.opengl.GL11;

public class GuiSlider
extends GuiButton {
    public float sliderValue;
    public boolean dragging = false;
    private FloatOption option;

    public GuiSlider(int id, int xPosition, int yPosition, FloatOption floatOption) {
        this(id, xPosition, yPosition, 150, 20, floatOption);
    }

    public GuiSlider(int id, int xPosition, int yPosition, int width, int height, FloatOption floatOption) {
        super(id, xPosition, yPosition, width, height, floatOption.getDisplayStringValue());
        this.option = floatOption;
        this.sliderValue = ((Float)floatOption.value).floatValue();
    }

    public GuiSlider(int id, int xPosition, int yPosition, int width, int height, String text, float defaultValue) {
        super(id, xPosition, yPosition, width, height, text);
        this.option = null;
        this.sliderValue = defaultValue;
    }

    @Override
    protected int getButtonState(boolean hovered) {
        return 0;
    }

    @Override
    protected void mouseDragged(Minecraft minecraft, int i, int j) {
        if (!this.visible) {
            return;
        }
        if (this.dragging) {
            this.sliderValue = (float)(i - (this.xPosition + 4)) / (float)(this.width - 8);
            if (this.sliderValue < 0.0f) {
                this.sliderValue = 0.0f;
            }
            if (this.sliderValue > 1.0f) {
                this.sliderValue = 1.0f;
            }
            if (this.option != null) {
                this.option.set(Float.valueOf(this.sliderValue));
                this.displayString = this.option.getDisplayString();
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(this.xPosition + (int)(this.sliderValue * (float)(this.width - 8)), this.yPosition, 0, 66, 4, 20);
        this.drawTexturedModalRect(this.xPosition + (int)(this.sliderValue * (float)(this.width - 8)) + 4, this.yPosition, 196, 66, 4, 20);
    }

    @Override
    public boolean mousePressed(Minecraft minecraft, int i, int j) {
        if (super.mousePressed(minecraft, i, j)) {
            this.sliderValue = (float)(i - (this.xPosition + 4)) / (float)(this.width - 8);
            if (this.sliderValue < 0.0f) {
                this.sliderValue = 0.0f;
            }
            if (this.sliderValue > 1.0f) {
                this.sliderValue = 1.0f;
            }
            if (this.option != null) {
                this.option.set(Float.valueOf(this.sliderValue));
                this.displayString = this.option.getDisplayString();
            }
            this.dragging = true;
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased(int i, int j) {
        this.dragging = false;
    }
}

