/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.option.ToggleableOption;
import org.lwjgl.opengl.GL11;

public class GuiSliderInteger
extends GuiButton {
    public int sliderValue;
    public boolean dragging = false;
    private ToggleableOption<?> option;

    public GuiSliderInteger(int id, int xPosition, int yPosition, ToggleableOption<?> option) {
        this(id, xPosition, yPosition, 150, 20, option);
    }

    public GuiSliderInteger(int id, int xPosition, int yPosition, int width, int height, ToggleableOption<?> option) {
        super(id, xPosition, yPosition, width, height, option.getDisplayStringValue());
        this.option = option;
        this.sliderValue = option.getValueIndex();
        this.displayString = option.getDisplayStringValue();
    }

    @Override
    protected int getButtonState(boolean hovered) {
        return 0;
    }

    @Override
    protected void mouseDragged(Minecraft minecraft, int i, int j) {
        if (!this.visible) {
            return;
        }
        int maxValue = this.option.size() - 1;
        if (this.dragging) {
            int segments = maxValue;
            float percentage = (float)(i - (this.xPosition + 4) - this.width / (2 * segments)) / (float)(this.width - 8);
            if (percentage > 1.0f) {
                percentage = 1.0f;
            }
            if (percentage < 0.0f) {
                percentage = 0.0f;
            }
            this.sliderValue = (int)Math.ceil((float)segments * percentage);
            this.option.setValueWithIndex(this.sliderValue);
            this.displayString = this.option.getDisplayStringValue();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(this.xPosition + (int)((float)this.sliderValue / (float)maxValue * (float)(this.width - 8)), this.yPosition, 0, 66, 4, 20);
        this.drawTexturedModalRect(this.xPosition + (int)((float)this.sliderValue / (float)maxValue * (float)(this.width - 8)) + 4, this.yPosition, 196, 66, 4, 20);
    }

    @Override
    public boolean mousePressed(Minecraft minecraft, int i, int j) {
        if (super.mousePressed(minecraft, i, j)) {
            int segments = this.option.size() - 1;
            float percentage = (float)(i - (this.xPosition + 4) - this.width / (2 * segments)) / (float)(this.width - 8);
            if (percentage > 1.0f) {
                percentage = 1.0f;
            }
            if (percentage < 0.0f) {
                percentage = 0.0f;
            }
            this.sliderValue = (int)Math.ceil((float)segments * percentage);
            this.option.setValueWithIndex(this.sliderValue);
            this.displayString = this.option.getDisplayStringValue();
            this.dragging = true;
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased(int i, int j) {
        this.dragging = false;
        this.displayString = this.option.getDisplayString();
    }
}

