/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.option.enums.TooltipStyle;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.Tessellator;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.player.inventory.slot.SlotCrafting;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiTooltip
extends Gui {
    Minecraft mc;
    FontRenderer fr;

    public GuiTooltip(Minecraft mc) {
        this.mc = mc;
        this.fr = mc.fontRenderer;
    }

    public void render(String string, int x, int y, int offsetX, int offsetY) {
        String[] lines = string.split("\n");
        if (lines.length == 0) {
            return;
        }
        int lineSpacing = 3;
        int padding = 3;
        int width = 0;
        for (String line : lines) {
            width = Math.max(width, this.fr.getStringWidth(line));
        }
        int height = lines.length * 8 + (lines.length - 1) * lineSpacing;
        if (x + offsetX + width + padding * 2 > this.mc.resolution.scaledWidth) {
            offsetX = -offsetX - width;
        }
        offsetY -= Math.max(0, y + height + offsetY + padding * 2 - this.mc.resolution.scaledHeight);
        x += offsetX;
        y += offsetY;
        int paddingExtra = 0;
        if (this.mc.gameSettings.tooltipStyle.value != TooltipStyle.DEFAULT) {
            paddingExtra = 1;
        }
        this.drawBackground(x, y, x + width + padding * 2 + paddingExtra * 2, y + height + padding * 2 + paddingExtra * 2);
        for (int i = 0; i < lines.length; ++i) {
            this.fr.drawStringWithShadow(lines[i], x + padding + paddingExtra, y + padding + i * (8 + lineSpacing) + paddingExtra, 0xFFFFFF);
        }
    }

    private void drawBackground(int minX, int minY, int maxX, int maxY) {
        if (this.mc.gameSettings.tooltipStyle.value == TooltipStyle.MODERN) {
            this.drawBackgroundModern(minX, minY, maxX, maxY);
            return;
        }
        int topLeftCornerX = minX;
        int topLeftCornerY = minY;
        int bottomLeftCornerX = minX;
        int bottomLeftCornerY = maxY - 7;
        int topRightCornerX = maxX - 7;
        int topRightCornerY = minY;
        int bottomRightCornerX = maxX - 7;
        int bottomRightCornerY = maxY - 7;
        int horWidth = maxX - minX - 14;
        int vertHeight = maxY - minY - 14;
        int horWidth2 = maxX - minX - 6;
        int vertHeight2 = maxY - minY - 6;
        Tessellator tl = Tessellator.instance;
        this.mc.renderEngine.bindTexture(this.mc.renderEngine.getTexture(((TooltipStyle)((Object)this.mc.gameSettings.tooltipStyle.value)).getFilePath()));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        tl.startDrawingQuads();
        tl.drawRectangleWithUV(topLeftCornerX, topLeftCornerY, 7, 7, 0.0, 0.0, 0.21875, 0.21875);
        tl.drawRectangleWithUV(bottomLeftCornerX, bottomLeftCornerY, 7, 7, 0.0, 0.21875, 0.21875, 0.21875);
        tl.drawRectangleWithUV(topRightCornerX, topRightCornerY, 7, 7, 0.21875, 0.0, 0.21875, 0.21875);
        tl.drawRectangleWithUV(bottomRightCornerX, bottomRightCornerY, 7, 7, 0.21875, 0.21875, 0.21875, 0.21875);
        for (int x = minX + 7; x < minX + 7 + horWidth / 11 * 11; x += 11) {
            tl.drawRectangleWithUV(x, minY, 11, 3, 0.4375, 0.0, 0.34375, 0.09375);
        }
        int finalWidth = horWidth - horWidth / 11 * 11;
        tl.drawRectangleWithUV(topRightCornerX - finalWidth, minY, finalWidth, 3, 0.4375, 0.0, (float)finalWidth / 32.0f, 0.09375);
        for (int x = minX + 7; x < minX + 7 + horWidth / 11 * 11; x += 11) {
            tl.drawRectangleWithUV(x, maxY - 3, 11, 3, 0.4375, 0.34375, 0.34375, 0.09375);
        }
        tl.drawRectangleWithUV(bottomRightCornerX - finalWidth, maxY - 3, finalWidth, 3, 0.4375, 0.34375, (float)finalWidth / 32.0f, 0.09375);
        for (int y = minY + 7; y < minY + 7 + vertHeight / 11 * 11; y += 11) {
            tl.drawRectangleWithUV(minX, y, 3, 11, 0.0, 0.4375, 0.09375, 0.34375);
        }
        int finalHeight = vertHeight - vertHeight / 11 * 11;
        tl.drawRectangleWithUV(minX, bottomLeftCornerY - finalHeight, 3, finalHeight, 0.0, 0.4375, 0.09375, (float)finalHeight / 32.0f);
        for (int y = minY + 7; y < minY + 7 + vertHeight / 11 * 11; y += 11) {
            tl.drawRectangleWithUV(maxX - 3, y, 3, 11, 0.34375, 0.4375, 0.09375, 0.34375);
        }
        tl.drawRectangleWithUV(maxX - 3, bottomRightCornerY - finalHeight, 3, finalHeight, 0.34375, 0.4375, 0.09375, (float)finalHeight / 32.0f);
        for (int x = minX + 3; x < minX + 3 + horWidth2 / 8 * 8; x += 8) {
            for (int y = minY + 3; y < minY + 3 + vertHeight2 / 8 * 8; y += 8) {
                tl.drawRectangleWithUV(x, y, 8, 8, 0.4375, 0.4375, 0.25, 0.25);
            }
        }
        int finalHeight2 = vertHeight2 - vertHeight2 / 8 * 8;
        int finalWidth2 = horWidth2 - horWidth2 / 8 * 8;
        for (int x = minX + 3; x < minX + 3 + horWidth2 / 8 * 8; x += 8) {
            tl.drawRectangleWithUV(x, maxY - 3 - finalHeight2, 8, finalHeight2, 0.4375, 0.4375, 0.25, (float)finalHeight2 / 32.0f);
        }
        for (int y = minY + 3; y < minY + 3 + vertHeight2 / 8 * 8; y += 8) {
            tl.drawRectangleWithUV(maxX - 3 - finalWidth2, y, finalWidth2, 8, 0.4375, 0.4375, (float)finalWidth2 / 32.0f, 0.25);
        }
        tl.drawRectangleWithUV(maxX - 3 - finalWidth2, maxY - 3 - finalHeight2, finalWidth2, finalHeight2, 0.4375, 0.4375, (float)finalWidth / 32.0f, (float)finalWidth2 / 32.0f);
        tl.draw();
        GL11.glDisable((int)3042);
    }

    private void drawBackgroundModern(int minX, int minY, int maxX, int maxY) {
        int x = minX + 4;
        int y = minY + 4;
        int width = maxX - minX - 8;
        int height = maxY - minY - 8;
        int bgColor = -267386864;
        int lineColorTop = 0x505000FF;
        int lineColorBottom = (lineColorTop & 0xFEFEFE) >> 1 | lineColorTop & 0xFF000000;
        this.drawGradientRect(x - 3, y - 4, x + width + 3, y - 3, bgColor, bgColor);
        this.drawGradientRect(x - 3, y + height + 3, x + width + 3, y + height + 4, bgColor, bgColor);
        this.drawGradientRect(x - 3, y - 3, x + width + 3, y + height + 3, bgColor, bgColor);
        this.drawGradientRect(x - 4, y - 3, x - 3, y + height + 3, bgColor, bgColor);
        this.drawGradientRect(x + width + 3, y - 3, x + width + 4, y + height + 3, bgColor, bgColor);
        this.drawGradientRect(x - 3, y - 3 + 1, x - 3 + 1, y + height + 3 - 1, lineColorTop, lineColorBottom);
        this.drawGradientRect(x + width + 2, y - 3 + 1, x + width + 3, y + height + 3 - 1, lineColorTop, lineColorBottom);
        this.drawGradientRect(x - 3, y - 3, x + width + 3, y - 3 + 1, lineColorTop, lineColorTop);
        this.drawGradientRect(x - 3, y + height + 2, x + width + 3, y + height + 3, lineColorBottom, lineColorBottom);
    }

    public String getTooltipText(ItemStack itemStack, boolean showDescription, Slot slot) {
        I18n trans = I18n.getInstance();
        StringBuilder text = new StringBuilder();
        boolean discovered = true;
        boolean ctrlPressed = false;
        boolean shiftPressed = false;
        boolean debug = (Boolean)this.mc.gameSettings.showDebugScreen.value;
        if (slot != null) {
            discovered = slot.discovered;
            if (slot instanceof SlotCrafting) {
                ctrlPressed = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
                shiftPressed = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
                showDescription = false;
                if (((Boolean)this.mc.gameSettings.swapCraftingButtons.value).booleanValue()) {
                    boolean temp = shiftPressed;
                    shiftPressed = ctrlPressed;
                    ctrlPressed = temp;
                }
            }
        }
        if (discovered) {
            String itemName = trans.translateKey(itemStack.getItemName() + ".name");
            String itemNickname = itemStack.getItemNickname();
            if (itemNickname != null && !itemNickname.isEmpty() && itemStack.tag.getBoolean("overrideName")) {
                itemName = itemNickname;
            }
            if (itemStack.tag.getBoolean("overrideColor")) {
                text.append(TextFormatting.get(itemStack.getNameColor()));
            }
            text.append(itemName);
            if (debug) {
                text.append(" #").append(itemStack.itemID).append(":").append(itemStack.getMetadata());
                text.append('\n').append(TextFormatting.LIGHT_GRAY).append(itemStack.getItemName());
            }
            if (itemStack.isItemStackDamageable() && !showDescription && ((Boolean)this.mc.gameSettings.showItemDurability.value).booleanValue()) {
                int durability = itemStack.getMaxDamage();
                int remainingUses = durability - itemStack.getMetadata();
                text.append('\n').append(TextFormatting.LIGHT_GRAY).append(remainingUses).append(" / ").append(durability);
            }
            if (showDescription) {
                text.append('\n').append(GuiTooltip.formatDescription(trans.translateKey(itemStack.getItemName() + ".desc"), 16));
            }
            if (slot instanceof SlotCrafting) {
                if (shiftPressed && !ctrlPressed) {
                    text.append('\n').append(TextFormatting.LIGHT_GRAY).append("Craft Stack");
                }
                if (ctrlPressed && !shiftPressed) {
                    text.append('\n').append(TextFormatting.LIGHT_GRAY).append("Craft Once");
                }
                if (ctrlPressed && shiftPressed) {
                    text.append('\n').append(TextFormatting.LIGHT_GRAY).append("Craft All");
                }
            }
        } else {
            String translatedName = trans.translateKey(itemStack.getItemTranslateKey());
            for (char c : translatedName.toCharArray()) {
                if (Character.isLetterOrDigit(c)) {
                    text.append("?");
                    continue;
                }
                text.append(c);
            }
            if (showDescription) {
                text.append('\n').append(trans.translateKey("item.unknown.desc"));
            }
        }
        return text.toString();
    }

    public String getTooltipText(ItemStack itemStack, boolean showDescription) {
        return this.getTooltipText(itemStack, showDescription, null);
    }

    private static String formatDescription(String description, int preferredLineLength) {
        StringBuilder string = new StringBuilder();
        string.append(TextFormatting.LIGHT_GRAY);
        int lineLength = 0;
        for (int i = 0; i < description.length(); ++i) {
            char c = description.charAt(i);
            if (c == ' ') {
                if (lineLength > preferredLineLength) {
                    lineLength = 0;
                    string.append("\n").append(TextFormatting.LIGHT_GRAY);
                    continue;
                }
                string.append(c);
                continue;
            }
            ++lineLength;
            string.append(c);
        }
        return string.toString();
    }
}

