/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.options.GuiOptionsPageAudio;
import net.minecraft.client.gui.options.GuiOptionsPageControls;
import net.minecraft.client.gui.options.GuiOptionsPageGeneral;
import net.minecraft.client.gui.options.GuiOptionsPageLanguages;
import net.minecraft.client.gui.options.GuiOptionsPageTexturePacks;
import net.minecraft.client.gui.options.GuiOptionsPageVideo;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.Tessellator;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.sound.SoundType;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GuiOptionsPageBase
extends GuiScreen {
    static Class<? extends GuiOptionsPageBase>[] pages = new Class[]{GuiOptionsPageGeneral.class, GuiOptionsPageAudio.class, GuiOptionsPageVideo.class, GuiOptionsPageControls.class, GuiOptionsPageTexturePacks.class, GuiOptionsPageLanguages.class};
    static String[] pageLanguageKeys = new String[]{"options.tab.general", "options.tab.audio", "options.tab.video", "options.tab.controls", "options.tab.texturepacks", "options.tab.languages"};
    String titleLanguageKey = "options.title";
    float scrollAmount = 0.0f;
    int top;
    int bottom;
    int scrollRegionHeight;
    int frameWidth;
    GameSettings gameSettings;
    private Float oldScrollAmount;
    Integer clickX;
    Integer clickY;
    private int lastMouseY;

    public GuiOptionsPageBase(GuiScreen parent, GameSettings settings) {
        super(parent);
        this.gameSettings = settings;
    }

    @Override
    public void initGui() {
        GuiButton button;
        int i;
        super.initGui();
        I18n i18n = I18n.getInstance();
        int buttonWidth = 80;
        int buttonSpace = 4;
        int buttonsWidth = buttonWidth * 4 + buttonSpace * 3;
        for (i = 0; i < 4; ++i) {
            button = new GuiButton(100 + i, this.width / 2 - buttonsWidth / 2 + (buttonWidth + buttonSpace) * i, 20, buttonWidth, 20, i18n.translateKey(pageLanguageKeys[i]));
            if (pages[i].equals(this.getClass())) {
                button.enabled = false;
            }
            this.controlList.add(button);
        }
        buttonsWidth = buttonWidth * 2 + buttonSpace * 1;
        for (i = 4; i < pages.length; ++i) {
            button = new GuiButton(100 + i, this.width / 2 - buttonsWidth / 2 + (buttonWidth + buttonSpace) * (i - 4), 42, buttonWidth, 20, i18n.translateKey(pageLanguageKeys[i]));
            if (pages[i].equals(this.getClass())) {
                button.enabled = false;
            }
            this.controlList.add(button);
        }
        this.controlList.add(new GuiButton(0, this.width / 2 - 100, this.height - 35, i18n.translateKey("gui.done")));
        this.bottom = this.height - 40;
        this.top = 65;
        this.scrollRegionHeight = this.bottom - this.top;
        this.scrollAmount = 0.0f;
    }

    @Override
    protected void buttonPressed(GuiButton guibutton) {
        super.buttonPressed(guibutton);
        if (guibutton.id == 0) {
            this.mc.displayGuiScreen(this.getParentScreen());
        } else if (guibutton.id >= 100 && guibutton.id < 100 + pages.length) {
            try {
                this.mc.displayGuiScreen(pages[guibutton.id - 100].getConstructor(GuiScreen.class, GameSettings.class).newInstance(this.getParentScreen(), this.gameSettings));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onGuiClosed() {
        super.onGuiClosed();
        this.mc.gameSettings.saveOptions();
    }

    private void scroll(float amount) {
        if (amount == 0.0f) {
            return;
        }
        this.scrollAmount += amount;
        this.onScroll();
    }

    private void onScroll() {
        int totalPageHeight = this.getTotalPageHeight();
        if (this.scrollAmount < 0.0f || this.scrollRegionHeight > totalPageHeight) {
            this.scrollAmount = 0.0f;
        } else if (this.scrollAmount > (float)(totalPageHeight - this.scrollRegionHeight)) {
            this.scrollAmount = totalPageHeight - this.scrollRegionHeight;
        }
    }

    @Override
    public void drawScreen(int x, int y, float renderPartialTicks) {
        if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) {
            this.scroll((float)Mouse.getDWheel() * -1.0f);
        } else {
            this.scroll((float)Mouse.getDWheel() / -12.0f);
        }
        this.frameWidth = (int)((float)this.width * 0.75f);
        I18n i18n = I18n.getInstance();
        this.drawDefaultBackground();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)0, (int)((this.height - this.bottom) * this.mc.resolution.scale), (int)(this.width * this.mc.resolution.scale), (int)(this.scrollRegionHeight * this.mc.resolution.scale));
        this.drawPageItems(this.width / 2 - this.frameWidth / 2, this.top - (int)this.scrollAmount, this.frameWidth);
        GL11.glDisable((int)3089);
        if (this.mc.theWorld == null) {
            Tessellator tessellator = Tessellator.instance;
            GL11.glDisable((int)2929);
            int byte0 = 4;
            this.overlayBackground(0, this.top, 255, 255);
            this.overlayBackground(this.bottom, this.height, 255, 255);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)3008);
            GL11.glShadeModel((int)7425);
            GL11.glDisable((int)3553);
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_I(0, 0);
            tessellator.addVertexWithUV(0.0, this.top + byte0, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(this.width, this.top + byte0, 0.0, 1.0, 1.0);
            tessellator.setColorRGBA_I(0, 255);
            tessellator.addVertexWithUV(this.width, this.top, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(0.0, this.top, 0.0, 0.0, 0.0);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_I(0, 255);
            tessellator.addVertexWithUV(0.0, this.bottom, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(this.width, this.bottom, 0.0, 1.0, 1.0);
            tessellator.setColorRGBA_I(0, 0);
            tessellator.addVertexWithUV(this.width, this.bottom - byte0, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(0.0, this.bottom - byte0, 0.0, 0.0, 0.0);
            tessellator.draw();
            GL11.glEnable((int)3553);
            GL11.glShadeModel((int)7424);
            GL11.glEnable((int)3008);
            GL11.glDisable((int)3042);
        }
        this.drawStringCentered(this.fontRenderer, i18n.translateKey(this.titleLanguageKey), this.width / 2, 5, 0xFFFFFF);
        this.drawScrollBar(x, y);
        this.mc.ppm.update();
        super.drawScreen(x, y, renderPartialTicks);
    }

    protected void drawScrollBar(int mouseX, int mouseY) {
        float totalPageHeight = this.getTotalPageHeight();
        float scrollBarHeightPercent = (float)this.scrollRegionHeight / totalPageHeight;
        if (scrollBarHeightPercent > 1.0f) {
            return;
        }
        int left = (this.width - this.frameWidth) / 2;
        int scrollBarX = left + this.frameWidth + 8;
        int scrollBarHeightPx = (int)(scrollBarHeightPercent * (float)this.scrollRegionHeight);
        if (scrollBarHeightPx < 32) {
            scrollBarHeightPx = 32;
        }
        float scrollPercent = this.scrollAmount / (totalPageHeight - (float)this.scrollRegionHeight);
        int scrollBarY = (int)((float)this.top + (float)(this.scrollRegionHeight - scrollBarHeightPx) * scrollPercent);
        Tessellator t = Tessellator.instance;
        GL11.glDisable((int)3553);
        t.startDrawingQuads();
        t.setColorOpaque(0, 0, 0);
        t.drawRectangle(scrollBarX, this.top, 6, this.scrollRegionHeight);
        t.setColorRGBA_I(0x808080, 255);
        t.drawRectangle(scrollBarX, scrollBarY, 6, scrollBarHeightPx);
        t.setColorRGBA_I(0xC0C0C0, 255);
        t.drawRectangle(scrollBarX + 1, scrollBarY, 5, scrollBarHeightPx - 1);
        t.draw();
        GL11.glEnable((int)3553);
        if (this.clickX != null && this.clickY != null) {
            if (this.clickX >= scrollBarX && this.clickY >= this.top && this.clickX <= scrollBarX + 6 && this.clickY < this.bottom) {
                if (this.oldScrollAmount == null) {
                    this.oldScrollAmount = Float.valueOf(this.scrollAmount);
                }
                this.scrollAmount = this.oldScrollAmount.floatValue() + (float)(this.clickY - mouseY) * (1.0f / scrollBarHeightPercent) * -1.0f;
                this.onScroll();
            } else if (this.lastMouseY != -1) {
                this.scroll(this.lastMouseY - mouseY);
            }
            this.lastMouseY = mouseY;
        } else {
            this.lastMouseY = -1;
            this.oldScrollAmount = null;
        }
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        if (button == 0) {
            for (int l = 0; l < this.controlList.size(); ++l) {
                GuiButton guibutton = (GuiButton)this.controlList.get(l);
                if (guibutton.id >= 1000 && (y <= this.top || y >= this.bottom) || !guibutton.mousePressed(this.mc, x, y)) continue;
                this.selectedButton = guibutton;
                this.mc.sndManager.playSound("random.click", SoundType.GUI_SOUNDS, 1.0f, 1.0f);
                if (guibutton.listener != null) {
                    guibutton.listener.listen(guibutton);
                    continue;
                }
                this.buttonPressed(guibutton);
            }
        }
        int left = (this.width - this.frameWidth) / 2;
        if (button == 0 && (x < left || x > this.width - left)) {
            this.clickX = x;
            this.clickY = y;
        }
    }

    @Override
    public void mouseMovedOrUp(int x, int y, int mouseButton) {
        super.mouseMovedOrUp(x, y, mouseButton);
        if (mouseButton == 0) {
            this.clickX = null;
            this.clickY = null;
        }
    }

    protected abstract void drawPageItems(int var1, int var2, int var3);

    protected abstract int getTotalPageHeight();

    @Override
    public void drawDefaultBackground() {
        super.drawDefaultBackground();
        if (this.mc.theWorld == null) {
            Tessellator tessellator = Tessellator.instance;
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/background.png"));
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float f1 = 32.0f;
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque_I(0x202020);
            tessellator.addVertexWithUV(0.0, this.bottom, 0.0, 0.0, (float)(this.bottom + (int)this.scrollAmount) / f1);
            tessellator.addVertexWithUV(this.width, this.bottom, 0.0, (float)this.width / f1, (float)(this.bottom + (int)this.scrollAmount) / f1);
            tessellator.addVertexWithUV(this.width, this.top, 0.0, (float)this.width / f1, (float)(this.top + (int)this.scrollAmount) / f1);
            tessellator.addVertexWithUV(0.0, this.top, 0.0, 0.0, (float)(this.top + (int)this.scrollAmount) / f1);
            tessellator.draw();
        } else {
            this.drawRect(0, 0, this.width, this.top, 0x5F000000);
            this.drawRect(0, this.bottom, this.width, this.height, 0x5F000000);
        }
    }

    private void overlayBackground(int i, int j, int k, int l) {
        if (this.mc.theWorld == null) {
            Tessellator tessellator = Tessellator.instance;
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/background.png"));
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float f = 32.0f;
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_I(0x404040, l);
            tessellator.addVertexWithUV(0.0, j, 0.0, 0.0, (float)j / f);
            tessellator.addVertexWithUV(this.width, j, 0.0, (float)this.width / f, (float)j / f);
            tessellator.setColorRGBA_I(0x404040, k);
            tessellator.addVertexWithUV(this.width, i, 0.0, (float)this.width / f, (float)i / f);
            tessellator.addVertexWithUV(0.0, i, 0.0, 0.0, (float)i / f);
            tessellator.draw();
        }
    }
}

