/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiControllerSetup;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.options.GuiOptionsButton;
import net.minecraft.client.gui.options.GuiOptionsPageOptionBase;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.KeyBinding;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.core.lang.I18n;

public class GuiOptionsPageControls
extends GuiOptionsPageOptionBase {
    List<KeyBinding[]> keyBindings = new ArrayList<KeyBinding[]>();
    GuiButton activeButton = null;
    KeyBinding activeBinding = null;
    GuiButton btnControllerSetup = null;

    public GuiOptionsPageControls(GuiScreen parent, GameSettings settings) {
        super(parent, settings);
        this.addOptionsCategory("options.category.mouse", this.gameSettings.mouseSensitivity, this.gameSettings.invertMouse, this.gameSettings.rawMouseInput, this.gameSettings.swapMouseButtons, this.gameSettings.enableItemDragging);
        this.addOptionsCategory("options.category.keyboard", this.gameSettings.sneakToggle, this.gameSettings.swapCraftingButtons);
        this.addOptionsCategory("options.category.controller", this.gameSettings.controllerSensitivity, this.gameSettings.controllerMenuSensitivity, this.gameSettings.controllerDeadzoneLeft, this.gameSettings.controllerDeadzoneRight, this.gameSettings.controllerSwapShoulderButtons, this.gameSettings.controllerSwapAB, this.gameSettings.controllerSwapXY);
        this.addKeyBindingsCategory("options.category.movement", this.gameSettings.keyForward, this.gameSettings.keyBack, this.gameSettings.keyLeft, this.gameSettings.keyRight, this.gameSettings.keyJump, this.gameSettings.keySneak, this.gameSettings.keyFly, this.gameSettings.keyAutoWalk);
        this.addKeyBindingsCategory("options.category.ui", this.gameSettings.keyInventory, this.gameSettings.keyChat, this.gameSettings.keyGuidebook, this.gameSettings.keyHotBarLeft, this.gameSettings.keyHotBarRight, this.gameSettings.keyHotBarSwitch, this.gameSettings.keyPlayerList, this.gameSettings.keyHideGui, this.gameSettings.keyToggleOverlay);
        this.addKeyBindingsCategory("options.category.view", this.gameSettings.keyLookLeft, this.gameSettings.keyLookRight, this.gameSettings.keyLookUp, this.gameSettings.keyLookDown, this.gameSettings.keyCenterView, this.gameSettings.keyZoom, this.gameSettings.keyCinematicCamera, this.gameSettings.keySwitchPerspective, this.gameSettings.keyPhotoMode);
        this.addKeyBindingsCategory("options.category.misc", this.gameSettings.keyToggleFog, this.gameSettings.keyLockRotation, this.gameSettings.keyScreenshot, this.gameSettings.keyDrop);
    }

    @Override
    protected void buttonPressed(GuiButton guibutton) {
        if (guibutton == this.btnControllerSetup) {
            this.mc.displayGuiScreen(new GuiControllerSetup(this));
        } else {
            super.buttonPressed(guibutton);
        }
    }

    @Override
    public void initGui() {
        super.initGui();
        this.btnControllerSetup = new GuiButton(1, this.width / 2 - 100, this.top + 4, 200, 20, "Controller Setup");
        this.yOffset = 24;
        this.controlList.add(this.btnControllerSetup);
    }

    @Override
    public void drawScreen(int x, int y, float renderPartialTicks) {
        this.controlList.remove(this.btnControllerSetup);
        super.drawScreen(x, y, renderPartialTicks);
        this.controlList.add(this.btnControllerSetup);
    }

    protected void addKeyBindingsCategory(String languageKey, KeyBinding ... bindings) {
        int numButtons = this.keyBindings.size();
        this.categoryKeys.add(languageKey);
        this.keyBindings.add(bindings);
        this.buttons.add(new GuiButton[bindings.length]);
        int categoryIndex = this.categoryKeys.size() - 1;
        for (int i = 0; i < bindings.length; ++i) {
            KeyBinding binding = bindings[i];
            if (binding == null) continue;
            GuiOptionsButton button = new GuiOptionsButton(2000 + numButtons + i, 0, 0, 100, 20, binding.getKeyName());
            ((GuiButton[])this.buttons.get((int)categoryIndex))[i] = button;
        }
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        boolean removed = false;
        if (this.btnControllerSetup.yPosition < this.top) {
            this.controlList.remove(this.btnControllerSetup);
            removed = true;
        }
        super.mouseClicked(x, y, button);
        if (removed) {
            this.controlList.add(this.btnControllerSetup);
        }
    }

    @Override
    protected void drawPageItems(int x, int y, int width) {
        super.drawPageItems(x, y, width);
        FontRenderer fr = this.mc.fontRenderer;
        this.btnControllerSetup.yPosition = y + 4;
        this.btnControllerSetup.drawButton(this.mc, this.mouseX, this.mouseY);
        int previousHeights = y + super.getTotalPageHeight();
        for (int i = 0; i < this.keyBindings.size(); ++i) {
            String languageKey = (String)this.categoryKeys.get(this.options.size() + i);
            KeyBinding[] bindings = this.keyBindings.get(i);
            GuiButton[] buttons = (GuiButton[])this.buttons.get(this.options.size() + i);
            int textHeight = this.padding + 10 + 10 + this.padding;
            fr.drawStringWithShadow(I18n.getInstance().translateKey(languageKey), x + this.padding, previousHeights + this.padding + 10, 0x7F7F7F);
            previousHeights += textHeight;
            for (int j = 0; j < bindings.length; ++j) {
                GuiButton button = buttons[j];
                int myHeight = this.padding + button.height + this.padding;
                button.xPosition = x + width - button.width - this.padding;
                button.yPosition = previousHeights + this.padding;
                button.drawButton(this.mc, this.mouseX, this.mouseY);
                fr.drawStringWithShadow(I18n.getInstance().translateKey(bindings[j].name), x + this.padding + 16, previousHeights + myHeight / 2 - 5, 0xFFFFFF);
                int stringWidth = fr.getStringWidth(I18n.getInstance().translateKey(bindings[j].name));
                this.drawRect(x + this.padding + 16 + (stringWidth += 8), previousHeights + myHeight / 2, button.xPosition - 8, previousHeights + myHeight / 2 + 1, 0x5F7F7F7F);
                previousHeights += myHeight;
            }
        }
    }

    @Override
    protected void handleButtonClick(GuiButton guibutton, int categoryIndex, int optionIndex) {
        if (categoryIndex < this.options.size()) {
            super.handleButtonClick(guibutton, categoryIndex, optionIndex);
        } else {
            KeyBinding binding = this.keyBindings.get(categoryIndex - this.options.size())[optionIndex];
            this.activeButton = guibutton;
            this.activeBinding = binding;
            guibutton.displayString = "> " + binding.getKeyName() + " <";
        }
    }

    @Override
    protected void handleButtonRelease(GuiButton guibutton, int categoryIndex, int optionIndex) {
        if (categoryIndex < this.options.size()) {
            super.handleButtonRelease(guibutton, categoryIndex, optionIndex);
        }
    }

    @Override
    protected int getTotalPageHeight() {
        int height = super.getTotalPageHeight();
        height += this.keyBindings.size() * (this.padding + 10 + 10 + this.padding);
        for (KeyBinding[] binding : this.keyBindings) {
            height += binding.length * (this.padding + 20 + this.padding);
        }
        return height;
    }

    @Override
    public void keyTyped(char c, int i, int mouseX, int mouseY) {
        if (this.activeButton != null && this.activeBinding != null) {
            if (i != 1) {
                this.activeBinding.setKeyCode(i);
                this.activeButton.displayString = this.activeBinding.getKeyName();
            } else {
                this.activeButton.displayString = this.activeBinding.getKeyName();
            }
            this.activeButton = null;
            this.activeBinding = null;
        } else {
            if (i == 211) {
                for (int j = 0; j < this.keyBindings.size(); ++j) {
                    KeyBinding[] bindings = this.keyBindings.get(j);
                    GuiButton[] buttons = (GuiButton[])this.buttons.get(this.options.size() + j);
                    for (int k = 0; k < bindings.length; ++k) {
                        if (!buttons[k].isHovered(mouseX, mouseY)) continue;
                        bindings[k].setKeyCode(-1);
                        buttons[k].displayString = I18n.getInstance().translateKey("key.disabled");
                    }
                }
            }
            super.keyTyped(c, i, mouseX, mouseY);
        }
    }
}

