/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.popup;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.popup.InteractivePopupComponent;
import net.minecraft.client.gui.popup.PopupCloseListener;
import net.minecraft.client.gui.popup.PopupComponent;
import net.minecraft.client.render.Tessellator;
import net.minecraft.core.util.helper.Color;
import org.lwjgl.opengl.GL11;

public final class GuiPopup
extends GuiScreen {
    static final int HORIZONTAL_MARGIN = 8;
    static final int VERTICAL_MARGIN = 8;
    static final int COMPONENT_GAP = 4;
    private final GuiScreen parent;
    private final int popupWidth;
    private final int popupHeight;
    private final Integer statusCodeOnEsc;
    private final Integer statusCodeOnEnter;
    private final Integer statusCodeOnClickOut;
    private final List<PopupComponent> components;
    private final Map<PopupComponent, String> componentKeyMap;
    private final List<PopupCloseListener> onCloseListeners;
    private int statusCode = -1;

    GuiPopup(GuiScreen parent, int width, int height, Integer statusCodeOnEsc, Integer statusCodeOnEnter, Integer statusCodeOnClickOut, List<PopupComponent> components, Map<PopupComponent, String> componentKeyMap, List<PopupCloseListener> onCloseListeners) {
        this.parent = parent;
        this.popupWidth = width;
        this.popupHeight = height;
        this.statusCodeOnEsc = statusCodeOnEsc;
        this.statusCodeOnEnter = statusCodeOnEnter;
        this.statusCodeOnClickOut = statusCodeOnClickOut;
        this.components = components;
        this.componentKeyMap = componentKeyMap;
        this.onCloseListeners = onCloseListeners;
    }

    void close(int statusCode) {
        this.statusCode = statusCode;
        this.onGuiClosed();
        this.mc.currentScreen = this.parent;
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        for (PopupComponent component : this.components) {
            component.tick();
        }
    }

    @Override
    public void onGuiClosed() {
        super.onGuiClosed();
        HashMap results = new HashMap();
        for (Map.Entry<PopupComponent, String> entry : this.componentKeyMap.entrySet()) {
            if (!(entry.getKey() instanceof InteractivePopupComponent)) continue;
            Object value = ((InteractivePopupComponent)entry.getKey()).getOutput();
            results.put(entry.getValue(), value);
        }
        for (PopupCloseListener listener : this.onCloseListeners) {
            listener.onClosed(this.statusCode, results);
        }
    }

    @Override
    public void initGui() {
        if (this.parent.width != this.width || this.parent.height != this.height) {
            this.parent.width = this.width;
            this.parent.height = this.height;
            this.parent.controlList.clear();
            this.parent.initGui();
        }
        super.initGui();
    }

    @Override
    public void keyTyped(char c, int key, int mouseX, int mouseY) {
        if (key == 1 && this.statusCodeOnEsc != null) {
            this.close(this.statusCodeOnEsc);
        }
        if (key == 28 && this.statusCodeOnEnter != null) {
            this.close(this.statusCodeOnEnter);
        }
        for (PopupComponent component : this.components) {
            component.onKeyDown(key, c);
        }
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        if (this.statusCodeOnClickOut != null) {
            int popupX = this.width / 2 - this.popupWidth / 2;
            int popupY = this.height / 2 - this.popupHeight / 2;
            if (x < popupX || x > popupX + this.popupWidth || y < popupY || y > popupY + this.popupHeight) {
                this.close(this.statusCodeOnClickOut);
            }
        }
        super.mouseClicked(x, y, button);
        for (PopupComponent component : this.components) {
            component.onClick(x, y, button);
        }
    }

    @Override
    public void mouseMovedOrUp(int x, int y, int mouseButton) {
        super.mouseMovedOrUp(x, y, mouseButton);
        for (PopupComponent component : this.components) {
            component.mouseMovedOrUp(x, y, mouseButton);
        }
    }

    @Override
    public void drawScreen(int x, int y, float renderPartialTicks) {
        int popupX = this.width / 2 - this.popupWidth / 2;
        int popupY = this.height / 2 - this.popupHeight / 2;
        this.parent.drawScreen(-1, -1, renderPartialTicks);
        this.drawPopupBackground();
        int accY = popupY + 8;
        for (PopupComponent component : this.components) {
            component.render(popupX + 8, accY, x, y);
            accY += component.getHeight() + 4;
        }
        super.drawScreen(x, y, renderPartialTicks);
    }

    private void drawPopupBackground() {
        int popupX = this.width / 2 - this.popupWidth / 2;
        int popupY = this.height / 2 - this.popupHeight / 2;
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        Tessellator tessellator = Tessellator.instance;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int color = ((Color)this.mc.gameSettings.guiBackgroundColor.value).getARGB();
        this.drawGradientRect(0, 0, this.width, this.height, color, color);
        this.drawRectWidthHeight(popupX - 1, popupY - 1, this.popupWidth + 2, this.popupHeight + 2, -6250336);
        GL11.glEnable((int)3553);
        float f = 32.0f;
        tessellator.startDrawingQuads();
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/background.png"));
        tessellator.setColorOpaque_I(0x404040);
        tessellator.addVertexWithUV(popupX, popupY + this.popupHeight, 0.0, 0.0, (float)this.popupHeight / f);
        tessellator.addVertexWithUV(popupX + this.popupWidth, popupY + this.popupHeight, 0.0, (float)this.popupWidth / f, (float)this.popupHeight / f);
        tessellator.addVertexWithUV(popupX + this.popupWidth, popupY, 0.0, (float)this.popupWidth / f, 0.0);
        tessellator.addVertexWithUV(popupX, popupY, 0.0, 0.0, 0.0);
        tessellator.draw();
    }
}

