/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.popup;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTooltip;
import net.minecraft.client.gui.popup.InteractivePopupComponent;
import net.minecraft.client.render.Tessellator;
import net.minecraft.core.sound.SoundType;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class ListComponent
extends InteractivePopupComponent<Integer> {
    private final Minecraft minecraft = Minecraft.getMinecraft(this);
    private int selectedItem = 0;
    private float scrollAmount = 0.0f;
    private final GuiButton[] buttons;
    private final int height;
    private int lastX = 0;
    private int lastY = 0;
    private final boolean closeOnItemSelected;
    private final GuiTooltip tooltip;
    private final String[] buttonTooltips;
    private int scrollbarX;
    private int scrollbarY;
    private int scrollbarWidth;
    private int scrollbarHeight;
    private boolean isScrolling = false;
    private int clickY;
    private float previousScrollAmount = 0.0f;

    public ListComponent(int width, int height, String[] buttonLabels, String[] buttonTooltips, int selectedItem, boolean closeOnItemSelected) {
        super(width);
        this.height = height;
        this.closeOnItemSelected = closeOnItemSelected;
        this.tooltip = new GuiTooltip(this.minecraft);
        this.selectedItem = selectedItem;
        this.buttonTooltips = buttonTooltips;
        this.buttons = new GuiButton[buttonLabels.length];
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i] = new GuiButton(i, 0, 0, width - 2 - 6, 20, buttonLabels[i]);
            if (i != selectedItem) continue;
            this.buttons[i].enabled = false;
        }
        float ratio = (float)(this.getScrollableHeight() + this.height) / (float)this.getScrollableHeight();
        float sc = (float)selectedItem / (float)(this.buttons.length - 4) * ratio;
        this.scroll(sc -= (float)this.height / (float)this.getScrollableHeight());
    }

    @Override
    public Integer getOutput() {
        return this.selectedItem;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    private void scroll(float amount) {
        this.scrollAmount = MathHelper.clamp(this.scrollAmount + amount, 0.0f, 1.0f);
    }

    @Override
    public void render(int x, int y, int mouseX, int mouseY) {
        GuiButton button;
        int i;
        float wheel;
        this.lastX = x;
        this.lastY = y;
        if (this.mouseInRegion(x, y, mouseX, mouseY) && (wheel = (float)Mouse.getDWheel()) != 0.0f) {
            this.scroll(wheel / -1200.0f);
        }
        GL11.glDisable((int)3553);
        this.drawBackground(x, y);
        this.drawScrollbar(x, y, mouseX, mouseY);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((x + 1) * this.minecraft.resolution.scale), (int)((this.getParent().height - (y - 1) - this.height) * this.minecraft.resolution.scale), (int)((this.getWidth() - 2) * this.minecraft.resolution.scale), (int)((this.height - 2) * this.minecraft.resolution.scale));
        GL11.glEnable((int)3553);
        for (i = 0; i < this.buttons.length; ++i) {
            button = this.buttons[i];
            button.xPosition = x + 1;
            button.yPosition = y + 1 + i * 20 - this.getScrollPixels();
            if (this.mouseInRegion(x, y, mouseX, mouseY)) {
                button.drawButton(this.minecraft, mouseX, mouseY);
                continue;
            }
            button.drawButton(this.minecraft, -1, -1);
        }
        GL11.glDisable((int)3089);
        if (this.buttonTooltips != null && this.mouseInRegion(x, y, mouseX, mouseY)) {
            for (i = 0; i < this.buttons.length; ++i) {
                button = this.buttons[i];
                if (!button.isHovered(mouseX, mouseY)) continue;
                this.tooltip.render(this.buttonTooltips[i], mouseX, mouseY, 0, 0);
                break;
            }
        }
    }

    private boolean mouseInRegion(int x, int y, int mouseX, int mouseY) {
        return mouseX >= x && mouseX < x + this.getWidth() && mouseY >= y && mouseY < y + this.height;
    }

    private int getScrollPixels() {
        return (int)(this.scrollAmount * (float)(this.getScrollableHeight() - (this.height - 2)));
    }

    private int getScrollableHeight() {
        return 20 * this.buttons.length;
    }

    @Override
    public void onClick(int x, int y, int button) {
        super.onClick(x, y, button);
        if (button == 0 && x >= this.scrollbarX && x < this.scrollbarX + this.scrollbarWidth && y >= this.scrollbarY && y < this.scrollbarY + this.scrollbarHeight) {
            this.isScrolling = true;
            this.previousScrollAmount = this.scrollAmount;
            this.clickY = y;
            System.out.println("Start scrolling! " + this.scrollAmount);
            return;
        }
        if (this.mouseInRegion(this.lastX, this.lastY, x, y)) {
            for (GuiButton b : this.buttons) {
                if (!b.mousePressed(this.minecraft, x, y)) continue;
                for (GuiButton b2 : this.buttons) {
                    b2.enabled = true;
                }
                b.enabled = false;
                this.selectedItem = b.id;
                if (!this.closeOnItemSelected) break;
                this.getParent().close(1);
                this.minecraft.sndManager.playSound("random.click", SoundType.GUI_SOUNDS, 1.0f, 1.0f);
                break;
            }
        }
    }

    @Override
    public void mouseMovedOrUp(int x, int y, int button) {
        super.mouseMovedOrUp(x, y, button);
        if (button == 0) {
            this.isScrolling = false;
            this.previousScrollAmount = 0.0f;
            this.clickY = 0;
        }
    }

    private void drawBackground(int x, int y) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0xA0A0A0);
        tessellator.addVertex(x, y + this.height, 0.0);
        tessellator.addVertex(x + this.getWidth(), y + this.height, 0.0);
        tessellator.addVertex(x + this.getWidth(), y, 0.0);
        tessellator.addVertex(x, y, 0.0);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0);
        tessellator.addVertex(x + 1, y + this.height - 1, 0.0);
        tessellator.addVertex(x + this.getWidth() - 1, y + this.height - 1, 0.0);
        tessellator.addVertex(x + this.getWidth() - 1, y + 1, 0.0);
        tessellator.addVertex(x + 1, y + 1, 0.0);
        tessellator.draw();
    }

    private void drawScrollbar(int x, int y, int mouseX, int mouseY) {
        int scrollableHeight = this.getScrollableHeight();
        int displayRegionHeight = this.height - 2;
        float scrollbarScale = (float)displayRegionHeight / (float)scrollableHeight;
        this.scrollbarWidth = 6;
        this.scrollbarHeight = (int)(scrollbarScale * (float)displayRegionHeight);
        int minScrollbarY = 0;
        int maxScrollbarY = displayRegionHeight - this.scrollbarHeight;
        int scrollbarDelta = maxScrollbarY - minScrollbarY;
        this.scrollbarY = y + 1 + (int)(this.scrollAmount * (float)scrollbarDelta);
        this.scrollbarX = x + this.getWidth() - 1 - 6;
        Tessellator t = Tessellator.instance;
        t.startDrawingQuads();
        t.setColorRGBA_I(0x808080, 255);
        t.drawRectangle(this.scrollbarX, this.scrollbarY, 6, this.scrollbarHeight);
        t.setColorRGBA_I(0xC0C0C0, 255);
        t.drawRectangle(this.scrollbarX, this.scrollbarY, 5, this.scrollbarHeight - 1);
        t.draw();
        if (this.isScrolling) {
            int delta = mouseY - this.clickY;
            float scrolledScreens = (float)delta / (float)this.scrollbarHeight;
            float scrolledPixels = (float)displayRegionHeight * scrolledScreens;
            float scrolledAmount = scrolledPixels / (float)(scrollableHeight - displayRegionHeight);
            this.scrollAmount = MathHelper.clamp(this.previousScrollAmount + scrolledAmount, 0.0f, 1.0f);
        }
    }
}

