/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.EntityPlayerSP;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.MapItemRenderer;
import net.minecraft.client.render.PlayerSkinParser;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.Tessellator;
import net.minecraft.client.render.TextureFX;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.BlockModelRenderBlocks;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.entity.PlayerRenderer;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.saveddata.maps.ItemMapSavedData;
import org.lwjgl.opengl.GL11;

public class ItemRenderer {
    private Minecraft mc;
    private ItemStack itemToRender = null;
    private float equippedProgress = 0.0f;
    private float prevEquippedProgress = 0.0f;
    private RenderBlocks renderBlocksInstance = new RenderBlocks();
    private MapItemRenderer renderMapInstance;
    private int field_20099_f = -1;

    public ItemRenderer(Minecraft minecraft) {
        this.mc = minecraft;
        this.renderMapInstance = new MapItemRenderer(minecraft.fontRenderer, minecraft.gameSettings, minecraft.renderEngine);
    }

    public void renderItem(EntityLiving entityLiving, ItemStack itemStack) {
        this.renderItem(entityLiving, itemStack, true);
    }

    public void renderItem(Entity entity, ItemStack itemstack, boolean handheldTransform) {
        GL11.glPushMatrix();
        BlockModelRenderBlocks.setRenderBlocks(this.renderBlocksInstance);
        if (itemstack.itemID < Block.blocksList.length && ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Block.blocksList[itemstack.itemID])).shouldItemRender3d()) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/terrain.png"));
            float brightness = entity.getBrightness(1.0f);
            if (this.mc.fullbright) {
                brightness = 1.0f;
            }
            this.renderBlocksInstance.renderBlockOnInventory(Block.blocksList[itemstack.itemID], itemstack.getMetadata(), brightness);
            GL11.glDisable((int)3042);
        } else {
            int tileWidth;
            if (itemstack.itemID < Block.blocksList.length) {
                GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/terrain.png"));
                tileWidth = TextureFX.tileWidthTerrain;
            } else {
                GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/items.png"));
                tileWidth = TextureFX.tileWidthItems;
            }
            Tessellator tessellator = Tessellator.instance;
            int i = itemstack.getItem().getIconIndex(itemstack);
            if (entity instanceof EntityLiving) {
                i = ((EntityLiving)entity).getItemIcon(itemstack);
            }
            float f = ((float)(i % Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth) + 0.0f) / (float)(Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth);
            float f1 = ((float)(i % Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth) + ((float)tileWidth - 0.01f)) / (float)(Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth);
            float f2 = ((float)(i / Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth) + 0.0f) / (float)(Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth);
            float f3 = ((float)(i / Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth) + ((float)tileWidth - 0.01f)) / (float)(Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth);
            float f4 = 1.0f;
            float f5 = 0.0f;
            float f6 = 0.3f;
            float foon = 0.5f / (float)tileWidth / (float)Global.TEXTURE_ATLAS_WIDTH_TILES;
            float goon = 0.0625f * (16.0f / (float)tileWidth);
            GL11.glEnable((int)32826);
            if (handheldTransform) {
                GL11.glTranslatef((float)(-f5), (float)(-f6), (float)0.0f);
                float f7 = 1.5f;
                GL11.glScalef((float)f7, (float)f7, (float)f7);
                GL11.glRotatef((float)50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)335.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)-0.9375f, (float)-0.0625f, (float)0.0f);
            }
            float thickness = 0.0625f;
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            tessellator.addVertexWithUV(0.0, 0.0, 0.0, f1, f3);
            tessellator.addVertexWithUV(f4, 0.0, 0.0, f, f3);
            tessellator.addVertexWithUV(f4, 1.0, 0.0, f, f2);
            tessellator.addVertexWithUV(0.0, 1.0, 0.0, f1, f2);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            tessellator.addVertexWithUV(0.0, 1.0, 0.0f - thickness, f1, f2);
            tessellator.addVertexWithUV(f4, 1.0, 0.0f - thickness, f, f2);
            tessellator.addVertexWithUV(f4, 0.0, 0.0f - thickness, f, f3);
            tessellator.addVertexWithUV(0.0, 0.0, 0.0f - thickness, f1, f3);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            for (int j = 0; j < tileWidth; ++j) {
                float f9 = (float)j / (float)tileWidth;
                float f13 = f1 + (f - f1) * f9 - foon;
                float f17 = f4 * f9;
                tessellator.addVertexWithUV(f17, 0.0, 0.0f - thickness, f13, f3);
                tessellator.addVertexWithUV(f17, 0.0, 0.0, f13, f3);
                tessellator.addVertexWithUV(f17, 1.0, 0.0, f13, f2);
                tessellator.addVertexWithUV(f17, 1.0, 0.0f - thickness, f13, f2);
            }
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            for (int k = 0; k < tileWidth; ++k) {
                float f10 = (float)k / (float)tileWidth;
                float f14 = f1 + (f - f1) * f10 - foon;
                float f18 = f4 * f10 + goon;
                tessellator.addVertexWithUV(f18, 1.0, 0.0f - thickness, f14, f2);
                tessellator.addVertexWithUV(f18, 1.0, 0.0, f14, f2);
                tessellator.addVertexWithUV(f18, 0.0, 0.0, f14, f3);
                tessellator.addVertexWithUV(f18, 0.0, 0.0f - thickness, f14, f3);
            }
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            for (int l = 0; l < tileWidth; ++l) {
                float f11 = (float)l / (float)tileWidth;
                float f15 = f3 + (f2 - f3) * f11 - foon;
                float f19 = f4 * f11 + goon;
                tessellator.addVertexWithUV(0.0, f19, 0.0, f1, f15);
                tessellator.addVertexWithUV(f4, f19, 0.0, f, f15);
                tessellator.addVertexWithUV(f4, f19, 0.0f - thickness, f, f15);
                tessellator.addVertexWithUV(0.0, f19, 0.0f - thickness, f1, f15);
            }
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            for (int i1 = 0; i1 < tileWidth; ++i1) {
                float f12 = (float)i1 / (float)tileWidth;
                float f16 = f3 + (f2 - f3) * f12 - foon;
                float f20 = f4 * f12;
                tessellator.addVertexWithUV(f4, f20, 0.0, f, f16);
                tessellator.addVertexWithUV(0.0, f20, 0.0, f1, f16);
                tessellator.addVertexWithUV(0.0, f20, 0.0f - thickness, f1, f16);
                tessellator.addVertexWithUV(f4, f20, 0.0f - thickness, f, f16);
            }
            tessellator.draw();
            GL11.glDisable((int)32826);
        }
        GL11.glPopMatrix();
    }

    public void renderItemInFirstPerson(float renderPartialTicks) {
        float equipProgress = this.prevEquippedProgress + (this.equippedProgress - this.prevEquippedProgress) * renderPartialTicks;
        EntityPlayerSP player = this.mc.thePlayer;
        float rotationPitch = player.xRotO + (player.xRot - player.xRotO) * renderPartialTicks;
        GL11.glPushMatrix();
        GL11.glRotatef((float)rotationPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(player.yRotO + (player.yRot - player.yRotO) * renderPartialTicks), (float)0.0f, (float)1.0f, (float)0.0f);
        Lighting.turnOff();
        GL11.glPopMatrix();
        ItemStack itemstack = this.itemToRender;
        float brightness = this.mc.theWorld.getLightBrightness(MathHelper.floor_double(player.x), MathHelper.floor_double(player.y), MathHelper.floor_double(player.z));
        if (this.mc.fullbright) {
            brightness = 1.0f;
        }
        if (itemstack != null) {
            int argb = Item.itemsList[itemstack.itemID].getColorFromDamage(itemstack.getMetadata());
            float r = (float)(argb >> 16 & 0xFF) / 255.0f;
            float g = (float)(argb >> 8 & 0xFF) / 255.0f;
            float b = (float)(argb & 0xFF) / 255.0f;
            GL11.glColor4f((float)(brightness * r), (float)(brightness * g), (float)(brightness * b), (float)1.0f);
        } else {
            GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        }
        if (itemstack != null && itemstack.itemID == Item.map.id) {
            GL11.glPushMatrix();
            float f4 = 0.8f;
            float swingProgress = player.getSwingProgress(renderPartialTicks);
            float f12 = MathHelper.sin(swingProgress * 3.141593f);
            float f16 = MathHelper.sin(MathHelper.sqrt_float(swingProgress) * 3.141593f);
            GL11.glTranslatef((float)(-f16 * 0.4f), (float)(MathHelper.sin(MathHelper.sqrt_float(swingProgress) * 3.141593f * 2.0f) * 0.2f), (float)(-f12 * 0.2f));
            swingProgress = 1.0f - rotationPitch / 45.0f + 0.1f;
            if (swingProgress < 0.0f) {
                swingProgress = 0.0f;
            }
            if (swingProgress > 1.0f) {
                swingProgress = 1.0f;
            }
            swingProgress = -MathHelper.cos(swingProgress * 3.141593f) * 0.5f + 0.5f;
            GL11.glTranslatef((float)0.0f, (float)(0.0f * f4 - (1.0f - equipProgress) * 1.2f - swingProgress * 0.5f + 0.04f), (float)(-0.9f * f4));
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(swingProgress * -85.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glEnable((int)32826);
            this.mc.renderEngine.loadDownloadableTexture(this.mc.thePlayer.skinURL, this.mc.thePlayer.getEntityTexture(), PlayerSkinParser.instance);
            for (f12 = 0.0f; f12 < 2.0f; f12 += 1.0f) {
                f16 = f12 * 2.0f - 1.0f;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)-0.0f, (float)-0.6f, (float)(1.1f * f16));
                GL11.glRotatef((float)(-45.0f * f16), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)59.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)(-65.0f * f16), (float)0.0f, (float)1.0f, (float)0.0f);
                EntityRenderer render1 = EntityRenderDispatcher.instance.getRenderer(this.mc.thePlayer);
                PlayerRenderer renderplayer1 = (PlayerRenderer)render1;
                float f20 = 1.0f;
                GL11.glScalef((float)f20, (float)f20, (float)f20);
                renderplayer1.drawFirstPersonHand(this.mc.thePlayer);
                GL11.glPopMatrix();
            }
            f12 = player.getSwingProgress(renderPartialTicks);
            f16 = MathHelper.sin(f12 * f12 * 3.141593f);
            float f19 = MathHelper.sin(MathHelper.sqrt_float(f12) * 3.141593f);
            GL11.glRotatef((float)(-f16 * 20.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-f19 * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(-f19 * 80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            f12 = 0.38f;
            GL11.glScalef((float)f12, (float)f12, (float)f12);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-1.0f, (float)-1.0f, (float)0.0f);
            f16 = 0.015625f;
            GL11.glScalef((float)f16, (float)f16, (float)f16);
            this.mc.renderEngine.bindTexture(this.mc.renderEngine.getTexture("/misc/mapbg.png"));
            Tessellator tessellator = Tessellator.instance;
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
            tessellator.startDrawingQuads();
            int byte0 = 7;
            tessellator.addVertexWithUV(0 - byte0, 128 + byte0, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(128 + byte0, 128 + byte0, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(128 + byte0, 0 - byte0, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(0 - byte0, 0 - byte0, 0.0, 0.0, 0.0);
            tessellator.draw();
            ItemMapSavedData mapdata = Item.map.getOrCreateSavedData(itemstack, this.mc.theWorld);
            this.renderMapInstance.renderMap(this.mc.renderEngine, mapdata);
            GL11.glPopMatrix();
        } else if (itemstack != null) {
            BlockModel model;
            GL11.glPushMatrix();
            float f5 = 0.8f;
            float f9 = player.getSwingProgress(renderPartialTicks);
            float f13 = MathHelper.sin(f9 * 3.141593f);
            float f17 = MathHelper.sin(MathHelper.sqrt_float(f9) * 3.141593f);
            GL11.glTranslatef((float)(-f17 * 0.4f), (float)(MathHelper.sin(MathHelper.sqrt_float(f9) * 3.141593f * 2.0f) * 0.2f), (float)(-f13 * 0.2f));
            GL11.glTranslatef((float)(0.7f * f5), (float)(-0.65f * f5 - (1.0f - equipProgress) * 0.6f), (float)(-0.9f * f5));
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glEnable((int)32826);
            f9 = player.getSwingProgress(renderPartialTicks);
            f13 = MathHelper.sin(f9 * f9 * 3.141593f);
            f17 = MathHelper.sin(MathHelper.sqrt_float(f9) * 3.141593f);
            GL11.glRotatef((float)(-f13 * 20.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-f17 * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(-f17 * 80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            f9 = 0.4f;
            GL11.glScalef((float)f9, (float)f9, (float)f9);
            if (itemstack.getItem().shouldRotateAroundWhenRendering()) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (itemstack.getItem().shouldPointInFrontOfPlayer()) {
                GL11.glRotatef((float)-20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (itemstack.getItem() instanceof ItemBlock && (model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(((ItemBlock)itemstack.getItem()).getBlock())).shouldItemRender3d()) {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            this.renderItem(player, itemstack);
            GL11.glPopMatrix();
        } else {
            GL11.glPushMatrix();
            float f6 = 0.8f;
            float f10 = player.getSwingProgress(renderPartialTicks);
            float f14 = MathHelper.sin(f10 * 3.141593f);
            float f18 = MathHelper.sin(MathHelper.sqrt_float(f10) * 3.141593f);
            GL11.glTranslatef((float)(-f18 * 0.3f), (float)(MathHelper.sin(MathHelper.sqrt_float(f10) * 3.141593f * 2.0f) * 0.4f), (float)(-f14 * 0.4f));
            GL11.glTranslatef((float)(0.8f * f6), (float)(-0.75f * f6 - (1.0f - equipProgress) * 0.6f), (float)(-0.9f * f6));
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glEnable((int)32826);
            f10 = player.getSwingProgress(renderPartialTicks);
            f14 = MathHelper.sin(f10 * f10 * 3.141593f);
            f18 = MathHelper.sin(MathHelper.sqrt_float(f10) * 3.141593f);
            GL11.glRotatef((float)(f18 * 70.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-f14 * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            this.mc.renderEngine.loadDownloadableTexture(this.mc.thePlayer.skinURL, this.mc.thePlayer.getEntityTexture(), PlayerSkinParser.instance);
            GL11.glTranslatef((float)-1.0f, (float)3.6f, (float)3.5f);
            GL11.glRotatef((float)120.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)200.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)5.6f, (float)0.0f, (float)0.0f);
            EntityRenderer render = EntityRenderDispatcher.instance.getRenderer(this.mc.thePlayer);
            PlayerRenderer renderplayer = (PlayerRenderer)render;
            f18 = 1.0f;
            renderplayer.drawFirstPersonHand(this.mc.thePlayer);
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)32826);
        Lighting.turnOn();
    }

    public void renderOverlays(float partialTicks) {
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3008);
        if (this.mc.thePlayer.isOnFire()) {
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/terrain.png"));
            this.renderFireInFirstPerson(partialTicks);
        }
        if (this.mc.thePlayer.isInWall() && !this.mc.thePlayer.noPhysics) {
            int blockX = MathHelper.floor_double(this.mc.thePlayer.x);
            int blockY = MathHelper.floor_double(this.mc.thePlayer.y);
            int blockZ = MathHelper.floor_double(this.mc.thePlayer.z);
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/terrain.png"));
            int id = this.mc.theWorld.getBlockId(blockX, blockY, blockZ);
            if (this.mc.theWorld.isBlockNormalCube(blockX, blockY, blockZ)) {
                this.renderInsideOfBlock(partialTicks, Block.blocksList[id].getBlockTextureFromSideAndMetadata(Side.NORTH, 0));
            } else {
                for (int i = 0; i < 8; ++i) {
                    int z1;
                    int y1;
                    float x0 = ((float)((i >> 0) % 2) - 0.5f) * this.mc.thePlayer.bbWidth * 0.9f;
                    float y0 = ((float)((i >> 1) % 2) - 0.5f) * this.mc.thePlayer.bbHeight * 0.2f;
                    float z0 = ((float)((i >> 2) % 2) - 0.5f) * this.mc.thePlayer.bbWidth * 0.9f;
                    int x1 = MathHelper.floor_float((float)blockX + x0);
                    if (!this.mc.theWorld.isBlockNormalCube(x1, y1 = MathHelper.floor_float((float)blockY + y0), z1 = MathHelper.floor_float((float)blockZ + z0))) continue;
                    id = this.mc.theWorld.getBlockId(x1, y1, z1);
                }
            }
            if (Block.blocksList[id] != null) {
                this.renderInsideOfBlock(partialTicks, Block.blocksList[id].getBlockTextureFromSideAndMetadata(Side.NORTH, 0));
            }
        }
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2929);
    }

    private void renderInsideOfBlock(float partialTicks, int texture) {
        Tessellator tessellator = Tessellator.instance;
        float brightness = 0.1f;
        if (this.mc.fullbright) {
            brightness = 1.0f;
        }
        GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)0.5f);
        GL11.glPushMatrix();
        float x0 = -1.0f;
        float x1 = 1.0f;
        float y0 = -1.0f;
        float y1 = 1.0f;
        float z = -0.5f;
        int atlasWidthTiles = Global.TEXTURE_ATLAS_WIDTH_TILES;
        int tileX = texture % atlasWidthTiles;
        int tileY = texture / atlasWidthTiles;
        float u0 = (float)tileX / (float)atlasWidthTiles;
        float v0 = (float)tileY / (float)atlasWidthTiles;
        float u1 = (float)(tileX + 1) / (float)atlasWidthTiles;
        float v1 = (float)(tileY + 1) / (float)atlasWidthTiles;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x0, y0, z, u1, v1);
        tessellator.addVertexWithUV(x1, y0, z, u0, v1);
        tessellator.addVertexWithUV(x1, y1, z, u0, v0);
        tessellator.addVertexWithUV(x0, y1, z, u1, v0);
        tessellator.draw();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderWarpedTextureOverlay(float f) {
        Tessellator tessellator = Tessellator.instance;
        float f1 = this.mc.thePlayer.getBrightness(f);
        if (this.mc.fullbright) {
            f1 = 1.0f;
        }
        GL11.glColor4f((float)f1, (float)f1, (float)f1, (float)0.5f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPushMatrix();
        float f2 = 4.0f;
        float f3 = -1.0f;
        float f4 = 1.0f;
        float f5 = -1.0f;
        float f6 = 1.0f;
        float f7 = -0.5f;
        float f8 = -this.mc.thePlayer.yRot / 64.0f;
        float f9 = this.mc.thePlayer.xRot / 64.0f;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(f3, f5, f7, f2 + f8, f2 + f9);
        tessellator.addVertexWithUV(f4, f5, f7, 0.0f + f8, f2 + f9);
        tessellator.addVertexWithUV(f4, f6, f7, 0.0f + f8, 0.0f + f9);
        tessellator.addVertexWithUV(f3, f6, f7, f2 + f8, 0.0f + f9);
        tessellator.draw();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    private void renderFireInFirstPerson(float f) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        float f1 = 1.0f;
        for (int i = 0; i < 2; ++i) {
            GL11.glPushMatrix();
            int j = Block.texCoordToIndex(15, 1 + i);
            int k = j % Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
            int l = j / Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
            float f2 = (float)k / (float)(Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain);
            float f3 = ((float)k + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain);
            float f4 = (float)l / (float)(Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain);
            float f5 = ((float)l + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain);
            float f6 = (0.0f - f1) / 2.0f;
            float f7 = f6 + f1;
            float f8 = 0.0f - f1 / 2.0f;
            float f9 = f8 + f1;
            float f10 = -0.5f;
            GL11.glTranslatef((float)((float)(-(i * 2 - 1)) * 0.24f), (float)-0.3f, (float)0.0f);
            GL11.glRotatef((float)((float)(i * 2 - 1) * 10.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            tessellator.startDrawingQuads();
            tessellator.addVertexWithUV(f6, f8, f10, f3, f5);
            tessellator.addVertexWithUV(f7, f8, f10, f2, f5);
            tessellator.addVertexWithUV(f7, f9, f10, f2, f4);
            tessellator.addVertexWithUV(f6, f9, f10, f3, f4);
            tessellator.draw();
            GL11.glPopMatrix();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    public void updateEquippedItem() {
        float f;
        float f1;
        float f2;
        boolean flag;
        ItemStack itemstack;
        this.prevEquippedProgress = this.equippedProgress;
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        ItemStack itemstack1 = itemstack = entityplayersp.inventory.getCurrentItem();
        boolean bl = flag = this.field_20099_f == entityplayersp.inventory.currentItem && itemstack1 == this.itemToRender;
        if (this.itemToRender == null && itemstack1 == null) {
            flag = true;
        }
        if (itemstack1 != null && this.itemToRender != null && itemstack1 != this.itemToRender && itemstack1.itemID == this.itemToRender.itemID && itemstack1.getMetadata() == this.itemToRender.getMetadata()) {
            this.itemToRender = itemstack1;
            flag = true;
        }
        if ((f2 = (f1 = flag ? 1.0f : 0.0f) - this.equippedProgress) < -(f = 0.4f)) {
            f2 = -f;
        }
        if (f2 > f) {
            f2 = f;
        }
        this.equippedProgress += f2;
        if (this.equippedProgress < 0.1f) {
            this.itemToRender = itemstack1;
            this.field_20099_f = entityplayersp.inventory.currentItem;
        }
    }

    public void func_9449_b() {
        this.equippedProgress = 0.0f;
    }

    public void func_9450_c() {
        this.equippedProgress = 0.0f;
    }
}

