/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.RenderEngine;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.client.render.tileentity.TileEntityRendererFlag;
import net.minecraft.client.render.tileentity.TileEntityRendererMobSpawner;
import net.minecraft.client.render.tileentity.TileEntityRendererPiston;
import net.minecraft.client.render.tileentity.TileEntityRendererSign;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.block.entity.TileEntityMobSpawner;
import net.minecraft.core.block.entity.TileEntityPiston;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public class TileEntityRenderDispatcher {
    private final Map<Class<?>, TileEntityRenderer<?>> renderers = new HashMap();
    public static TileEntityRenderDispatcher instance = new TileEntityRenderDispatcher();
    private FontRenderer fontRenderer;
    public static double renderPosX;
    public static double renderPosY;
    public static double renderPosZ;
    public RenderEngine renderEngine;
    public World worldObj;
    public ICamera camera;
    public float viewLerpYaw;
    public float viewLerpPitch;
    public double viewLerpPosX;
    public double viewLerpPosY;
    public double viewLerpPosZ;

    private TileEntityRenderDispatcher() {
        this.renderers.put(TileEntitySign.class, new TileEntityRendererSign());
        this.renderers.put(TileEntityFlag.class, new TileEntityRendererFlag());
        this.renderers.put(TileEntityMobSpawner.class, new TileEntityRendererMobSpawner());
        this.renderers.put(TileEntityPiston.class, new TileEntityRendererPiston());
        for (TileEntityRenderer<?> tileEntityRenderer : this.renderers.values()) {
            tileEntityRenderer.setRenderDispatcher(this);
        }
    }

    public <T extends TileEntity> TileEntityRenderer<T> getRenderer(Class<? extends TileEntity> e) {
        TileEntityRenderer<Object> r = this.renderers.get(e);
        if (r == null && e != TileEntity.class) {
            r = this.getRenderer((T)((Object)e.getSuperclass()));
            this.renderers.put(e, r);
        }
        return r;
    }

    public <T extends TileEntity> TileEntityRenderer<T> getRenderer(T tileEntity) {
        if (tileEntity == null) {
            return null;
        }
        return this.getRenderer((T)((Object)tileEntity.getClass()));
    }

    public <T extends TileEntity> boolean hasRenderer(T tileEntity) {
        return this.getRenderer(tileEntity) != null;
    }

    public void cacheActiveRenderInfo(World world, RenderEngine renderEngine, FontRenderer fontRenderer, ICamera camera, float renderPartialTicks) {
        if (this.worldObj != world) {
            this.updateRendererWorldCache(world);
        }
        this.renderEngine = renderEngine;
        this.camera = camera;
        this.fontRenderer = fontRenderer;
        this.viewLerpYaw = (float)camera.getYRot(renderPartialTicks);
        this.viewLerpPitch = (float)camera.getXRot(renderPartialTicks);
        this.viewLerpPosX = (float)camera.getX(renderPartialTicks);
        this.viewLerpPosY = (float)camera.getY(renderPartialTicks);
        this.viewLerpPosZ = (float)camera.getZ(renderPartialTicks);
    }

    public <T extends TileEntity> void renderTileEntity(T tileEntity, float renderPartialTicks) {
        if (tileEntity.getDistanceFrom(this.viewLerpPosX, this.viewLerpPosY, this.viewLerpPosZ) < 4096.0) {
            float brightness = this.worldObj.getLightBrightness(tileEntity.xCoord, tileEntity.yCoord, tileEntity.zCoord);
            GL11.glColor3f((float)brightness, (float)brightness, (float)brightness);
            this.renderTileEntity(tileEntity, (double)tileEntity.xCoord - renderPosX, (double)tileEntity.yCoord - renderPosY, (double)tileEntity.zCoord - renderPosZ, renderPartialTicks);
        }
    }

    public <T extends TileEntity> void renderTileEntity(T tileEntity, double x, double y, double z, float renderPartialTicks) {
        TileEntityRenderer<T> renderer = this.getRenderer(tileEntity);
        if (renderer != null) {
            renderer.doRender(tileEntity, x, y, z, renderPartialTicks);
        }
    }

    public void updateRendererWorldCache(World world) {
        this.worldObj = world;
        for (TileEntityRenderer<?> renderer : this.renderers.values()) {
            if (renderer == null) continue;
            renderer.onWorldChanged(world);
        }
    }

    public FontRenderer getFontRenderer() {
        return this.fontRenderer;
    }
}

