/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.color;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDefault;
import net.minecraft.client.render.block.color.BlockColorGrass;
import net.minecraft.client.render.block.color.BlockColorLamp;
import net.minecraft.client.render.block.color.BlockColorLeaves;
import net.minecraft.client.render.block.color.BlockColorLeavesOak;
import net.minecraft.client.render.block.color.BlockColorPlanksPainted;
import net.minecraft.client.render.block.color.BlockColorRedstoneWire;
import net.minecraft.client.render.block.color.BlockColorTallGrass;
import net.minecraft.client.render.block.color.BlockColorWater;
import net.minecraft.client.util.dispatch.Dispatcher;
import net.minecraft.core.block.Block;

public final class BlockColorDispatcher
extends Dispatcher<Block, BlockColor> {
    private static final BlockColorDispatcher instance = new BlockColorDispatcher();
    private static final BlockColor defaultColor = new BlockColorDefault();

    public static BlockColorDispatcher getInstance() {
        return instance;
    }

    private BlockColorDispatcher() {
        this.addDispatch(Block.algae, new BlockColorGrass());
        this.addDispatch(Block.chestPlanksOakPainted, new BlockColorPlanksPainted(true));
        this.addDispatch(Block.fencegatePlanksOakPainted, new BlockColorPlanksPainted(true));
        this.addDispatch(Block.fencePlanksOakPainted, new BlockColorPlanksPainted(false));
        this.addDispatch(Block.fluidWaterStill, new BlockColorWater());
        this.addDispatch(Block.fluidWaterFlowing, new BlockColorWater());
        this.addDispatch(Block.grass, new BlockColorGrass());
        this.addDispatch(Block.lampIdle, new BlockColorLamp());
        this.addDispatch(Block.lampActive, new BlockColorLamp());
        this.addDispatch(Block.layerLeavesOak, new BlockColorLeavesOak());
        this.addDispatch(Block.leavesBirch, new BlockColorLeaves("birch"));
        this.addDispatch(Block.leavesCherry, new BlockColorLeaves("cherry"));
        this.addDispatch(Block.leavesCherryFlowering, new BlockColorLeaves("cherry"));
        this.addDispatch(Block.leavesEucalyptus, new BlockColorLeaves("eucalyptus"));
        this.addDispatch(Block.leavesOak, new BlockColorLeavesOak());
        this.addDispatch(Block.leavesPine, new BlockColorLeaves("pine"));
        this.addDispatch(Block.leavesShrub, new BlockColorLeaves("shrub"));
        this.addDispatch(Block.mossStone, new BlockColorGrass());
        this.addDispatch(Block.mossBasalt, new BlockColorGrass());
        this.addDispatch(Block.mossLimestone, new BlockColorGrass());
        this.addDispatch(Block.mossGranite, new BlockColorGrass());
        this.addDispatch(Block.planksOakPainted, new BlockColorPlanksPainted(false));
        this.addDispatch(Block.wireRedstone, new BlockColorRedstoneWire());
        this.addDispatch(Block.slabPlanksOakPainted, new BlockColorPlanksPainted(true));
        this.addDispatch(Block.stairsPlanksOakPainted, new BlockColorPlanksPainted(true));
        this.addDispatch(Block.tallgrass, new BlockColorTallGrass());
        this.addDispatch(Block.tallgrassFern, new BlockColorTallGrass());
    }

    @Override
    protected BlockColor getDefault() {
        return defaultColor;
    }
}

