/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.color;

import net.minecraft.client.render.block.color.BlockColorGrass;
import net.minecraft.client.render.colorizer.ColorizerGrass;
import net.minecraft.core.block.Block;
import net.minecraft.core.world.World;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.season.Seasons;

public class BlockColorTallGrass
extends BlockColorGrass {
    @Override
    public int getWorldColor(World world, int x, int y, int z) {
        int xBelow = x;
        int yBelow = y;
        int zBelow = z;
        long l1 = (long)x * 3129871L + (long)z * 6129781L + (long)y;
        l1 = l1 * l1 * 42317861L + l1 * 11L;
        x = (int)((long)x + (l1 >> 14 & 0x1FL));
        y = (int)((long)y + (l1 >> 19 & 0x1FL));
        z = (int)((long)z + (l1 >> 24 & 0x1FL));
        double localTemperature = world.getBlockTemperature(x, z);
        double localHumidity = world.getBlockHumidity(x, z);
        int baseGrassColor = ColorizerGrass.getGrassColor(localTemperature, localHumidity);
        if (world != null) {
            if (world.getBlockId(xBelow, yBelow - 1, zBelow) == Block.grassScorched.id || world.getBlockId(xBelow, yBelow - 1, zBelow) == Block.dirtScorched.id) {
                return 16763992;
            }
            Season season = world.seasonManager.getCurrentSeason();
            if (season != null) {
                boolean isWinter = season == Seasons.OVERWORLD_WINTER || season == Seasons.OVERWORLD_WINTER_ENDLESS;
                float progress = world.seasonManager.getSeasonProgress();
                if (isWinter) {
                    baseGrassColor = ColorizerGrass.getGrassColor(localTemperature * (double)progress, localHumidity);
                }
                baseGrassColor = season.modifyGrassColorizer(baseGrassColor, progress > 0.5f ? world.seasonManager.getNextSeason() : world.seasonManager.getPreviousSeason(), Math.abs(progress - 0.5f));
                if (isWinter) {
                    float offsetIntensity = 1.0f - Math.abs(progress * 2.0f - 1.0f);
                    float red = (float)((baseGrassColor & 0xFF0000) >> 16) / 255.0f;
                    float green = (float)((baseGrassColor & 0xFF00) >> 8) / 255.0f;
                    float blue = (float)(baseGrassColor & 0xFF) / 255.0f;
                    float gray = red * green * blue / 3.0f;
                    float grayOffset = (float)grassColorPerlin.getValue((double)x / 30.0, (double)y / 50.0, (double)z / 30.0) * offsetIntensity * 0.5f;
                    if (gray + grayOffset > 0.4f) {
                        grayOffset = 0.4f - gray;
                    }
                    if (gray + grayOffset < 0.0f) {
                        grayOffset = -gray;
                    }
                    red += grayOffset;
                    green += grayOffset;
                    blue += grayOffset;
                    if (red < 0.0f) {
                        red = 0.0f;
                    }
                    if (red > 1.0f) {
                        red = 1.0f;
                    }
                    if (green < 0.0f) {
                        green = 0.0f;
                    }
                    if (green > 1.0f) {
                        green = 1.0f;
                    }
                    if (blue < 0.0f) {
                        blue = 0.0f;
                    }
                    if (blue > 1.0f) {
                        blue = 1.0f;
                    }
                    int newRed = (int)(red * 255.0f) & 0xFF;
                    int newGreen = (int)(green * 255.0f) & 0xFF;
                    int newBlue = (int)(blue * 255.0f) & 0xFF;
                    baseGrassColor = newRed << 16 | newGreen << 8 | newBlue;
                }
            }
        }
        return baseGrassColor;
    }
}

