/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.camera;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.culling.CameraFrustum;
import net.minecraft.core.entity.EntityLiving;

public abstract class EntityCamera
implements ICamera {
    protected final Minecraft mc;
    private final CameraFrustum frustum;
    public final EntityLiving entity;

    public EntityCamera(Minecraft mc, EntityLiving entity) {
        this.mc = mc;
        this.entity = entity;
        this.frustum = new CameraFrustum(this);
    }

    @Override
    public boolean showPlayer() {
        return false;
    }

    @Override
    public void tick() {
    }

    @Override
    public void applyGlTransformations() {
    }

    @Override
    public double getX(float renderPartialTicks) {
        if (renderPartialTicks == 1.0f) {
            return this.entity.x;
        }
        return this.entity.xo + (this.entity.x - this.entity.xo) * (double)renderPartialTicks;
    }

    @Override
    public double getY(float renderPartialTicks) {
        if (renderPartialTicks == 1.0f) {
            return this.entity.y;
        }
        return this.entity.yo + (this.entity.y - this.entity.yo) * (double)renderPartialTicks;
    }

    @Override
    public double getZ(float renderPartialTicks) {
        if (renderPartialTicks == 1.0f) {
            return this.entity.z;
        }
        return this.entity.zo + (this.entity.z - this.entity.zo) * (double)renderPartialTicks;
    }

    @Override
    public double getXRot(float renderPartialTicks) {
        if (renderPartialTicks == 1.0f) {
            return this.entity.xRot;
        }
        return this.entity.xRotO + (this.entity.xRot - this.entity.xRotO) * renderPartialTicks;
    }

    @Override
    public double getYRot(float renderPartialTicks) {
        if (renderPartialTicks == 1.0f) {
            return this.entity.yRot;
        }
        return this.entity.yRotO + (this.entity.yRot - this.entity.yRotO) * renderPartialTicks;
    }

    @Override
    public double getFov() {
        return ((Float)this.mc.gameSettings.FoV.value).floatValue();
    }

    @Override
    public CameraFrustum getFrustum() {
        return this.frustum;
    }
}

