/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.camera;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.camera.EntityCamera;
import net.minecraft.core.HitResult;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3d;

public class EntityCameraThirdPersonRear
extends EntityCamera {
    protected float lastRenderPartialTicks = 0.0f;
    protected double lastCameraDistance = 0.0;

    public EntityCameraThirdPersonRear(Minecraft mc, EntityLiving entity) {
        super(mc, entity);
    }

    @Override
    public boolean showPlayer() {
        return true;
    }

    private double getCameraDistance(float renderPartialTicks) {
        if (renderPartialTicks == this.lastRenderPartialTicks) {
            return this.lastCameraDistance;
        }
        int numSteps = 5;
        double offset = 0.5;
        float yRot = (float)this.getYRot();
        float xRot = (float)this.getXRot();
        double x = super.getX(renderPartialTicks);
        double y = super.getY(renderPartialTicks);
        double z = super.getZ(renderPartialTicks);
        double dx = -MathHelper.sin(yRot / 180.0f * (float)Math.PI) * MathHelper.cos(xRot / 180.0f * (float)Math.PI);
        double dz = MathHelper.cos(yRot / 180.0f * (float)Math.PI) * MathHelper.cos(xRot / 180.0f * (float)Math.PI);
        double dy = -MathHelper.sin(xRot / 180.0f * (float)Math.PI);
        double cameraDistance = Vec3d.createVector(x, y, z).distanceTo(Vec3d.createVector(x - (double)numSteps * dx, y - (double)numSteps * dy, z - (double)numSteps * dz)) - offset;
        for (int i = 0; i <= numSteps; ++i) {
            HitResult hitResult = this.mc.theWorld.checkBlockCollisionBetweenPoints(Vec3d.createVector(x, y, z), Vec3d.createVector(x - (double)i * dx, y - (double)i * dy, z - (double)i * dz));
            if (hitResult == null) continue;
            double distance = hitResult.location.distanceTo(Vec3d.createVector(x, y, z)) - offset;
            if (distance < 0.0) {
                distance = 0.0;
            }
            cameraDistance = distance;
            break;
        }
        this.lastRenderPartialTicks = renderPartialTicks;
        this.lastCameraDistance = cameraDistance;
        return cameraDistance;
    }

    @Override
    public double getX(float renderPartialTicks) {
        float yRot = (float)this.getYRot(renderPartialTicks);
        float xRot = (float)this.getXRot(renderPartialTicks);
        double cameraDistance = this.getCameraDistance(renderPartialTicks);
        double dx = (double)(-MathHelper.sin(yRot / 180.0f * (float)Math.PI) * MathHelper.cos(xRot / 180.0f * (float)Math.PI)) * cameraDistance;
        return super.getX(renderPartialTicks) - dx;
    }

    @Override
    public double getY(float renderPartialTicks) {
        float xRot = (float)this.getXRot(renderPartialTicks);
        double cameraDistance = this.getCameraDistance(renderPartialTicks);
        double dy = (double)(-MathHelper.sin(xRot / 180.0f * (float)Math.PI)) * cameraDistance;
        return super.getY(renderPartialTicks) - dy;
    }

    @Override
    public double getZ(float renderPartialTicks) {
        float yRot = (float)this.getYRot(renderPartialTicks);
        float xRot = (float)this.getXRot(renderPartialTicks);
        double cameraDistance = this.getCameraDistance(renderPartialTicks);
        double dz = (double)(MathHelper.cos(yRot / 180.0f * (float)Math.PI) * MathHelper.cos(xRot / 180.0f * (float)Math.PI)) * cameraDistance;
        return super.getZ(renderPartialTicks) - dz;
    }

    @Override
    public double getYRot(float renderPartialTicks) {
        return super.getYRot(renderPartialTicks);
    }

    @Override
    public double getXRot(float renderPartialTicks) {
        return super.getXRot(renderPartialTicks);
    }
}

