/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.culling;

import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.culling.Frustum;
import net.minecraft.client.render.culling.FrustumData;
import net.minecraft.core.util.phys.AABB;

public class CameraFrustum {
    private final ICamera camera;
    private final FrustumData frustum;

    public CameraFrustum(ICamera camera) {
        this.camera = camera;
        this.frustum = Frustum.getFrustum();
    }

    public boolean cubeInFrustum(double x0, double y0, double z0, double x1, double y1, double z1, float renderPartialTicks) {
        return this.frustum.cubeInFrustum(x0 - this.camera.getX(renderPartialTicks), y0 - this.camera.getY(renderPartialTicks), z0 - this.camera.getZ(renderPartialTicks), x1 - this.camera.getX(renderPartialTicks), y1 - this.camera.getY(renderPartialTicks), z1 - this.camera.getZ(renderPartialTicks));
    }

    public boolean isVisible(AABB aabb, float renderPartialTicks) {
        return this.cubeInFrustum(aabb.minX, aabb.minY, aabb.minZ, aabb.maxX, aabb.maxY, aabb.maxZ, renderPartialTicks);
    }
}

