/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.RenderEngine;
import net.minecraft.client.render.Tessellator;
import net.minecraft.client.render.TextureFX;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.BlockModelRenderBlocks;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class ItemEntityRenderer
extends EntityRenderer<EntityItem> {
    private final RenderBlocks renderBlocks = new RenderBlocks();
    private final Random random = new Random();
    public boolean field_27004_a = true;

    public ItemEntityRenderer() {
        this.shadowSize = 0.15f;
        this.shadowOpacity = 0.75f;
    }

    @Override
    public void doRender(EntityItem entity, double x, double y, double z, float yaw, float renderPartialTicks) {
        this.doRenderItem(entity, x, y, z, yaw, renderPartialTicks);
    }

    public void doRenderItem(EntityItem entity, double d, double d1, double d2, float f, float f1) {
        this.random.setSeed(187L);
        ItemStack itemstack = entity.item;
        Item item = itemstack.getItem();
        if (item == null) {
            return;
        }
        GL11.glPushMatrix();
        float f2 = MathHelper.sin(((float)entity.age + f1) / 10.0f + entity.field_804_d) * 0.1f + 0.1f;
        float f3 = (((float)entity.age + f1) / 20.0f + entity.field_804_d) * 57.29578f;
        int renderCount = 1;
        if (entity.item.stackSize > 1) {
            renderCount = 2;
        }
        if (entity.item.stackSize > 5) {
            renderCount = 3;
        }
        if (entity.item.stackSize > 20) {
            renderCount = 4;
        }
        GL11.glTranslatef((float)((float)d), (float)((float)d1 + f2), (float)((float)d2));
        GL11.glEnable((int)32826);
        if (itemstack.itemID < Block.blocksList.length && Block.blocksList[itemstack.itemID] != null && ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Block.blocksList[itemstack.itemID])).shouldItemRender3d()) {
            GL11.glRotatef((float)f3, (float)0.0f, (float)1.0f, (float)0.0f);
            this.loadTexture("/terrain.png");
            BlockModelRenderBlocks.setRenderBlocks(this.renderBlocks);
            BlockModel model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(Block.blocksList[itemstack.itemID]);
            float itemSize = model.getItemRenderScale();
            GL11.glScalef((float)itemSize, (float)itemSize, (float)itemSize);
            for (int j = 0; j < renderCount; ++j) {
                GL11.glPushMatrix();
                if (j > 0) {
                    float f5 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / itemSize;
                    float f7 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / itemSize;
                    float f9 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / itemSize;
                    GL11.glTranslatef((float)f5, (float)f7, (float)f9);
                }
                float f4 = entity.getBrightness(f1);
                if (Minecraft.getMinecraft((Object)this).fullbright) {
                    f4 = 1.0f;
                }
                this.renderBlocks.renderBlockOnInventory(Block.blocksList[itemstack.itemID], itemstack.getMetadata(), f4);
                GL11.glPopMatrix();
            }
        } else {
            int tileWidth;
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            int i = itemstack.getIconIndex();
            if (itemstack.itemID < Block.blocksList.length) {
                this.loadTexture("/terrain.png");
                tileWidth = TextureFX.tileWidthTerrain;
            } else {
                this.loadTexture("/gui/items.png");
                tileWidth = TextureFX.tileWidthItems;
            }
            Tessellator tessellator = Tessellator.instance;
            float f6 = (float)(i % Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth + 0) / (float)(Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth);
            float f8 = (float)(i % Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth + tileWidth) / (float)(Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth);
            float f10 = (float)(i / Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth + 0) / (float)(Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth);
            float f11 = (float)(i / Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth + tileWidth) / (float)(Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth);
            float f12 = 1.0f;
            float f13 = 0.5f;
            float f14 = 0.25f;
            if (this.field_27004_a) {
                int k = Item.itemsList[itemstack.itemID].getColorFromDamage(itemstack.getMetadata());
                float f15 = (float)(k >> 16 & 0xFF) / 255.0f;
                float f17 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f19 = (float)(k & 0xFF) / 255.0f;
                float f21 = entity.getBrightness(f1);
                if (Minecraft.getMinecraft((Object)this).fullbright || entity.item.getItem().hasTag(ItemTags.renderFullbright)) {
                    f21 = 1.0f;
                }
                GL11.glColor4f((float)(f15 * f21), (float)(f17 * f21), (float)(f19 * f21), (float)1.0f);
            }
            if (((Boolean)Minecraft.getMinecraft((Object)this).gameSettings.items3D.value).booleanValue()) {
                GL11.glPushMatrix();
                GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
                GL11.glRotated((double)f3, (double)0.0, (double)1.0, (double)0.0);
                GL11.glTranslated((double)-0.5, (double)0.0, (double)(-0.05 * (double)(renderCount - 1)));
                for (int j = 0; j < renderCount; ++j) {
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)0.0, (double)0.0, (double)(0.1 * (double)j));
                    EntityRenderDispatcher.instance.itemRenderer.renderItem(entity, itemstack, false);
                    GL11.glPopMatrix();
                }
                GL11.glPopMatrix();
            } else {
                for (int l = 0; l < renderCount; ++l) {
                    GL11.glPushMatrix();
                    if (l > 0) {
                        float f16 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                        float f18 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                        float f20 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                        GL11.glTranslatef((float)f16, (float)f18, (float)f20);
                    }
                    GL11.glRotatef((float)(180.0f - this.renderDispatcher.viewLerpYaw), (float)0.0f, (float)1.0f, (float)0.0f);
                    tessellator.startDrawingQuads();
                    tessellator.setNormal(0.0f, 1.0f, 0.0f);
                    tessellator.addVertexWithUV(-0.5, -0.25, 0.0, f6, f11);
                    tessellator.addVertexWithUV(0.5, -0.25, 0.0, f8, f11);
                    tessellator.addVertexWithUV(0.5, 0.75, 0.0, f8, f10);
                    tessellator.addVertexWithUV(-0.5, 0.75, 0.0, f6, f10);
                    tessellator.draw();
                    GL11.glPopMatrix();
                }
            }
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    public void drawItemIntoGui(FontRenderer fontrenderer, RenderEngine renderengine, int i, int j, int k, int l, int i1) {
        this.drawItemIntoGui(fontrenderer, renderengine, i, j, k, l, i1, 1.0f, 1.0f);
    }

    public void drawItemIntoGui(FontRenderer fontrenderer, RenderEngine renderengine, int i, int j, int k, int l, int i1, float brightness, float alpha) {
        if (i < Block.blocksList.length && ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Block.blocksList[i])).shouldItemRender3d()) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            int j1 = i;
            renderengine.bindTexture(renderengine.getTexture("/terrain.png"));
            Block block = Block.blocksList[j1];
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(l - 2), (float)(i1 + 3), (float)-3.0f);
            GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
            GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
            GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            int l1 = Item.itemsList[i].getColorFromDamage(j);
            float f2 = (float)(l1 >> 16 & 0xFF) / 255.0f;
            float f4 = (float)(l1 >> 8 & 0xFF) / 255.0f;
            float f5 = (float)(l1 & 0xFF) / 255.0f;
            if (this.field_27004_a) {
                GL11.glColor4f((float)(f2 * brightness), (float)(f4 * brightness), (float)(f5 * brightness), (float)alpha);
            } else {
                GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
            }
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderBlocks.useInventoryTint = this.field_27004_a;
            this.renderBlocks.renderBlockOnInventory(block, j, brightness);
            this.renderBlocks.useInventoryTint = true;
            GL11.glPopMatrix();
            GL11.glDisable((int)3042);
        } else if (k >= 0) {
            int tileWidth;
            GL11.glDisable((int)2896);
            if (i < Block.blocksList.length) {
                renderengine.bindTexture(renderengine.getTexture("/terrain.png"));
                tileWidth = TextureFX.tileWidthTerrain;
            } else {
                renderengine.bindTexture(renderengine.getTexture("/gui/items.png"));
                tileWidth = TextureFX.tileWidthItems;
            }
            int k1 = Item.itemsList[i].getColorFromDamage(j);
            float f = (float)(k1 >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(k1 >> 8 & 0xFF) / 255.0f;
            float f3 = (float)(k1 & 0xFF) / 255.0f;
            if (this.field_27004_a) {
                GL11.glColor4f((float)(f * brightness), (float)(f1 * brightness), (float)(f3 * brightness), (float)alpha);
            } else {
                GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
            }
            this.renderTexturedQuad(l, i1, k % Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth, k / Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth, tileWidth, tileWidth);
            GL11.glEnable((int)2896);
        }
        GL11.glEnable((int)2884);
    }

    public void renderItemIntoGUI(FontRenderer fontrenderer, RenderEngine renderengine, ItemStack itemstack, int i, int j, float alpha) {
        if (itemstack == null) {
            return;
        }
        this.drawItemIntoGui(fontrenderer, renderengine, itemstack.itemID, itemstack.getMetadata(), itemstack.getIconIndex(), i, j, 1.0f, alpha);
    }

    public void renderItemIntoGUI(FontRenderer fontrenderer, RenderEngine renderengine, ItemStack itemstack, int i, int j, float brightness, float alpha) {
        if (itemstack == null) {
            return;
        }
        this.drawItemIntoGui(fontrenderer, renderengine, itemstack.itemID, itemstack.getMetadata(), itemstack.getIconIndex(), i, j, brightness, alpha);
    }

    public void renderItemOverlayIntoGUI(FontRenderer fontrenderer, RenderEngine renderengine, ItemStack itemstack, int i, int j, float alpha) {
        if (itemstack == null) {
            return;
        }
        if (itemstack.stackSize != 1) {
            String s = "" + itemstack.stackSize;
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            fontrenderer.drawStringWithShadow(s, i + 19 - 2 - fontrenderer.getStringWidth(s), j + 6 + 3, 0xFFFFFF);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
        if (itemstack.isItemDamaged() || itemstack.getItem().showFullDurability()) {
            int k = (int)Math.round(13.0 - (double)itemstack.getItemDamageForDisplay() * 13.0 / (double)itemstack.getMaxDamage());
            int l = (int)Math.round(255.0 - (double)itemstack.getItemDamageForDisplay() * 255.0 / (double)itemstack.getMaxDamage());
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3553);
            Tessellator tessellator = Tessellator.instance;
            int i1 = 255 - l << 16 | l << 8;
            int j1 = (255 - l) / 4 << 16 | 0x3F00;
            this.renderQuad(tessellator, i + 2, j + 13, 13, 2, 0);
            this.renderQuad(tessellator, i + 2, j + 13, 12, 1, j1);
            this.renderQuad(tessellator, i + 2, j + 13, k, 1, i1);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void renderItemOverlayIntoGUI(FontRenderer fontrenderer, RenderEngine renderengine, ItemStack itemstack, int i, int j, String override) {
        if (itemstack == null) {
            return;
        }
        if (itemstack.stackSize != 1 || override != null) {
            String s = "" + itemstack.stackSize;
            if (override != null) {
                s = override;
            }
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            fontrenderer.drawStringWithShadow(s, i + 19 - 2 - fontrenderer.getStringWidth(s), j + 6 + 3, 0xFFFFFF);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
        if (itemstack.isItemDamaged() || itemstack.getItem().showFullDurability()) {
            int k = (int)Math.round(13.0 - (double)itemstack.getItemDamageForDisplay() * 13.0 / (double)itemstack.getMaxDamage());
            int l = (int)Math.round(255.0 - (double)itemstack.getItemDamageForDisplay() * 255.0 / (double)itemstack.getMaxDamage());
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3553);
            Tessellator tessellator = Tessellator.instance;
            int i1 = 255 - l << 16 | l << 8;
            int j1 = (255 - l) / 4 << 16 | 0x3F00;
            this.renderQuad(tessellator, i + 2, j + 13, 13, 2, 0);
            this.renderQuad(tessellator, i + 2, j + 13, 12, 1, j1);
            this.renderQuad(tessellator, i + 2, j + 13, k, 1, i1);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderQuad(Tessellator tessellator, int i, int j, int k, int l, int i1) {
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(i1);
        tessellator.addVertex(i + 0, j + 0, 0.0);
        tessellator.addVertex(i + 0, j + l, 0.0);
        tessellator.addVertex(i + k, j + l, 0.0);
        tessellator.addVertex(i + k, j + 0, 0.0);
        tessellator.draw();
    }

    public void renderTexturedQuad(int x, int y, int tileX, int tileY, int tileWidth, int tileHeight) {
        float f = 0.0f;
        float f1 = 1.0f / (float)(Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth);
        float f2 = 1.0f / (float)(Global.TEXTURE_ATLAS_WIDTH_TILES * tileHeight);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x + 0, y + 16, 0.0, (float)(tileX + 0) * f1, (float)(tileY + tileHeight) * f2);
        tessellator.addVertexWithUV(x + 16, y + 16, 0.0, (float)(tileX + tileWidth) * f1, (float)(tileY + tileHeight) * f2);
        tessellator.addVertexWithUV(x + 16, y + 0, 0.0, (float)(tileX + tileWidth) * f1, (float)(tileY + 0) * f2);
        tessellator.addVertexWithUV(x + 0, y + 0, 0.0, (float)(tileX + 0) * f1, (float)(tileY + 0) * f2);
        tessellator.draw();
    }
}

