/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.Tessellator;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class LivingRenderer<T extends EntityLiving>
extends EntityRenderer<T> {
    protected ModelBase mainModel;
    protected ModelBase renderPassModel;
    protected ModelBase overlayModel;
    protected String overlayTexture;
    private Minecraft mc;

    public LivingRenderer(ModelBase modelbase, float shadowSize) {
        this.mainModel = modelbase;
        this.shadowSize = shadowSize;
        this.mc = Minecraft.getMinecraft(this);
    }

    public void setRenderPassModel(ModelBase modelbase) {
        this.renderPassModel = modelbase;
    }

    public void setOverlayModel(ModelBase modelbase, String texture) {
        this.overlayModel = modelbase;
        this.overlayTexture = texture;
    }

    public void doRenderLiving(T entity, double x, double y, double z, float yaw, float renderPartialTicks) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        this.mainModel.onGround = this.getSwingProgress(entity, renderPartialTicks);
        if (this.renderPassModel != null) {
            this.renderPassModel.onGround = this.mainModel.onGround;
        }
        if (this.overlayModel != null) {
            this.overlayModel.onGround = this.mainModel.onGround;
        }
        this.mainModel.isRiding = ((Entity)entity).isPassenger();
        if (this.renderPassModel != null) {
            this.renderPassModel.isRiding = this.mainModel.isRiding;
        }
        if (this.overlayModel != null) {
            this.overlayModel.isRiding = this.mainModel.isRiding;
        }
        try {
            int j;
            float headYawOffset = ((EntityLiving)entity).prevRenderYawOffset + (((EntityLiving)entity).renderYawOffset - ((EntityLiving)entity).prevRenderYawOffset) * renderPartialTicks;
            float headYaw = ((EntityLiving)entity).yRotO + (((EntityLiving)entity).yRot - ((EntityLiving)entity).yRotO) * renderPartialTicks;
            float headPitch = ((EntityLiving)entity).xRotO + (((EntityLiving)entity).xRot - ((EntityLiving)entity).xRotO) * renderPartialTicks;
            this.translateModel(entity, x, y, z);
            float ticksExisted = this.ticksExisted(entity, renderPartialTicks);
            this.rotateModel(entity, ticksExisted, headYawOffset, renderPartialTicks);
            float scale = 0.0625f;
            GL11.glEnable((int)32826);
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
            this.preRenderCallback(entity, renderPartialTicks);
            GL11.glTranslatef((float)0.0f, (float)(-24.0f * scale - 0.0078125f), (float)0.0f);
            float limbYaw = ((EntityLiving)entity).prevLimbYaw + (((EntityLiving)entity).limbYaw - ((EntityLiving)entity).prevLimbYaw) * renderPartialTicks;
            float limbSwing = ((EntityLiving)entity).limbSwing - ((EntityLiving)entity).limbYaw * (1.0f - renderPartialTicks);
            if (limbYaw > 1.0f) {
                limbYaw = 1.0f;
            }
            this.loadEntityTexture(entity);
            GL11.glEnable((int)3008);
            this.mainModel.setLivingAnimations((EntityLiving)entity, limbSwing, limbYaw, renderPartialTicks);
            this.mainModel.render(limbSwing, limbYaw, ticksExisted, headYaw - headYawOffset, headPitch, scale);
            if (this.overlayModel != null) {
                this.overlayModel.setLivingAnimations((EntityLiving)entity, limbSwing, limbYaw, renderPartialTicks);
                this.loadTexture(this.overlayTexture);
                this.overlayModel.render(limbSwing, limbYaw, ticksExisted, headYaw - headYawOffset, headPitch, scale);
            }
            if (this.renderPassModel != null) {
                this.renderPassModel.setLivingAnimations((EntityLiving)entity, limbSwing, limbYaw, renderPartialTicks);
            }
            for (int renderPass = 0; renderPass < 4; ++renderPass) {
                if (!this.shouldRenderPass(entity, renderPass, renderPartialTicks)) continue;
                this.renderPassModel.render(limbSwing, limbYaw, ticksExisted, headYaw - headYawOffset, headPitch, scale);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)3008);
            }
            this.renderEquippedItems(entity, renderPartialTicks);
            float f9 = ((Entity)entity).getBrightness(renderPartialTicks);
            if (Minecraft.getMinecraft((Object)this).fullbright) {
                f9 = 1.0f;
            }
            if (((j = this.getColorMultiplier(entity, f9, renderPartialTicks)) >> 24 & 0xFF) > 0 || ((EntityLiving)entity).hurtTime > 0 || ((EntityLiving)entity).deathTime > 0) {
                GL11.glDisable((int)3553);
                GL11.glDisable((int)3008);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glDepthFunc((int)514);
                if (((EntityLiving)entity).hurtTime > 0 || ((EntityLiving)entity).deathTime > 0) {
                    GL11.glColor4f((float)f9, (float)0.0f, (float)0.0f, (float)0.4f);
                    this.mainModel.render(limbSwing, limbYaw, ticksExisted, headYaw - headYawOffset, headPitch, scale);
                    if (this.overlayModel != null) {
                        this.overlayModel.render(limbSwing, limbYaw, ticksExisted, headYaw - headYawOffset, headPitch, scale);
                    }
                    for (int k = 0; k < 4; ++k) {
                        if (!this.shouldRenderPassB(entity, k, renderPartialTicks)) continue;
                        GL11.glColor4f((float)f9, (float)0.0f, (float)0.0f, (float)0.4f);
                        this.renderPassModel.render(limbSwing, limbYaw, ticksExisted, headYaw - headYawOffset, headPitch, scale);
                    }
                }
                if ((j >> 24 & 0xFF) > 0) {
                    float f10 = (float)(j >> 16 & 0xFF) / 255.0f;
                    float f11 = (float)(j >> 8 & 0xFF) / 255.0f;
                    float f12 = (float)(j & 0xFF) / 255.0f;
                    float f13 = (float)(j >> 24 & 0xFF) / 255.0f;
                    GL11.glColor4f((float)f10, (float)f11, (float)f12, (float)f13);
                    this.mainModel.render(limbSwing, limbYaw, ticksExisted, headYaw - headYawOffset, headPitch, scale);
                    if (this.overlayModel != null) {
                        this.overlayModel.render(limbSwing, limbYaw, ticksExisted, headYaw - headYawOffset, headPitch, scale);
                    }
                    for (int l = 0; l < 4; ++l) {
                        if (!this.shouldRenderPassB(entity, l, renderPartialTicks)) continue;
                        GL11.glColor4f((float)f10, (float)f11, (float)f12, (float)f13);
                        this.renderPassModel.render(limbSwing, limbYaw, ticksExisted, headYaw - headYawOffset, headPitch, scale);
                    }
                }
                GL11.glDepthFunc((int)515);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)3553);
            }
            GL11.glDisable((int)32826);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        this.passSpecialRender(entity, x, y, z);
    }

    protected void translateModel(T entity, double x, double y, double z) {
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
    }

    protected void rotateModel(T entity, float ticksExisted, float headYawOffset, float renderPartialTicks) {
        GL11.glRotatef((float)(180.0f - headYawOffset), (float)0.0f, (float)1.0f, (float)0.0f);
        if (((EntityLiving)entity).deathTime > 0) {
            float f3 = ((float)((EntityLiving)entity).deathTime + renderPartialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f3 = MathHelper.sqrt_float(f3)) > 1.0f) {
                f3 = 1.0f;
            }
            GL11.glRotatef((float)(f3 * this.getDeathMaxRotation(entity)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected float getSwingProgress(T entity, float renderPartialTicks) {
        return ((EntityLiving)entity).getSwingProgress(renderPartialTicks);
    }

    protected float ticksExisted(T entity, float renderPartialTicks) {
        return (float)((EntityLiving)entity).tickCount + renderPartialTicks;
    }

    protected void renderEquippedItems(T entity, float f) {
    }

    protected boolean shouldRenderPassB(T entity, int renderPass, float renderPartialTicks) {
        return this.shouldRenderPass(entity, renderPass, renderPartialTicks);
    }

    protected boolean shouldRenderPass(T entity, int renderPass, float renderPartialTicks) {
        return false;
    }

    protected float getDeathMaxRotation(T entity) {
        return 90.0f;
    }

    protected int getColorMultiplier(T entity, float f, float f1) {
        return 0;
    }

    protected void preRenderCallback(T entity, float f) {
    }

    protected void passSpecialRender(T entity, double d, double d1, double d2) {
        if (this.mc.canRenderEntityLabel()) {
            this.renderLivingLabel(entity, Integer.toString(((EntityLiving)entity).id), d, d1, d2, 64, false);
        } else if (!((EntityLiving)entity).nickname.isEmpty()) {
            this.renderLivingLabel(entity, ((EntityLiving)entity).getDisplayName(), d, d1, d2, 64, true);
        }
    }

    protected void renderLivingLabel(T entity, String s, double d, double d1, double d2, int maxDistance, boolean depthTest) {
        float f = (float)this.renderDispatcher.camera.distanceTo((Entity)entity);
        if (f > (float)maxDistance) {
            return;
        }
        FontRenderer fontrenderer = this.getFontRenderer();
        float f1 = 1.6f;
        float f2 = 0.026666671f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d + 0.0f), (float)((float)d1 + 2.3f), (float)((float)d2));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.renderDispatcher.viewLerpYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)this.renderDispatcher.viewLerpPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.026666671f, (float)-0.026666671f, (float)0.026666671f);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        if (!depthTest) {
            GL11.glDisable((int)2929);
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.instance;
        int byte0 = 0;
        GL11.glDisable((int)3553);
        tessellator.startDrawingQuads();
        int j = fontrenderer.getStringWidth(s) / 2;
        tessellator.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
        tessellator.addVertex(-j - 1, -1 + byte0, 0.0);
        tessellator.addVertex(-j - 1, 8 + byte0, 0.0);
        tessellator.addVertex(j + 1, 8 + byte0, 0.0);
        tessellator.addVertex(j + 1, -1 + byte0, 0.0);
        tessellator.draw();
        GL11.glEnable((int)3553);
        fontrenderer.drawString(s, -fontrenderer.getStringWidth(s) / 2, byte0, 0x20FFFFFF);
        if (!depthTest) {
            GL11.glEnable((int)2929);
        }
        GL11.glDepthMask((boolean)true);
        fontrenderer.drawString(s, -fontrenderer.getStringWidth(s) / 2, byte0, 0xFFFFFF);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    @Override
    public void doRender(T entity, double x, double y, double z, float yaw, float renderPartialTicks) {
        this.doRenderLiving(entity, x, y, z, yaw, renderPartialTicks);
    }

    public void loadEntityTexture(T entity) {
        if (!((Boolean)Minecraft.getMinecraft((Object)this).gameSettings.mobVariants.value).booleanValue()) {
            this.loadTexture(((EntityLiving)entity).getDefaultEntityTexture());
        } else {
            this.loadTexture(((EntityLiving)entity).getEntityTexture());
        }
    }
}

