/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texturepack;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.colorizer.ColorizerFoliage;
import net.minecraft.client.render.colorizer.ColorizerGrass;
import net.minecraft.client.render.colorizer.ColorizerWater;
import net.minecraft.client.render.texturepack.TexturePackBase;
import net.minecraft.client.render.texturepack.TexturePackCustom;
import net.minecraft.client.render.texturepack.TexturePackDefault;

public class TexturePackList {
    private List<TexturePackBase> availableTexturePacks = new ArrayList<TexturePackBase>();
    private final TexturePackBase defaultTexturePack = new TexturePackDefault();
    public TexturePackBase selectedTexturePack;
    private final Map<String, TexturePackBase> texturePacksById = new HashMap<String, TexturePackBase>();
    public Minecraft mc;
    private final File texturePackDir;
    private String currentTexturePack;

    public TexturePackList(Minecraft minecraft, File file) {
        this.mc = minecraft;
        this.texturePackDir = new File(file, "texturepacks");
        if (!this.texturePackDir.exists()) {
            this.texturePackDir.mkdirs();
        }
        this.currentTexturePack = (String)minecraft.gameSettings.skin.value;
        this.updateAvailableTexturePacks();
        this.selectedTexturePack.readZipFile();
    }

    public void setTexturePack(TexturePackBase newPack) {
        if (newPack != this.selectedTexturePack) {
            this.selectedTexturePack.closeTexturePackFile();
            this.currentTexturePack = newPack.texturePackFileName;
            this.selectedTexturePack = newPack;
            this.mc.gameSettings.skin.value = this.currentTexturePack;
            this.mc.gameSettings.saveOptions();
            this.selectedTexturePack.readZipFile();
            this.mc.fontRenderer = new FontRenderer(this.mc.gameSettings, "/font/default.png", this.mc.renderEngine);
            this.mc.renderEngine.refreshTextures();
            this.mc.renderGlobal.loadRenderers();
            this.mc.currentScreen.refreshFontRenderer();
            ColorizerWater.updateColorData(this.mc.renderEngine.getTextureImageData("/misc/watercolor.png"));
            ColorizerGrass.updateColorData(this.mc.renderEngine.getTextureImageData("/misc/grasscolor.png"));
            ColorizerFoliage.updateColorData(this.mc.renderEngine.getTextureImageData("/misc/foliagecolor.png"));
        }
    }

    public void updateAvailableTexturePacks() {
        File[] filesInDir;
        ArrayList<TexturePackBase> arraylist = new ArrayList<TexturePackBase>();
        this.selectedTexturePack = null;
        arraylist.add(this.defaultTexturePack);
        if (this.texturePackDir.exists() && this.texturePackDir.isDirectory() && (filesInDir = this.texturePackDir.listFiles()) != null) {
            for (File file : filesInDir) {
                if (file.isFile() && !file.getName().toLowerCase().endsWith(".zip")) continue;
                String s = file.getName() + ":" + file.length() + ":" + file.lastModified();
                try {
                    TexturePackBase pack;
                    if (!this.texturePacksById.containsKey(s)) {
                        pack = new TexturePackCustom(file);
                        ((TexturePackCustom)pack).packId = s;
                        this.texturePacksById.put(s, pack);
                        ((TexturePackCustom)pack).readTexturePackInfo(this.mc);
                    }
                    pack = this.texturePacksById.get(s);
                    if (pack.texturePackFileName.equals(this.currentTexturePack)) {
                        this.selectedTexturePack = pack;
                    }
                    arraylist.add(pack);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.selectedTexturePack == null) {
            this.selectedTexturePack = this.defaultTexturePack;
        }
        this.availableTexturePacks.removeAll(arraylist);
        for (TexturePackBase texturepackbase : this.availableTexturePacks) {
            texturepackbase.disposeOfTexturePack(this.mc);
            this.texturePacksById.remove(texturepackbase.packId);
        }
        this.availableTexturePacks = arraylist;
    }

    public List<TexturePackBase> availableTexturePacks() {
        return new ArrayList<TexturePackBase>(this.availableTexturePacks);
    }

    public TexturePackBase getDefaultTexturePack() {
        return this.defaultTexturePack;
    }
}

