/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.achievement.stat;

import com.b100.json.JsonParser;
import com.b100.json.element.JsonArray;
import com.b100.json.element.JsonElement;
import com.b100.json.element.JsonEntry;
import com.b100.json.element.JsonObject;
import com.b100.utils.FileUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.MD5String;
import net.minecraft.core.achievement.Achievement;
import net.minecraft.core.achievement.stat.StatBase;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.achievement.stat.StatsSyncher;
import net.minecraft.core.player.Session;

public class StatFileWriter {
    private Map<StatBase, Integer> statMap1 = new HashMap<StatBase, Integer>();
    private Map<StatBase, Integer> statMap2 = new HashMap<StatBase, Integer>();
    private boolean boolean1 = false;
    private StatsSyncher statsSyncher;

    public StatFileWriter(Session session, File minecraftFolder) {
        File statsFolder = new File(minecraftFolder, "stats");
        FileUtils.createFolder(statsFolder);
        StatFileWriter.relocateStatFiles(minecraftFolder, statsFolder);
        this.statsSyncher = new StatsSyncher(session, this, statsFolder);
    }

    public void writeStat(StatBase statbase, int i) {
        this.writeStatToMap(this.statMap2, statbase, i);
        this.writeStatToMap(this.statMap1, statbase, i);
        this.boolean1 = true;
    }

    private void writeStatToMap(Map<StatBase, Integer> map, StatBase statbase, int i) {
        Integer integer = map.get(statbase);
        int j = integer != null ? integer : 0;
        map.put(statbase, j + i);
    }

    public Map<StatBase, Integer> cloneMap() {
        return new HashMap<StatBase, Integer>(this.statMap2);
    }

    public void func_27179_a(Map map) {
        if (map == null) {
            return;
        }
        this.boolean1 = true;
        for (StatBase statbase : map.keySet()) {
            this.writeStatToMap(this.statMap2, statbase, (Integer)map.get(statbase));
            this.writeStatToMap(this.statMap1, statbase, (Integer)map.get(statbase));
        }
    }

    public void func_27180_b(Map map) {
        if (map == null) {
            return;
        }
        for (StatBase statbase : map.keySet()) {
            Integer integer = this.statMap2.get(statbase);
            int i = integer != null ? integer : 0;
            this.statMap1.put(statbase, (Integer)map.get(statbase) + i);
        }
    }

    public void func_27187_c(Map map) {
        if (map == null) {
            return;
        }
        this.boolean1 = true;
        for (StatBase statbase : map.keySet()) {
            this.writeStatToMap(this.statMap2, statbase, (Integer)map.get(statbase));
        }
    }

    public static Map func_27177_a(String s) {
        HashMap<StatBase, Integer> map = new HashMap<StatBase, Integer>();
        try {
            StringBuilder builder = new StringBuilder();
            JsonParser jsonParser = new JsonParser();
            JsonObject rootObject = jsonParser.parseString(s);
            JsonArray array = rootObject.getArray("stats-change");
            for (JsonElement element : array) {
                JsonObject object = element.getAsObject();
                JsonEntry entry = object.entryList().get(0);
                int i = Integer.parseInt(entry.name);
                int j = entry.value.getAsNumber().getInteger();
                StatBase stat = StatList.getStat(i);
                if (stat == null) {
                    System.out.println(i + " is not a valid stat");
                    continue;
                }
                builder.append(StatList.getStat((int)i).statGuid).append(",");
                builder.append(j).append(",");
                map.put(stat, j);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static String getStatFileContentString(String username, String localString, Map map) {
        StringBuilder string1 = new StringBuilder();
        StringBuilder string2 = new StringBuilder();
        boolean flag = true;
        string1.append("{\r\n");
        if (username != null && localString != null) {
            string1.append("  \"user\":{\r\n");
            string1.append("    \"name\":\"").append(username).append("\",\r\n");
            string1.append("    \"sessionid\":\"").append(localString).append("\"\r\n");
            string1.append("  },\r\n");
        }
        string1.append("  \"stats-change\":[");
        for (StatBase statbase : map.keySet()) {
            if (!flag) {
                string1.append("},");
            } else {
                flag = false;
            }
            string1.append("\r\n    {\"").append(statbase.statId).append("\":").append(map.get(statbase));
            string2.append(statbase.statGuid).append(",");
            string2.append(map.get(statbase)).append(",");
        }
        if (!flag) {
            string1.append("}");
        }
        MD5String md5string = new MD5String(localString);
        string1.append("\r\n  ],\r\n");
        string1.append("  \"checksum\":\"").append(md5string.getString(string2.toString())).append("\"\r\n");
        string1.append("}");
        return string1.toString();
    }

    public boolean hasAchievementUnlocked(Achievement achievement) {
        return this.statMap1.containsKey(achievement);
    }

    public boolean func_27181_b(Achievement achievement) {
        return achievement.parent == null || this.hasAchievementUnlocked(achievement.parent);
    }

    public int readStat(StatBase statbase) {
        Integer integer = this.statMap1.get(statbase);
        return integer != null ? integer : 0;
    }

    public void func_27175_b() {
    }

    public void syncStats() {
        this.statsSyncher.syncStatsFileWithMap(this.cloneMap());
    }

    public void func_27178_d() {
        if (this.boolean1 && this.statsSyncher.func_27420_b()) {
            this.statsSyncher.func_27424_a(this.cloneMap());
        }
        this.statsSyncher.func_27425_c();
    }

    public static void relocateStatFiles(File minecraftFolder, File statsFolder) {
        File[] files = minecraftFolder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file3;
            File file = files[i];
            if (!file.getName().startsWith("stats_") || !file.getName().endsWith(".dat") || (file3 = new File(statsFolder, file.getName())).exists()) continue;
            System.out.println("Relocating " + file.getName());
            file.renameTo(file3);
        }
    }
}

