/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.List;
import java.util.Random;
import net.minecraft.core.block.BlockRail;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.vehicle.EntityMinecart;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockDetectorRail
extends BlockRail {
    public BlockDetectorRail(String key, int id) {
        super(key, id, true);
        this.setTickOnLoad(true);
    }

    @Override
    public int tickRate() {
        return 20;
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (world.isClientSide) {
            return;
        }
        int l = world.getBlockMetadata(x, y, z);
        if ((l & 8) != 0) {
            return;
        }
        this.setStateIfMinecartInteractsWithRail(world, x, y, z, l);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.isClientSide) {
            return;
        }
        int l = world.getBlockMetadata(x, y, z);
        if ((l & 8) == 0) {
            return;
        }
        this.setStateIfMinecartInteractsWithRail(world, x, y, z, l);
    }

    @Override
    public boolean isPoweringTo(WorldSource blockAccess, int x, int y, int z, int side) {
        return (blockAccess.getBlockMetadata(x, y, z) & 8) != 0;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int x, int y, int z, int side) {
        if ((world.getBlockMetadata(x, y, z) & 8) == 0) {
            return false;
        }
        return side == 1;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int j) {
        return this.atlasIndices[side.getId()];
    }

    private void setStateIfMinecartInteractsWithRail(World world, int i, int j, int k, int l) {
        boolean flag = (l & 8) != 0;
        boolean flag1 = false;
        float f = 0.125f;
        List<Entity> list = world.getEntitiesWithinAABB(EntityMinecart.class, AABB.getBoundingBoxFromPool((float)i + f, j, (float)k + f, (float)(i + 1) - f, (double)j + 0.25, (float)(k + 1) - f));
        if (list.size() > 0) {
            flag1 = true;
        }
        if (flag1 && !flag) {
            world.setBlockMetadataWithNotify(i, j, k, l | 8);
            world.notifyBlocksOfNeighborChange(i, j, k, this.id);
            world.notifyBlocksOfNeighborChange(i, j - 1, k, this.id);
            world.markBlocksDirty(i, j, k, i, j, k);
        }
        if (!flag1 && flag) {
            world.setBlockMetadataWithNotify(i, j, k, l & 7);
            world.notifyBlocksOfNeighborChange(i, j, k, this.id);
            world.notifyBlocksOfNeighborChange(i, j - 1, k, this.id);
            world.markBlocksDirty(i, j, k, i, j, k);
        }
        if (flag1) {
            world.scheduleBlockUpdate(i, j, k, this.id, this.tickRate());
        }
    }
}

