/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundType;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public abstract class BlockFluid
extends Block {
    public BlockFluid(String key, int id, Material material) {
        super(key, id, material);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.setTickOnLoad(true);
    }

    public static float getPercentAir(int meta) {
        if (meta >= 8) {
            meta = 0;
        }
        return (float)(meta + 1) / 8.0f;
    }

    protected int getFlowDecay(World world, int x, int y, int z) {
        if (world.getBlockMaterial(x, y, z) != this.blockMaterial) {
            return -1;
        }
        return world.getBlockMetadata(x, y, z);
    }

    protected int getEffectiveFlowDecay(WorldSource blockAccess, int x, int y, int z) {
        if (blockAccess.getBlockMaterial(x, y, z) != this.blockMaterial) {
            return -1;
        }
        int meta = blockAccess.getBlockMetadata(x, y, z);
        if (meta >= 8) {
            meta = 0;
        }
        return meta;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean canCollideCheck(int meta, boolean shouldCollideWithFluids) {
        return shouldCollideWithFluids && meta == 0;
    }

    @Override
    public boolean getIsBlockSolid(WorldSource blockAccess, int x, int y, int z, Side side) {
        Material material = blockAccess.getBlockMaterial(x, y, z);
        if (material == this.blockMaterial) {
            return false;
        }
        if (material == Material.ice) {
            return false;
        }
        if (side == Side.TOP) {
            return true;
        }
        return super.getIsBlockSolid(blockAccess, x, y, z, side);
    }

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, int x, int y, int z, int side) {
        Material material = blockAccess.getBlockMaterial(x, y, z);
        if (material == this.blockMaterial) {
            return false;
        }
        if (material == Material.ice) {
            return true;
        }
        if (side == Side.TOP.getId()) {
            return true;
        }
        return super.shouldSideBeRendered(blockAccess, x, y, z, side);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    private Vec3d getFlowVector(WorldSource blockAccess, int x, int y, int z) {
        Vec3d flowVec = Vec3d.createVector(0.0, 0.0, 0.0);
        int l = this.getEffectiveFlowDecay(blockAccess, x, y, z);
        for (int i1 = 0; i1 < 4; ++i1) {
            int i2;
            int j1 = x;
            int k1 = y;
            int l1 = z;
            if (i1 == 0) {
                --j1;
            }
            if (i1 == 1) {
                --l1;
            }
            if (i1 == 2) {
                ++j1;
            }
            if (i1 == 3) {
                ++l1;
            }
            if ((i2 = this.getEffectiveFlowDecay(blockAccess, j1, k1, l1)) < 0) {
                if (blockAccess.getBlockMaterial(j1, k1, l1).blocksMotion() || (i2 = this.getEffectiveFlowDecay(blockAccess, j1, k1 - 1, l1)) < 0) continue;
                int j2 = i2 - (l - 8);
                flowVec = flowVec.addVector((j1 - x) * j2, (k1 - y) * j2, (l1 - z) * j2);
                continue;
            }
            if (i2 < 0) continue;
            int k2 = i2 - l;
            flowVec = flowVec.addVector((j1 - x) * k2, (k1 - y) * k2, (l1 - z) * k2);
        }
        flowVec = flowVec.normalize();
        return flowVec;
    }

    @Override
    public void velocityToAddToEntity(World world, int x, int y, int z, Entity entity, Vec3d entityVelocity) {
        if (entity.noPhysics) {
            return;
        }
        Vec3d flowVector = this.getFlowVector(world, x, y, z);
        entityVelocity.xCoord += flowVector.xCoord;
        entityVelocity.yCoord += flowVector.yCoord;
        entityVelocity.zCoord += flowVector.zCoord;
    }

    @Override
    public int tickRate() {
        if (this.blockMaterial == Material.water) {
            return 5;
        }
        return this.blockMaterial != Material.lava ? 0 : 30;
    }

    @Override
    public float getBlockBrightness(WorldSource blockAccess, int x, int y, int z) {
        float f = blockAccess.getLightBrightness(x, y, z);
        float f1 = blockAccess.getLightBrightness(x, y + 1, z);
        return Math.max(f, f1);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        super.updateTick(world, x, y, z, rand);
    }

    @Override
    public int getRenderBlockPass() {
        return this.blockMaterial != Material.water ? 0 : 1;
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        int l;
        if (this.blockMaterial == Material.water && rand.nextInt(64) == 0 && (l = world.getBlockMetadata(x, y, z)) > 0 && l < 8) {
            world.playSoundEffect(SoundType.WORLD_SOUNDS, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, "liquid.water", rand.nextFloat() * 0.25f + 0.75f, rand.nextFloat() * 1.0f + 0.5f);
        }
        if (this.blockMaterial == Material.lava && world.getBlockMaterial(x, y + 1, z) == Material.air && !world.isBlockOpaqueCube(x, y + 1, z) && rand.nextInt(100) == 0) {
            double d = (float)x + rand.nextFloat();
            double d1 = (double)y + this.maxY;
            double d2 = (float)z + rand.nextFloat();
            world.spawnParticle("lava", d, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static double func_293_a(WorldSource blockAccess, int x, int y, int z, Material material) {
        Vec3d vec3d = null;
        if (material == Material.water) {
            vec3d = ((BlockFluid)Block.fluidWaterFlowing).getFlowVector(blockAccess, x, y, z);
        }
        if (material == Material.lava) {
            vec3d = ((BlockFluid)Block.fluidLavaFlowing).getFlowVector(blockAccess, x, y, z);
        }
        if (vec3d.xCoord == 0.0 && vec3d.zCoord == 0.0) {
            return -1000.0;
        }
        return Math.atan2(vec3d.zCoord, vec3d.xCoord) - 1.5707963267948966;
    }

    @Override
    public void onBlockAdded(World world, int x, int y, int z) {
        this.checkForHarden(world, x, y, z);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        this.checkForHarden(world, x, y, z);
    }

    private void checkForHarden(World world, int x, int y, int z) {
        int meta;
        boolean flag;
        if (world.getBlockId(x, y, z) != this.id) {
            return;
        }
        if (this.blockMaterial == Material.lava) {
            flag = false;
            if (flag || world.getBlockMaterial(x, y, z - 1) == Material.water) {
                flag = true;
            }
            if (flag || world.getBlockMaterial(x, y, z + 1) == Material.water) {
                flag = true;
            }
            if (flag || world.getBlockMaterial(x - 1, y, z) == Material.water) {
                flag = true;
            }
            if (flag || world.getBlockMaterial(x + 1, y, z) == Material.water) {
                flag = true;
            }
            if (flag || world.getBlockMaterial(x, y + 1, z) == Material.water) {
                flag = true;
            }
            if (flag) {
                meta = world.getBlockMetadata(x, y, z);
                if (meta == 0) {
                    world.setBlockWithNotify(x, y, z, Block.obsidian.id);
                } else if (meta <= 2) {
                    world.setBlockWithNotify(x, y, z, Block.cobbleGranite.id);
                } else if (meta <= 4) {
                    world.setBlockWithNotify(x, y, z, Block.cobbleStone.id);
                } else {
                    world.setBlockWithNotify(x, y, z, Block.cobbleBasalt.id);
                }
                this.triggerLavaMixEffects(world, x, y, z);
            }
        }
        if (this.blockMaterial == Material.water) {
            flag = false;
            if (flag || world.getBlockMaterial(x, y, z - 1) == Material.lava) {
                flag = true;
            }
            if (flag || world.getBlockMaterial(x, y, z + 1) == Material.lava) {
                flag = true;
            }
            if (flag || world.getBlockMaterial(x - 1, y, z) == Material.lava) {
                flag = true;
            }
            if (flag || world.getBlockMaterial(x + 1, y, z) == Material.lava) {
                flag = true;
            }
            if (flag || world.getBlockMaterial(x, y + 1, z) == Material.lava) {
                flag = true;
            }
            if (flag && (meta = world.getBlockMetadata(x, y, z)) == 0) {
                world.setBlockWithNotify(x, y, z, Block.cobbleLimestone.id);
                this.triggerLavaMixEffects(world, x, y, z);
            }
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        return null;
    }

    protected void triggerLavaMixEffects(World world, int x, int y, int z) {
        world.playSoundEffect(SoundType.WORLD_SOUNDS, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
        for (int i = 0; i < 8; ++i) {
            world.spawnParticle("largesmoke", (double)x + Math.random(), (double)y + 1.2, (double)z + Math.random(), 0.0, 0.0, 0.0);
        }
    }
}

