/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.noise.ImprovedNoise;

public class BlockGrass
extends Block {
    private static ImprovedNoise grassColorPerlin = new ImprovedNoise(new Random(0L));

    public BlockGrass(String key, int id, Material material) {
        super(key, id, material);
        this.setTickOnLoad(true);
    }

    @Override
    public int getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        Material material = blockAccess.getBlockMaterial(x, y + 1, z);
        if ((material == Material.topSnow || material == Material.snow) && side.getAxis() != Axis.Y) {
            return BlockGrass.texCoordToIndex(4, 4);
        }
        return super.getBlockTexture(blockAccess, x, y, z, side);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.isClientSide) {
            return;
        }
        if (world.getBlockLightValue(x, y + 1, z) < 4 && Block.lightOpacity[world.getBlockId(x, y + 1, z)] > 2) {
            if (rand.nextInt(4) != 0) {
                return;
            }
            world.setBlockWithNotify(x, y, z, Block.dirt.id);
        } else if (world.getBlockLightValue(x, y + 1, z) >= 9) {
            int l = x + rand.nextInt(3) - 1;
            int i1 = y + rand.nextInt(5) - 3;
            int j1 = z + rand.nextInt(3) - 1;
            int k1 = world.getBlockId(l, i1 + 1, j1);
            if (world.getBlockId(l, i1, j1) == Block.dirt.id && world.getBlockLightValue(l, i1 + 1, j1) >= 4 && Block.lightOpacity[k1] <= 2) {
                world.setBlockWithNotify(l, i1, j1, this.id);
            }
            if (world.getBlockId(x, y + 1, z) == 0 && world.seasonManager.getCurrentSeason() != null && world.seasonManager.getCurrentSeason().growFlowers && rand.nextInt(256) == 0) {
                int idToSpawn = 0;
                int r = rand.nextInt(400);
                idToSpawn = r < 26 ? Block.flowerRed.id : (r < 41 ? Block.flowerYellow.id : (rand.nextInt(8) == 0 ? Block.tallgrassFern.id : Block.tallgrass.id));
                world.setBlockWithNotify(x, y + 1, z, idToSpawn);
            }
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        switch (dropCause) {
            case SILK_TOUCH: 
            case PICK_BLOCK: {
                return new ItemStack[]{new ItemStack(this)};
            }
        }
        return new ItemStack[]{new ItemStack(Block.dirt)};
    }
}

