/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.BlockLeavesCherry;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import net.minecraft.core.world.season.Seasons;

public class BlockLeavesCherryFlowering
extends BlockLeavesCherry {
    public BlockLeavesCherryFlowering(String key, int id) {
        super(key, id);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        if (dropCause == EnumDropCause.PICK_BLOCK || dropCause == EnumDropCause.SILK_TOUCH) {
            return new ItemStack[]{new ItemStack(this)};
        }
        if (meta != 1) {
            return null;
        }
        return new ItemStack[]{new ItemStack(Item.cherry, world.rand.nextInt(2) + 1)};
    }

    @Override
    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        this.blockActivated(world, x, y, z, player);
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        if (world.getBlockMetadata(x, y, z) == 1) {
            world.playSoundAtEntity(player, "random.pop", 0.2f, 0.5f);
            if (!world.isClientSide) {
                this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null);
            }
            world.setBlockMetadataWithNotify(x, y, z, 0);
            world.scheduleBlockUpdate(x, y, z, BlockLeavesCherryFlowering.leavesCherryFlowering.id, this.tickRate());
            return true;
        }
        return super.blockActivated(world, x, y, z, player);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        super.updateTick(world, x, y, z, rand);
        int metadata = world.getBlockMetadata(x, y, z);
        if (world.seasonManager.getCurrentSeason() == Seasons.OVERWORLD_SPRING) {
            if (rand.nextInt(20) == 0 && metadata == 0) {
                world.setBlockMetadataWithNotify(x, y, z, 1);
                world.scheduleBlockUpdate(x, y, z, BlockLeavesCherryFlowering.leavesCherryFlowering.id, this.tickRate());
            }
        } else if ((metadata & 1) == 1) {
            world.setBlockMetadataWithNotify(x, y, z, 0);
            world.scheduleBlockUpdate(x, y, z, BlockLeavesCherryFlowering.leavesCherryFlowering.id, this.tickRate());
        }
    }
}

