/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLayerLeaves;
import net.minecraft.core.block.BlockLeavesBase;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.world.World;
import net.minecraft.core.world.wind.WindManager;

public class BlockLeavesOak
extends BlockLeavesBase {
    public BlockLeavesOak(String key, int id) {
        super(key, id, Material.leaves, false);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        super.updateTick(world, x, y, z, rand);
        if (rand.nextInt(128) == 0 && world.seasonManager.getCurrentSeason() != null && world.seasonManager.getCurrentSeason().hasFallingLeaves) {
            int id;
            for (int q = -1; q > -16 && (id = world.getBlockId(x, y + q, z)) == 0; --q) {
                if (Block.layerLeavesOak.canPlaceBlockAt(world, x, y + q, z) && Block.blocksList[world.getBlockId((int)x, (int)(y + q - 1), (int)z)].blockMaterial.blocksMotion()) {
                    world.setBlockWithNotify(x, y + q, z, Block.layerLeavesOak.id);
                    break;
                }
                if (world.getBlockId(x, y + q, z) != Block.layerLeavesOak.id) continue;
                ((BlockLayerLeaves)Block.layerLeavesOak).accumulate(world, x, y + q, z);
                break;
            }
        }
    }

    @Override
    protected Block getSapling() {
        return Block.saplingOak;
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        WindManager wind;
        float windIntensity;
        if (world.seasonManager.getCurrentSeason() != null && world.seasonManager.getCurrentSeason().hasFallingLeaves && rand.nextInt((int)(40.0f + 200.0f * (1.0f - (windIntensity = (wind = world.getWorldType().getWindManager()).getWindIntensity(world, x, y, z))))) == 0) {
            world.spawnParticle("fallingleaf", x, (float)y - 0.1f, z, 0.0, 0.0, 0.0);
        }
    }
}

