/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.sound.SoundType;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockLever
extends Block {
    public BlockLever(String key, int id) {
        super(key, id, Material.decoration);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, int side) {
        if (side == 1 && world.canPlaceOnSurfaceOfBlock(x, y - 1, z)) {
            return true;
        }
        if (side == 2 && world.isBlockNormalCube(x, y, z + 1)) {
            return true;
        }
        if (side == 3 && world.isBlockNormalCube(x, y, z - 1)) {
            return true;
        }
        if (side == 4 && world.isBlockNormalCube(x + 1, y, z)) {
            return true;
        }
        return side == 5 && world.isBlockNormalCube(x - 1, y, z);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        if (world.isBlockNormalCube(x - 1, y, z)) {
            return true;
        }
        if (world.isBlockNormalCube(x + 1, y, z)) {
            return true;
        }
        if (world.isBlockNormalCube(x, y, z - 1)) {
            return true;
        }
        if (world.isBlockNormalCube(x, y, z + 1)) {
            return true;
        }
        return world.canPlaceOnSurfaceOfBlock(x, y - 1, z);
    }

    @Override
    public void onBlockPlaced(World world, int x, int y, int z, Side side, EntityLiving entity, double sideHeight) {
        int l = side.getId();
        int i1 = world.getBlockMetadata(x, y, z);
        int j1 = i1 & 8;
        i1 &= 7;
        i1 = -1;
        if (l == 1 && world.canPlaceOnSurfaceOfBlock(x, y - 1, z)) {
            i1 = 5 + (entity.getHorizontalPlacementDirection(side).getAxis() == Axis.Z ? 1 : 0);
        }
        if (l == 2 && world.isBlockNormalCube(x, y, z + 1)) {
            i1 = 4;
        }
        if (l == 3 && world.isBlockNormalCube(x, y, z - 1)) {
            i1 = 3;
        }
        if (l == 4 && world.isBlockNormalCube(x + 1, y, z)) {
            i1 = 2;
        }
        if (l == 5 && world.isBlockNormalCube(x - 1, y, z)) {
            i1 = 1;
        }
        if (i1 == -1) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null);
            world.setBlockWithNotify(x, y, z, 0);
        } else {
            world.setBlockMetadataWithNotify(x, y, z, i1 + j1);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (this.checkIfAttachedToBlock(world, x, y, z)) {
            int i1 = world.getBlockMetadata(x, y, z) & 7;
            boolean flag = false;
            if (!world.isBlockNormalCube(x - 1, y, z) && i1 == 1) {
                flag = true;
            }
            if (!world.isBlockNormalCube(x + 1, y, z) && i1 == 2) {
                flag = true;
            }
            if (!world.isBlockNormalCube(x, y, z - 1) && i1 == 3) {
                flag = true;
            }
            if (!world.isBlockNormalCube(x, y, z + 1) && i1 == 4) {
                flag = true;
            }
            if (!world.canPlaceOnSurfaceOfBlock(x, y - 1, z) && i1 == 5) {
                flag = true;
            }
            if (!world.canPlaceOnSurfaceOfBlock(x, y - 1, z) && i1 == 6) {
                flag = true;
            }
            if (flag) {
                this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null);
                world.setBlockWithNotify(x, y, z, 0);
            }
        }
    }

    private boolean checkIfAttachedToBlock(World world, int i, int j, int k) {
        if (!this.canPlaceBlockAt(world, i, j, k)) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, i, j, k, world.getBlockMetadata(i, j, k), null);
            world.setBlockWithNotify(i, j, k, 0);
            return false;
        }
        return true;
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z) & 7;
        float f = 0.1875f;
        if (l == 1) {
            this.setBlockBounds(0.0f, 0.2f, 0.5f - f, f * 2.0f, 0.8f, 0.5f + f);
        } else if (l == 2) {
            this.setBlockBounds(1.0f - f * 2.0f, 0.2f, 0.5f - f, 1.0f, 0.8f, 0.5f + f);
        } else if (l == 3) {
            this.setBlockBounds(0.5f - f, 0.2f, 0.0f, 0.5f + f, 0.8f, f * 2.0f);
        } else if (l == 4) {
            this.setBlockBounds(0.5f - f, 0.2f, 1.0f - f * 2.0f, 0.5f + f, 0.8f, 1.0f);
        } else {
            float f1 = 0.25f;
            this.setBlockBounds(0.5f - f1, 0.0f, 0.5f - f1, 0.5f + f1, 0.6f, 0.5f + f1);
        }
    }

    @Override
    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        if (!player.isSneaking()) {
            this.blockActivated(world, x, y, z, player);
        }
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        int l = world.getBlockMetadata(x, y, z);
        int i1 = l & 7;
        int j1 = 8 - (l & 8);
        world.setBlockMetadataWithNotify(x, y, z, i1 + j1);
        world.markBlocksDirty(x, y, z, x, y, z);
        world.playSoundEffect(SoundType.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, j1 <= 0 ? 0.5f : 0.6f);
        world.notifyBlocksOfNeighborChange(x, y, z, this.id);
        if (i1 == 1) {
            world.notifyBlocksOfNeighborChange(x - 1, y, z, this.id);
        } else if (i1 == 2) {
            world.notifyBlocksOfNeighborChange(x + 1, y, z, this.id);
        } else if (i1 == 3) {
            world.notifyBlocksOfNeighborChange(x, y, z - 1, this.id);
        } else if (i1 == 4) {
            world.notifyBlocksOfNeighborChange(x, y, z + 1, this.id);
        } else {
            world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
        }
        return true;
    }

    @Override
    public void onBlockRemoval(World world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z);
        if ((l & 8) > 0) {
            world.notifyBlocksOfNeighborChange(x, y, z, this.id);
            int i1 = l & 7;
            if (i1 == 1) {
                world.notifyBlocksOfNeighborChange(x - 1, y, z, this.id);
            } else if (i1 == 2) {
                world.notifyBlocksOfNeighborChange(x + 1, y, z, this.id);
            } else if (i1 == 3) {
                world.notifyBlocksOfNeighborChange(x, y, z - 1, this.id);
            } else if (i1 == 4) {
                world.notifyBlocksOfNeighborChange(x, y, z + 1, this.id);
            } else {
                world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
            }
        }
        super.onBlockRemoval(world, x, y, z);
    }

    @Override
    public boolean isPoweringTo(WorldSource blockAccess, int x, int y, int z, int side) {
        return (blockAccess.getBlockMetadata(x, y, z) & 8) > 0;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int x, int y, int z, int side) {
        int i1 = world.getBlockMetadata(x, y, z);
        if ((i1 & 8) == 0) {
            return false;
        }
        int j1 = i1 & 7;
        if (j1 == 6 && side == 1) {
            return true;
        }
        if (j1 == 5 && side == 1) {
            return true;
        }
        if (j1 == 4 && side == 2) {
            return true;
        }
        if (j1 == 3 && side == 3) {
            return true;
        }
        if (j1 == 2 && side == 4) {
            return true;
        }
        return j1 == 1 && side == 5;
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }
}

