/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;

public class BlockOverlayPebbles
extends Block {
    public BlockOverlayPebbles(String key, int id, Material material) {
        super(key, id, material);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        Block block = world.getBlock(x, y - 1, z);
        return block != null && block.blockMaterial.isSolid();
    }

    @Override
    public boolean canBlockStay(World world, int x, int y, int z) {
        return this.canPlaceBlockAt(world, x, y, z);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int meta) {
        return BlockOverlayPebbles.texCoordToIndex(7 + meta, 18);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    @Override
    public AABB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        return AABB.getBoundingBoxFromPool(x, y, z, x + 1, (float)y + 0.0625f, z + 1);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (!world.isBlockOpaqueCube(x, y - 1, z)) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null);
            world.setBlock(x, y, z, 0);
        }
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int x, int y, int z) {
        this.minX = 0.0;
        this.minY = 0.0;
        this.minZ = 0.0;
        this.maxX = 1.0;
        this.maxY = 0.0625;
        this.maxZ = 1.0;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        if (dropCause == EnumDropCause.PICK_BLOCK) {
            return new ItemStack[]{new ItemStack(Item.ammoPebble, 1)};
        }
        return new ItemStack[]{new ItemStack(Item.ammoPebble, meta + 1)};
    }
}

