/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.ArrayList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockPistonMoving;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityPiston;
import net.minecraft.core.block.logic.PistonDirections;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.sound.SoundType;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;

public class BlockPistonBase
extends Block {
    private boolean isSticky;

    public BlockPistonBase(String key, int id, boolean flag) {
        super(key, id, Material.piston);
        this.isSticky = flag;
        this.withHardness(0.5f);
    }

    public int func_31040_i() {
        return !this.isSticky ? BlockPistonBase.texCoordToIndex(11, 6) : BlockPistonBase.texCoordToIndex(10, 6);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int j) {
        int orientation = BlockPistonBase.getOrientation(j);
        if (orientation > 5) {
            return this.atlasIndices[0];
        }
        if (side.getId() == orientation) {
            if (BlockPistonBase.isPowered(j) || this.minX > 0.0 || this.minY > 0.0 || this.minZ > 0.0 || this.maxX < 1.0 || this.maxY < 1.0 || this.maxZ < 1.0) {
                return BlockPistonBase.texCoordToIndex(14, 6);
            }
            return this.atlasIndices[0];
        }
        return side.getId() != PistonDirections.orientationMap[orientation] ? BlockPistonBase.texCoordToIndex(12, 6) : BlockPistonBase.texCoordToIndex(13, 6);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        return false;
    }

    @Override
    public void onBlockPlaced(World world, int x, int y, int z, Side side, EntityLiving entity, double sideHeight) {
        Direction placementDirection = entity.getPlacementDirection(side).getOpposite();
        world.setBlockMetadataWithNotify(x, y, z, placementDirection.getId());
        if (!world.isClientSide) {
            this.func_31043_h(world, x, y, z);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        this.func_31043_h(world, x, y, z);
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        if (!world.isClientSide && world.getBlockTileEntity(i, j, k) == null) {
            this.func_31043_h(world, i, j, k);
        }
    }

    private void func_31043_h(World world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z);
        int meta = BlockPistonBase.getOrientation(l);
        boolean flag = this.func_31041_f(world, x, y, z, meta);
        if (l == 7) {
            return;
        }
        if (flag && !BlockPistonBase.isPowered(l)) {
            if (BlockPistonBase.func_31045_h(world, x, y, z, meta)) {
                world.setBlockMetadata(x, y, z, meta | 8);
                world.playNoteAt(x, y, z, 0, meta);
            }
        } else if (!flag && BlockPistonBase.isPowered(l)) {
            world.setBlockMetadata(x, y, z, meta);
            world.playNoteAt(x, y, z, 1, meta);
        }
    }

    private boolean func_31041_f(World world, int i, int j, int k, int l) {
        if (l != 0 && world.isBlockIndirectlyProvidingPowerTo(i, j - 1, k, 0)) {
            return true;
        }
        if (l != 1 && world.isBlockIndirectlyProvidingPowerTo(i, j + 1, k, 1)) {
            return true;
        }
        if (l != 2 && world.isBlockIndirectlyProvidingPowerTo(i, j, k - 1, 2)) {
            return true;
        }
        if (l != 3 && world.isBlockIndirectlyProvidingPowerTo(i, j, k + 1, 3)) {
            return true;
        }
        if (l != 5 && world.isBlockIndirectlyProvidingPowerTo(i + 1, j, k, 5)) {
            return true;
        }
        if (l != 4 && world.isBlockIndirectlyProvidingPowerTo(i - 1, j, k, 4)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i, j, k, 0)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i, j + 2, k, 1)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i, j + 1, k - 1, 2)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i, j + 1, k + 1, 3)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i - 1, j + 1, k, 4)) {
            return true;
        }
        return world.isBlockIndirectlyProvidingPowerTo(i + 1, j + 1, k, 5);
    }

    @Override
    public void playBlock(World world, int x, int y, int z, int instrument, int pitch) {
        int meta = pitch;
        if (meta >= 6) {
            meta = 0;
        }
        if (instrument == 0) {
            if (this.tryExtend(world, x, y, z, meta)) {
                world.setBlockMetadataWithNotify(x, y, z, meta | 8);
                world.playSoundEffect(SoundType.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.out", 0.5f, world.rand.nextFloat() * 0.25f + 0.6f);
            }
        } else if (instrument == 1) {
            TileEntity tileentity = world.getBlockTileEntity(x + PistonDirections.xOffset[meta], y + PistonDirections.yOffset[meta], z + PistonDirections.zOffset[meta]);
            if (tileentity != null && tileentity instanceof TileEntityPiston) {
                ((TileEntityPiston)tileentity).clearPistonTileEntity();
            }
            world.setBlockAndMetadata(x, y, z, Block.pistonMoving.id, meta);
            world.setBlockTileEntity(x, y, z, BlockPistonMoving.func_31036_a(this.id, meta, meta, false, true));
            if (this.isSticky) {
                TileEntityPiston tileentitypiston;
                TileEntity tileentity1;
                int x1 = x + PistonDirections.xOffset[meta] * 2;
                int y1 = y + PistonDirections.yOffset[meta] * 2;
                int z1 = z + PistonDirections.zOffset[meta] * 2;
                int id1 = world.getBlockId(x1, y1, z1);
                int meta1 = world.getBlockMetadata(x1, y1, z1);
                boolean flag = false;
                if (id1 == Block.pistonMoving.id && (tileentity1 = world.getBlockTileEntity(x1, y1, z1)) != null && tileentity1 instanceof TileEntityPiston && (tileentitypiston = (TileEntityPiston)tileentity1).func_31009_d() == meta && tileentitypiston.func_31015_b()) {
                    tileentitypiston.clearPistonTileEntity();
                    id1 = tileentitypiston.getStoredBlockID();
                    meta1 = tileentitypiston.getBlockMetadata();
                    flag = true;
                }
                if (!flag && id1 > 0 && BlockPistonBase.canPushBlock(id1, world, x1, y1, z1, false) && (Block.blocksList[id1].getMobilityFlag() == 0 || id1 == Block.pistonBase.id || id1 == Block.pistonBaseSticky.id)) {
                    world.setBlockWithNotify(x1, y1, z1, 0);
                    world.setBlockAndMetadata(x += PistonDirections.xOffset[meta], y += PistonDirections.yOffset[meta], z += PistonDirections.zOffset[meta], Block.pistonMoving.id, meta1);
                    world.setBlockTileEntity(x, y, z, BlockPistonMoving.func_31036_a(id1, meta1, meta, false, false));
                } else if (!flag) {
                    world.setBlockWithNotify(x + PistonDirections.xOffset[meta], y + PistonDirections.yOffset[meta], z + PistonDirections.zOffset[meta], 0);
                }
            } else {
                world.setBlockWithNotify(x + PistonDirections.xOffset[meta], y + PistonDirections.yOffset[meta], z + PistonDirections.zOffset[meta], 0);
            }
            world.playSoundEffect(SoundType.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.in", 0.5f, world.rand.nextFloat() * 0.15f + 0.6f);
        }
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z);
        if (BlockPistonBase.isPowered(l)) {
            switch (BlockPistonBase.getOrientation(l)) {
                case 0: {
                    this.setBlockBounds(0.0f, 0.25f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 1: {
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
                    break;
                }
                case 2: {
                    this.setBlockBounds(0.0f, 0.0f, 0.25f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 3: {
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.75f);
                    break;
                }
                case 4: {
                    this.setBlockBounds(0.25f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 5: {
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.75f, 1.0f, 1.0f);
                }
            }
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void getCollidingBoundingBoxes(World world, int x, int y, int z, AABB aabb, ArrayList aabbList) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    public static int getOrientation(int i) {
        return i & 7;
    }

    public static boolean isPowered(int i) {
        return (i & 8) != 0;
    }

    private static boolean canPushBlock(int i, World world, int j, int k, int l, boolean flag) {
        TileEntity tileentity;
        if (i == Block.obsidian.id) {
            return false;
        }
        if (i == Block.pistonBase.id || i == Block.pistonBaseSticky.id) {
            if (BlockPistonBase.isPowered(world.getBlockMetadata(j, k, l))) {
                return false;
            }
        } else {
            if (Block.blocksList[i].getHardness() == -1.0f) {
                return false;
            }
            if (Block.blocksList[i].getMobilityFlag() == 2) {
                return false;
            }
            if (Block.blocksList[i].getImmovable()) {
                return false;
            }
            if (!flag && Block.blocksList[i].getMobilityFlag() == 1) {
                return false;
            }
        }
        return (tileentity = world.getBlockTileEntity(j, k, l)) == null;
    }

    private static boolean func_31045_h(World world, int x, int y, int z, int meta) {
        int x1 = x + PistonDirections.xOffset[meta % 6];
        int y1 = y + PistonDirections.yOffset[meta % 6];
        int z1 = z + PistonDirections.zOffset[meta % 6];
        for (int l1 = 0; l1 < 13; ++l1) {
            if (y1 <= 0 || y1 >= world.getHeightBlocks() - 1) {
                return false;
            }
            int i2 = world.getBlockId(x1, y1, z1);
            if (i2 == 0) break;
            if (!BlockPistonBase.canPushBlock(i2, world, x1, y1, z1, true)) {
                if (l1 == 1 && (i2 == Block.obsidian.id || i2 == Block.bedrock.id)) {
                    int x2 = x + PistonDirections.xOffset[meta % 6];
                    int y2 = y + PistonDirections.yOffset[meta % 6];
                    int z2 = z + PistonDirections.zOffset[meta % 6];
                    world.playSoundEffectForPlayer(null, 2001, x2, y2, z2, world.getBlockId(x2, y2, z2));
                    Block.blocksList[world.getBlockId(x2, y2, z2)].dropBlockWithCause(world, EnumDropCause.SILK_TOUCH, x2, y2, z2, world.getBlockMetadata(x2, y2, z2), null);
                    world.setBlockWithNotify(x2, y2, z2, 0);
                    break;
                }
                return false;
            }
            if (Block.blocksList[i2].getMobilityFlag() == 1) break;
            if (l1 == 12) {
                return false;
            }
            x1 += PistonDirections.xOffset[meta % 6];
            y1 += PistonDirections.yOffset[meta % 6];
            z1 += PistonDirections.zOffset[meta % 6];
        }
        return true;
    }

    private boolean tryExtend(World world, int x, int y, int z, int meta) {
        int i1 = x + PistonDirections.xOffset[meta % 6];
        int j1 = y + PistonDirections.yOffset[meta % 6];
        int k1 = z + PistonDirections.zOffset[meta % 6];
        for (int l1 = 0; l1 < 13; ++l1) {
            if (j1 <= 0 || j1 >= world.getHeightBlocks() - 1) {
                return false;
            }
            int j2 = world.getBlockId(i1, j1, k1);
            if (j2 == 0) break;
            if (!BlockPistonBase.canPushBlock(j2, world, i1, j1, k1, true)) {
                return false;
            }
            if (Block.blocksList[j2].getMobilityFlag() == 1) {
                Block.blocksList[j2].dropBlockWithCause(world, EnumDropCause.WORLD, i1, j1, k1, world.getBlockMetadata(i1, j1, k1), null);
                world.setBlockWithNotify(i1, j1, k1, 0);
                break;
            }
            if (l1 == 12) {
                return false;
            }
            i1 += PistonDirections.xOffset[meta % 6];
            j1 += PistonDirections.yOffset[meta % 6];
            k1 += PistonDirections.zOffset[meta % 6];
        }
        int l2 = 0;
        while (i1 != x || j1 != y || k1 != z) {
            int i2 = i1 - PistonDirections.xOffset[meta % 6];
            int k2 = j1 - PistonDirections.yOffset[meta % 6];
            l2 = k1 - PistonDirections.zOffset[meta % 6];
            int i3 = world.getBlockId(i2, k2, l2);
            int j3 = world.getBlockMetadata(i2, k2, l2);
            if (i3 == this.id && i2 == x && k2 == y && l2 == z) {
                world.setBlockAndMetadata(i1, j1, k1, Block.pistonMoving.id, meta | (this.isSticky ? 8 : 0));
                world.setBlockTileEntity(i1, j1, k1, BlockPistonMoving.func_31036_a(Block.pistonHead.id, meta | (this.isSticky ? 8 : 0), meta, true, false));
            } else {
                world.setBlockAndMetadata(i1, j1, k1, Block.pistonMoving.id, j3);
                world.setBlockTileEntity(i1, j1, k1, BlockPistonMoving.func_31036_a(i3, j3, meta, true, false));
            }
            i1 = i2;
            j1 = k2;
            k1 = l2;
        }
        return true;
    }
}

