/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.ArrayList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockPistonBase;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.logic.PistonDirections;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;

public class BlockPistonHead
extends Block {
    private int field_31053_a = -1;

    public BlockPistonHead(String key, int id) {
        super(key, id, Material.piston);
        this.withHardness(0.5f);
    }

    public void func_31052_a_(int i) {
        this.field_31053_a = i;
    }

    public void func_31051_a() {
        this.field_31053_a = -1;
    }

    @Override
    public void onBlockRemoval(World world, int x, int y, int z) {
        int i1;
        super.onBlockRemoval(world, x, y, z);
        int meta = world.getBlockMetadata(x, y, z);
        int direction = BlockPistonHead.getDirectionFromMeta(meta);
        if (direction >= 6) {
            return;
        }
        int orientation = PistonDirections.orientationMap[direction];
        int k1 = world.getBlockId(x += PistonDirections.xOffset[orientation], y += PistonDirections.yOffset[orientation], z += PistonDirections.zOffset[orientation]);
        if ((k1 == Block.pistonBase.id || k1 == Block.pistonBaseSticky.id) && BlockPistonBase.isPowered(i1 = world.getBlockMetadata(x, y, z))) {
            Block.blocksList[k1].dropBlockWithCause(world, EnumDropCause.PROPER_TOOL, x, y, z, i1, null);
            world.setBlockWithNotify(x, y, z, 0);
        }
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int meta) {
        int direction = BlockPistonHead.getDirectionFromMeta(meta);
        if (side.getId() == direction) {
            if (this.field_31053_a >= 0) {
                return this.field_31053_a;
            }
            if ((meta & 8) != 0) {
                return BlockPistonHead.texCoordToIndex(10, 6);
            }
            return BlockPistonHead.texCoordToIndex(11, 6);
        }
        return side.getId() != PistonDirections.orientationMap[direction] ? BlockPistonHead.texCoordToIndex(12, 6) : BlockPistonHead.texCoordToIndex(11, 6);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return false;
    }

    @Override
    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, int side) {
        return false;
    }

    public void getCollidingBoundingBoxes(World world, int x, int y, int z, AABB aabb, ArrayList aabbList) {
        int l = world.getBlockMetadata(x, y, z);
        switch (BlockPistonHead.getDirectionFromMeta(l)) {
            case 0: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.25f, 1.0f);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                this.setBlockBounds(0.375f, 0.25f, 0.375f, 0.625f, 1.0f, 0.625f);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                break;
            }
            case 1: {
                this.setBlockBounds(0.0f, 0.75f, 0.0f, 1.0f, 1.0f, 1.0f);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                this.setBlockBounds(0.375f, 0.0f, 0.375f, 0.625f, 0.75f, 0.625f);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                break;
            }
            case 2: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.25f);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                this.setBlockBounds(0.25f, 0.375f, 0.25f, 0.75f, 0.625f, 1.0f);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                break;
            }
            case 3: {
                this.setBlockBounds(0.0f, 0.0f, 0.75f, 1.0f, 1.0f, 1.0f);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                this.setBlockBounds(0.25f, 0.375f, 0.0f, 0.75f, 0.625f, 0.75f);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                break;
            }
            case 4: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.25f, 1.0f, 1.0f);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                this.setBlockBounds(0.375f, 0.25f, 0.25f, 0.625f, 0.75f, 1.0f);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                break;
            }
            case 5: {
                this.setBlockBounds(0.75f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                this.setBlockBounds(0.0f, 0.375f, 0.25f, 0.75f, 0.625f, 0.75f);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
            }
        }
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z);
        switch (BlockPistonHead.getDirectionFromMeta(l)) {
            case 0: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.25f, 1.0f);
                break;
            }
            case 1: {
                this.setBlockBounds(0.0f, 0.75f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 2: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.25f);
                break;
            }
            case 3: {
                this.setBlockBounds(0.0f, 0.0f, 0.75f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 4: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.25f, 1.0f, 1.0f);
                break;
            }
            case 5: {
                this.setBlockBounds(0.75f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        int direction = BlockPistonHead.getDirectionFromMeta(world.getBlockMetadata(x, y, z));
        if (direction >= 6) {
            return;
        }
        int id = world.getBlockId(x - PistonDirections.xOffset[direction], y - PistonDirections.yOffset[direction], z - PistonDirections.zOffset[direction]);
        if (id != Block.pistonBase.id && id != Block.pistonBaseSticky.id) {
            world.setBlockWithNotify(x, y, z, 0);
        } else {
            Block.blocksList[id].onNeighborBlockChange(world, x - PistonDirections.xOffset[direction], y - PistonDirections.yOffset[direction], z - PistonDirections.zOffset[direction], blockId);
        }
    }

    public static int getDirectionFromMeta(int meta) {
        return meta & 7;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        if (dropCause == EnumDropCause.PICK_BLOCK) {
            if ((meta & 8) != 0) {
                return new ItemStack[]{new ItemStack(Block.pistonBaseSticky)};
            }
            return new ItemStack[]{new ItemStack(Block.pistonBase)};
        }
        return null;
    }
}

