/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.logic.BedDirections;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.Colors;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.chunk.ChunkPosition;

public class BlockRedstoneWire
extends Block {
    private boolean wiresProvidePower = true;
    private Set field_21031_b = new HashSet();

    public BlockRedstoneWire(String key, int id) {
        super(key, id, Material.decoration);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return world.canPlaceOnSurfaceOfBlock(x, y - 1, z);
    }

    private void updateAndPropagateCurrentStrength(World world, int i, int j, int k) {
        this.func_21030_a(world, i, j, k, i, j, k);
        ArrayList arraylist = new ArrayList(this.field_21031_b);
        this.field_21031_b.clear();
        for (int l = 0; l < arraylist.size(); ++l) {
            ChunkPosition chunkposition = (ChunkPosition)arraylist.get(l);
            world.notifyBlocksOfNeighborChange(chunkposition.x, chunkposition.y, chunkposition.z, this.id);
        }
    }

    private void func_21030_a(World world, int i, int j, int k, int l, int i1, int j1) {
        int k1 = world.getBlockMetadata(i, j, k);
        int l1 = 0;
        this.wiresProvidePower = false;
        boolean flag = world.isBlockIndirectlyGettingPowered(i, j, k);
        this.wiresProvidePower = true;
        if (flag) {
            l1 = 15;
        } else {
            for (int i2 = 0; i2 < 4; ++i2) {
                int k2 = i;
                int i3 = k;
                if (i2 == 0) {
                    --k2;
                }
                if (i2 == 1) {
                    ++k2;
                }
                if (i2 == 2) {
                    --i3;
                }
                if (i2 == 3) {
                    ++i3;
                }
                if (k2 != l || j != i1 || i3 != j1) {
                    l1 = this.getMaxCurrentStrength(world, k2, j, i3, l1);
                }
                if (world.isBlockNormalCube(k2, j, i3) && !world.isBlockNormalCube(i, j + 1, k)) {
                    if (k2 == l && j + 1 == i1 && i3 == j1) continue;
                    l1 = this.getMaxCurrentStrength(world, k2, j + 1, i3, l1);
                    continue;
                }
                if (world.isBlockNormalCube(k2, j, i3) || k2 == l && j - 1 == i1 && i3 == j1) continue;
                l1 = this.getMaxCurrentStrength(world, k2, j - 1, i3, l1);
            }
            l1 = l1 > 0 ? --l1 : 0;
        }
        if (k1 != l1) {
            world.editingBlocks = true;
            world.setBlockMetadataWithNotify(i, j, k, l1);
            world.markBlocksDirty(i, j, k, i, j, k);
            world.editingBlocks = false;
            for (int j2 = 0; j2 < 4; ++j2) {
                int l2 = i;
                int j3 = k;
                int k3 = j - 1;
                if (j2 == 0) {
                    --l2;
                }
                if (j2 == 1) {
                    ++l2;
                }
                if (j2 == 2) {
                    --j3;
                }
                if (j2 == 3) {
                    ++j3;
                }
                if (world.isBlockNormalCube(l2, j, j3)) {
                    k3 += 2;
                }
                int l3 = 0;
                l3 = this.getMaxCurrentStrength(world, l2, j, j3, -1);
                l1 = world.getBlockMetadata(i, j, k);
                if (l1 > 0) {
                    --l1;
                }
                if (l3 >= 0 && l3 != l1) {
                    this.func_21030_a(world, l2, j, j3, i, j, k);
                }
                l3 = this.getMaxCurrentStrength(world, l2, k3, j3, -1);
                l1 = world.getBlockMetadata(i, j, k);
                if (l1 > 0) {
                    --l1;
                }
                if (l3 < 0 || l3 == l1) continue;
                this.func_21030_a(world, l2, k3, j3, i, j, k);
            }
            if (k1 == 0 || l1 == 0) {
                this.field_21031_b.add(new ChunkPosition(i, j, k));
                this.field_21031_b.add(new ChunkPosition(i - 1, j, k));
                this.field_21031_b.add(new ChunkPosition(i + 1, j, k));
                this.field_21031_b.add(new ChunkPosition(i, j - 1, k));
                this.field_21031_b.add(new ChunkPosition(i, j + 1, k));
                this.field_21031_b.add(new ChunkPosition(i, j, k - 1));
                this.field_21031_b.add(new ChunkPosition(i, j, k + 1));
            }
        }
    }

    private void notifyWireNeighborsOfNeighborChange(World world, int i, int j, int k) {
        if (world.getBlockId(i, j, k) != this.id) {
            return;
        }
        world.notifyBlocksOfNeighborChange(i, j, k, this.id);
        world.notifyBlocksOfNeighborChange(i - 1, j, k, this.id);
        world.notifyBlocksOfNeighborChange(i + 1, j, k, this.id);
        world.notifyBlocksOfNeighborChange(i, j, k - 1, this.id);
        world.notifyBlocksOfNeighborChange(i, j, k + 1, this.id);
        world.notifyBlocksOfNeighborChange(i, j - 1, k, this.id);
        world.notifyBlocksOfNeighborChange(i, j + 1, k, this.id);
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        super.onBlockAdded(world, i, j, k);
        if (world.isClientSide) {
            return;
        }
        this.updateAndPropagateCurrentStrength(world, i, j, k);
        world.notifyBlocksOfNeighborChange(i, j + 1, k, this.id);
        world.notifyBlocksOfNeighborChange(i, j - 1, k, this.id);
        this.notifyWireNeighborsOfNeighborChange(world, i - 1, j, k);
        this.notifyWireNeighborsOfNeighborChange(world, i + 1, j, k);
        this.notifyWireNeighborsOfNeighborChange(world, i, j, k - 1);
        this.notifyWireNeighborsOfNeighborChange(world, i, j, k + 1);
        if (world.isBlockNormalCube(i - 1, j, k)) {
            this.notifyWireNeighborsOfNeighborChange(world, i - 1, j + 1, k);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i - 1, j - 1, k);
        }
        if (world.isBlockNormalCube(i + 1, j, k)) {
            this.notifyWireNeighborsOfNeighborChange(world, i + 1, j + 1, k);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i + 1, j - 1, k);
        }
        if (world.isBlockNormalCube(i, j, k - 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, i, j + 1, k - 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i, j - 1, k - 1);
        }
        if (world.isBlockNormalCube(i, j, k + 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, i, j + 1, k + 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i, j - 1, k + 1);
        }
    }

    @Override
    public void onBlockRemoval(World world, int x, int y, int z) {
        super.onBlockRemoval(world, x, y, z);
        if (world.isClientSide) {
            return;
        }
        world.notifyBlocksOfNeighborChange(x, y + 1, z, this.id);
        world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
        this.updateAndPropagateCurrentStrength(world, x, y, z);
        this.notifyWireNeighborsOfNeighborChange(world, x - 1, y, z);
        this.notifyWireNeighborsOfNeighborChange(world, x + 1, y, z);
        this.notifyWireNeighborsOfNeighborChange(world, x, y, z - 1);
        this.notifyWireNeighborsOfNeighborChange(world, x, y, z + 1);
        if (world.isBlockNormalCube(x - 1, y, z)) {
            this.notifyWireNeighborsOfNeighborChange(world, x - 1, y + 1, z);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, x - 1, y - 1, z);
        }
        if (world.isBlockNormalCube(x + 1, y, z)) {
            this.notifyWireNeighborsOfNeighborChange(world, x + 1, y + 1, z);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, x + 1, y - 1, z);
        }
        if (world.isBlockNormalCube(x, y, z - 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, x, y + 1, z - 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, x, y - 1, z - 1);
        }
        if (world.isBlockNormalCube(x, y, z + 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, x, y + 1, z + 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, x, y - 1, z + 1);
        }
    }

    private int getMaxCurrentStrength(World world, int i, int j, int k, int l) {
        if (world.getBlockId(i, j, k) != this.id) {
            return l;
        }
        int i1 = world.getBlockMetadata(i, j, k);
        if (i1 > l) {
            return i1;
        }
        return l;
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (world.isClientSide) {
            return;
        }
        int i1 = world.getBlockMetadata(x, y, z);
        boolean flag = this.canPlaceBlockAt(world, x, y, z);
        if (!flag) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, i1, null);
            world.setBlockWithNotify(x, y, z, 0);
        } else {
            this.updateAndPropagateCurrentStrength(world, x, y, z);
        }
        super.onNeighborBlockChange(world, x, y, z, blockId);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Item.dustRedstone)};
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int x, int y, int z, int side) {
        if (!this.wiresProvidePower) {
            return false;
        }
        return this.isPoweringTo(world, x, y, z, side);
    }

    @Override
    public boolean isPoweringTo(WorldSource blockAccess, int x, int y, int z, int side) {
        boolean flag3;
        if (!this.wiresProvidePower) {
            return false;
        }
        if (blockAccess.getBlockMetadata(x, y, z) == 0) {
            return false;
        }
        if (side == 1) {
            return true;
        }
        boolean flag = BlockRedstoneWire.isPowerProviderOrWire(blockAccess, x - 1, y, z, 1) || !blockAccess.isBlockNormalCube(x - 1, y, z) && BlockRedstoneWire.isPowerProviderOrWire(blockAccess, x - 1, y - 1, z, -1);
        boolean flag1 = BlockRedstoneWire.isPowerProviderOrWire(blockAccess, x + 1, y, z, 3) || !blockAccess.isBlockNormalCube(x + 1, y, z) && BlockRedstoneWire.isPowerProviderOrWire(blockAccess, x + 1, y - 1, z, -1);
        boolean flag2 = BlockRedstoneWire.isPowerProviderOrWire(blockAccess, x, y, z - 1, 2) || !blockAccess.isBlockNormalCube(x, y, z - 1) && BlockRedstoneWire.isPowerProviderOrWire(blockAccess, x, y - 1, z - 1, -1);
        boolean bl = flag3 = BlockRedstoneWire.isPowerProviderOrWire(blockAccess, x, y, z + 1, 0) || !blockAccess.isBlockNormalCube(x, y, z + 1) && BlockRedstoneWire.isPowerProviderOrWire(blockAccess, x, y - 1, z + 1, -1);
        if (!blockAccess.isBlockNormalCube(x, y + 1, z)) {
            if (blockAccess.isBlockNormalCube(x - 1, y, z) && BlockRedstoneWire.isPowerProviderOrWire(blockAccess, x - 1, y + 1, z, -1)) {
                flag = true;
            }
            if (blockAccess.isBlockNormalCube(x + 1, y, z) && BlockRedstoneWire.isPowerProviderOrWire(blockAccess, x + 1, y + 1, z, -1)) {
                flag1 = true;
            }
            if (blockAccess.isBlockNormalCube(x, y, z - 1) && BlockRedstoneWire.isPowerProviderOrWire(blockAccess, x, y + 1, z - 1, -1)) {
                flag2 = true;
            }
            if (blockAccess.isBlockNormalCube(x, y, z + 1) && BlockRedstoneWire.isPowerProviderOrWire(blockAccess, x, y + 1, z + 1, -1)) {
                flag3 = true;
            }
        }
        if (!(flag2 || flag1 || flag || flag3 || side < 2 || side > 5)) {
            return true;
        }
        if (side == 2 && flag2 && !flag && !flag1) {
            return true;
        }
        if (side == 3 && flag3 && !flag && !flag1) {
            return true;
        }
        if (side == 4 && flag && !flag2 && !flag3) {
            return true;
        }
        return side == 5 && flag1 && !flag2 && !flag3;
    }

    @Override
    public boolean canProvidePower() {
        return this.wiresProvidePower;
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta > 0) {
            double d = (double)x + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
            double d1 = (float)y + 0.0625f;
            double d2 = (double)z + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
            Color color = Colors.allRedstoneColors[meta & 0xF];
            float red = (float)color.getRed() / 255.0f;
            float green = (float)color.getGreen() / 255.0f;
            float blue = (float)color.getBlue() / 255.0f;
            world.spawnParticle("reddust", d, d1, d2, red, green, blue);
        }
    }

    public static boolean isPowerProviderOrWire(WorldSource iblockaccess, int i, int j, int k, int l) {
        int i1 = iblockaccess.getBlockId(i, j, k);
        if (i1 == Block.wireRedstone.id) {
            return true;
        }
        if (i1 == 0) {
            return false;
        }
        if (Block.blocksList[i1].canProvidePower()) {
            return true;
        }
        if (i1 == Block.repeaterIdle.id || i1 == Block.repeaterActive.id) {
            int j1 = iblockaccess.getBlockMetadata(i, j, k);
            return l == BedDirections.field_22279_b[j1 & 3];
        }
        return false;
    }
}

