/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockStairs
extends Block {
    private Block modelBlock;

    public BlockStairs(Block block, int id) {
        super("stairs." + block.key.substring(5), id, block.blockMaterial);
        this.modelBlock = block;
        this.atlasIndices = block.atlasIndices;
        this.withHardness(block.blockHardness);
        this.withBlastResistance(block.blastResistance / 3.0f);
        this.withLightOpacity(255);
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int x, int y, int z) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return super.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, int x, int y, int z, int side) {
        return super.shouldSideBeRendered(blockAccess, x, y, z, side);
    }

    public void getCollidingBoundingBoxes(World world, int x, int y, int z, AABB aabb, ArrayList aabbList) {
        float stepYOffset;
        int meta = world.getBlockMetadata(x, y, z);
        int hRotation = meta & 3;
        int vRotation = meta & 8;
        float f = stepYOffset = vRotation > 0 ? 0.5f : 0.0f;
        if (hRotation == 0) {
            this.setBlockBounds(0.0f, 0.0f + stepYOffset, 0.0f, 0.5f, 0.5f + stepYOffset, 1.0f);
            super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
            this.setBlockBounds(0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
        } else if (hRotation == 1) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f);
            super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
            this.setBlockBounds(0.5f, 0.0f + stepYOffset, 0.0f, 1.0f, 0.5f + stepYOffset, 1.0f);
            super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
        } else if (hRotation == 2) {
            this.setBlockBounds(0.0f, 0.0f + stepYOffset, 0.0f, 1.0f, 0.5f + stepYOffset, 0.5f);
            super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
            this.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f);
            super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
            super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
            this.setBlockBounds(0.0f, 0.0f + stepYOffset, 0.5f, 1.0f, 0.5f + stepYOffset, 1.0f);
            super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
        }
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        ItemStack[] result = this.modelBlock.getBreakResult(world, dropCause, x, y, z, 0, tileEntity);
        if (result != null) {
            for (ItemStack stack : result) {
                if (stack.itemID != this.modelBlock.id) continue;
                stack.setMetadata(meta & 0xF0);
                stack.itemID = this.id;
            }
        }
        return result;
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        this.modelBlock.randomDisplayTick(world, x, y, z, rand);
    }

    @Override
    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        this.modelBlock.onBlockClicked(world, x, y, z, player);
    }

    @Override
    public float getBlockBrightness(WorldSource blockAccess, int x, int y, int z) {
        return this.modelBlock.getBlockBrightness(blockAccess, x, y, z);
    }

    @Override
    public float getBlastResistance(Entity entity) {
        return this.modelBlock.getBlastResistance(entity);
    }

    @Override
    public int getRenderBlockPass() {
        return this.modelBlock.getRenderBlockPass();
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int meta) {
        return this.modelBlock.getBlockTextureFromSideAndMetadata(side, meta);
    }

    @Override
    public int getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        return this.modelBlock.getBlockTexture(blockAccess, x, y, z, side);
    }

    @Override
    public int tickRate() {
        return this.modelBlock.tickRate();
    }

    @Override
    public AABB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        return this.modelBlock.getSelectedBoundingBoxFromPool(world, x, y, z);
    }

    @Override
    public void velocityToAddToEntity(World world, int x, int y, int z, Entity entity, Vec3d entityVelocity) {
        this.modelBlock.velocityToAddToEntity(world, x, y, z, entity, entityVelocity);
    }

    @Override
    public boolean isCollidable() {
        return this.modelBlock.isCollidable();
    }

    @Override
    public boolean canCollideCheck(int meta, boolean shouldCollideWithFluids) {
        return this.modelBlock.canCollideCheck(meta, shouldCollideWithFluids);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return this.modelBlock.canPlaceBlockAt(world, x, y, z);
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        this.onNeighborBlockChange(world, i, j, k, 0);
        this.modelBlock.onBlockAdded(world, i, j, k);
    }

    @Override
    public void onEntityWalking(World world, int x, int y, int z, Entity entity) {
        this.modelBlock.onEntityWalking(world, x, y, z, entity);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        this.modelBlock.updateTick(world, x, y, z, rand);
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        return this.modelBlock.blockActivated(world, x, y, z, player);
    }

    @Override
    public void onBlockDestroyedByExplosion(World world, int x, int y, int z) {
        this.modelBlock.onBlockDestroyedByExplosion(world, x, y, z);
    }

    @Override
    public void onBlockPlaced(World world, int x, int y, int z, Side side, EntityLiving entity, double sideHeight) {
        Direction vRotation;
        System.out.println("Placed Side: " + (Object)((Object)side) + " Height: " + sideHeight);
        int meta = world.getBlockMetadata(x, y, z) & 0xF0;
        Direction hRotation = entity.getHorizontalPlacementDirection(side).getOpposite();
        if (hRotation == Direction.NORTH) {
            meta |= 2;
        }
        if (hRotation == Direction.EAST) {
            meta |= 1;
        }
        if (hRotation == Direction.SOUTH) {
            meta |= 3;
        }
        if (hRotation == Direction.WEST) {
            meta |= 0;
        }
        if ((vRotation = entity.getVerticalPlacementDirection(side, sideHeight)) == Direction.DOWN) {
            meta |= 0;
        }
        if (vRotation == Direction.UP) {
            meta |= 8;
        }
        world.setBlockMetadataWithNotify(x, y, z, meta);
    }
}

