/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.entity;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.ListTag;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockBlastFurnace;
import net.minecraft.core.block.entity.TileEntityFurnace;
import net.minecraft.core.crafting.LookupFuelFurnaceBlast;
import net.minecraft.core.crafting.recipe.RecipesBlastFurnace;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.IInventory;

public class TileEntityBlastFurnace
extends TileEntityFurnace
implements IInventory {
    public TileEntityBlastFurnace() {
        this.maxCookTime = 100;
    }

    @Override
    public String getInvName() {
        return "BlastFurnace";
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        ListTag nbttaglist = nbttagcompound.getList("Items");
        this.furnaceItemStacks = new ItemStack[this.getSizeInventory()];
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            CompoundTag nbttagcompound1 = (CompoundTag)nbttaglist.tagAt(i);
            byte byte0 = nbttagcompound1.getByte("Slot");
            if (byte0 < 0 || byte0 >= this.furnaceItemStacks.length) continue;
            this.furnaceItemStacks[byte0] = ItemStack.readItemStackFromNbt(nbttagcompound1);
        }
        this.currentBurnTime = nbttagcompound.getShort("BurnTime");
        this.currentCookTime = nbttagcompound.getShort("CookTime");
        this.maxBurnTime = nbttagcompound.getShort("MaxBurnTime");
    }

    @Override
    public void writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putShort("BurnTime", (short)this.currentBurnTime);
        nbttagcompound.putShort("CookTime", (short)this.currentCookTime);
        nbttagcompound.putShort("MaxBurnTime", (short)this.maxBurnTime);
        ListTag nbttaglist = new ListTag();
        for (int i = 0; i < this.furnaceItemStacks.length; ++i) {
            if (this.furnaceItemStacks[i] == null) continue;
            CompoundTag itemStackAtSlot = new CompoundTag();
            itemStackAtSlot.putByte("Slot", (byte)i);
            this.furnaceItemStacks[i].writeToNBT(itemStackAtSlot);
            nbttaglist.addTag(itemStackAtSlot);
        }
        nbttagcompound.put("Items", nbttaglist);
    }

    @Override
    public void updateEntity() {
        boolean isBurnTimeHigherThan0 = this.currentBurnTime > 0;
        boolean furnaceUpdated = false;
        if (this.currentBurnTime > 0) {
            --this.currentBurnTime;
        }
        if (!this.worldObj.isClientSide) {
            if (this.worldObj.getBlockId(this.xCoord, this.yCoord, this.zCoord) == Block.furnaceBlastIdle.id && this.currentBurnTime == 0 && this.furnaceItemStacks[0] == null && this.furnaceItemStacks[1] != null && this.furnaceItemStacks[1].itemID == Block.netherrack.id) {
                --this.furnaceItemStacks[1].stackSize;
                if (this.furnaceItemStacks[1].stackSize <= 0) {
                    this.furnaceItemStacks[1] = null;
                }
                BlockBlastFurnace.updateFurnaceBlockState(true, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
                furnaceUpdated = true;
            }
            if (this.currentBurnTime == 0 && this.canSmelt()) {
                this.maxBurnTime = this.currentBurnTime = this.getBurnTimeFromItem(this.furnaceItemStacks[1]);
                if (this.currentBurnTime > 0) {
                    furnaceUpdated = true;
                    if (this.furnaceItemStacks[1] != null) {
                        --this.furnaceItemStacks[1].stackSize;
                        if (this.furnaceItemStacks[1].stackSize <= 0) {
                            this.furnaceItemStacks[1] = null;
                        }
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.currentCookTime;
                if (this.currentCookTime == this.maxCookTime) {
                    this.currentCookTime = 0;
                    this.smeltItem();
                    furnaceUpdated = true;
                }
            } else {
                this.currentCookTime = 0;
            }
            if (isBurnTimeHigherThan0 != this.currentBurnTime > 0) {
                furnaceUpdated = true;
                this.updateFurnace();
            }
        }
        if (furnaceUpdated) {
            this.onInventoryChanged();
        }
    }

    @Override
    protected void updateFurnace() {
        BlockBlastFurnace.updateFurnaceBlockState(this.currentBurnTime > 0, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    private boolean canSmelt() {
        if (this.furnaceItemStacks[0] == null) {
            return false;
        }
        ItemStack itemstack = RecipesBlastFurnace.smelting().getSmeltingResult(this.furnaceItemStacks[0].getItem().id);
        if (itemstack == null) {
            return false;
        }
        if (this.furnaceItemStacks[2] == null) {
            return true;
        }
        if (!this.furnaceItemStacks[2].isItemEqual(itemstack)) {
            return false;
        }
        if (this.furnaceItemStacks[2].stackSize < this.getInventoryStackLimit() && this.furnaceItemStacks[2].stackSize < this.furnaceItemStacks[2].getMaxStackSize()) {
            return true;
        }
        return this.furnaceItemStacks[2].stackSize < itemstack.getMaxStackSize();
    }

    @Override
    public void smeltItem() {
        if (!this.canSmelt()) {
            return;
        }
        ItemStack itemstack = RecipesBlastFurnace.smelting().getSmeltingResult(this.furnaceItemStacks[0].getItem().id);
        if (this.furnaceItemStacks[2] == null) {
            this.furnaceItemStacks[2] = itemstack.copy();
        } else if (this.furnaceItemStacks[2].itemID == itemstack.itemID) {
            ++this.furnaceItemStacks[2].stackSize;
        }
        --this.furnaceItemStacks[0].stackSize;
        if (this.furnaceItemStacks[0].stackSize <= 0) {
            this.furnaceItemStacks[0] = null;
        }
    }

    private int getBurnTimeFromItem(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        return LookupFuelFurnaceBlast.instance.getFuelYield(itemStack.getItem().id);
    }
}

